/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.context;

import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathNodeTest;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.validation.inspections.XPathInspection;
import org.intellij.lang.xpath.validation.inspections.quickfix.MakeTypeExplicitFix;
import org.intellij.lang.xpath.validation.inspections.quickfix.RemoveExplicitConversionFix;
import org.intellij.lang.xpath.validation.inspections.quickfix.RemoveRedundantConversionFix;
import org.intellij.lang.xpath.validation.inspections.quickfix.XPathQuickFixFactory;
import org.intellij.lang.xpath.xslt.associations.impl.FileAssociationsConfigurable;
import org.intellij.lang.xpath.xslt.validation.inspections.InspectionUtil;
import org.jetbrains.annotations.NotNull;

public class XsltQuickFixFactory
implements XPathQuickFixFactory {
    public static final XsltQuickFixFactory INSTANCE = new XsltQuickFixFactory();

    private XsltQuickFixFactory() {
    }

    @Override
    public XPathQuickFixFactory.Fix<XPathExpression>[] createImplicitTypeConversionFixes(XPathExpression expression, XPathType type, boolean explicit) {
        XPathQuickFixFactory.Fix[] fixArray;
        if (explicit) {
            XPathQuickFixFactory.Fix[] fixArray2 = new XPathQuickFixFactory.Fix[2];
            fixArray2[0] = new RemoveExplicitConversionFix(expression);
            fixArray = fixArray2;
            fixArray2[1] = new MakeTypeExplicitFix(expression, type);
        } else {
            XPathQuickFixFactory.Fix[] fixArray3 = new XPathQuickFixFactory.Fix[1];
            fixArray = fixArray3;
            fixArray3[0] = new MakeTypeExplicitFix(expression, type);
        }
        return fixArray;
    }

    @Override
    public XPathQuickFixFactory.Fix<XPathExpression>[] createRedundantTypeConversionFixes(XPathExpression expression) {
        return new XPathQuickFixFactory.Fix[]{new RemoveRedundantConversionFix(expression)};
    }

    @Override
    public XPathQuickFixFactory.Fix<XPathNodeTest>[] createUnknownNodeTestFixes(XPathNodeTest test) {
        return new XPathQuickFixFactory.Fix[]{new EditAssociationsFix(test)};
    }

    @Override
    @NotNull
    public SuppressIntentionAction[] getSuppressActions(XPathInspection inspection) {
        List<SuppressIntentionAction> actions = InspectionUtil.getSuppressActions(inspection, true);
        SuppressIntentionAction[] suppressIntentionActionArray = actions.toArray(SuppressIntentionAction.EMPTY_ARRAY);
        if (suppressIntentionActionArray == null) {
            XsltQuickFixFactory.$$$reportNull$$$0(0);
        }
        return suppressIntentionActionArray;
    }

    @Override
    public boolean isSuppressedFor(PsiElement element, XPathInspection inspection) {
        return InspectionUtil.isSuppressed(inspection, element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/context/XsltQuickFixFactory", "getSuppressActions"));
    }

    private static class EditAssociationsFix
    extends XPathQuickFixFactory.Fix<XPathNodeTest> {
        EditAssociationsFix(XPathNodeTest test) {
            super(test);
        }

        public boolean startInWriteAction() {
            return false;
        }

        @Override
        protected void invokeImpl(Project project, PsiFile file) throws IncorrectOperationException {
            FileAssociationsConfigurable.editAssociations(project, (PsiFile)PsiTreeUtil.getContextOfType((PsiElement)file, XmlFile.class, (boolean)false));
        }

        @NotNull
        public String getText() {
            if ("Edit File Associations" == null) {
                EditAssociationsFix.$$$reportNull$$$0(0);
            }
            return "Edit File Associations";
        }

        @NotNull
        public String getFamilyName() {
            if ("Edit File Associations" == null) {
                EditAssociationsFix.$$$reportNull$$$0(1);
            }
            return "Edit File Associations";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/intellij/lang/xpath/xslt/context/XsltQuickFixFactory$EditAssociationsFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

