/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.split;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.SplitEditorToolbar;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.JBSplitter;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.settings.MarkdownApplicationSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SplitFileEditor<E1 extends FileEditor, E2 extends FileEditor>
extends UserDataHolderBase
implements FileEditor {
    public static final Key<SplitFileEditor> PARENT_SPLIT_KEY = Key.create((String)"parentSplit");
    private static final String MY_PROPORTION_KEY = "SplitFileEditor.Proportion";
    @NotNull
    protected final E1 myMainEditor;
    @NotNull
    protected final E2 mySecondEditor;
    @NotNull
    private final JComponent myComponent;
    @NotNull
    private SplitEditorLayout mySplitEditorLayout;
    private boolean myVerticalSplitOption;
    @NotNull
    private final MyListenersMultimap myListenersGenerator;
    private SplitEditorToolbar myToolbarWrapper;
    private JBSplitter mySplitter;

    public SplitFileEditor(@NotNull E1 mainEditor, @NotNull E2 secondEditor) {
        if (mainEditor == null) {
            SplitFileEditor.$$$reportNull$$$0(0);
        }
        if (secondEditor == null) {
            SplitFileEditor.$$$reportNull$$$0(1);
        }
        this.mySplitEditorLayout = MarkdownApplicationSettings.getInstance().getMarkdownPreviewSettings().getSplitEditorLayout();
        this.myVerticalSplitOption = MarkdownApplicationSettings.getInstance().getMarkdownPreviewSettings().isVerticalSplit();
        this.myListenersGenerator = new MyListenersMultimap();
        this.myMainEditor = mainEditor;
        this.mySecondEditor = secondEditor;
        this.myComponent = this.createComponent();
        if (this.myMainEditor instanceof TextEditor) {
            this.myMainEditor.putUserData(PARENT_SPLIT_KEY, (Object)this);
        }
        if (this.mySecondEditor instanceof TextEditor) {
            this.mySecondEditor.putUserData(PARENT_SPLIT_KEY, (Object)this);
        }
        MarkdownApplicationSettings.SettingsChangedListener settingsChangedListener = new MarkdownApplicationSettings.SettingsChangedListener(){

            @Override
            public void beforeSettingsChanged(@NotNull MarkdownApplicationSettings newSettings) {
                if (newSettings == null) {
                    1.$$$reportNull$$$0(0);
                }
                SplitEditorLayout oldSplitEditorLayout = MarkdownApplicationSettings.getInstance().getMarkdownPreviewSettings().getSplitEditorLayout();
                boolean oldVerticalSplitOption = MarkdownApplicationSettings.getInstance().getMarkdownPreviewSettings().isVerticalSplit();
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (oldSplitEditorLayout == SplitFileEditor.this.mySplitEditorLayout) {
                        SplitFileEditor.this.triggerLayoutChange(newSettings.getMarkdownPreviewSettings().getSplitEditorLayout(), false);
                    }
                    if (oldVerticalSplitOption == SplitFileEditor.this.myVerticalSplitOption) {
                        SplitFileEditor.this.triggerSplitOrientationChange(newSettings.getMarkdownPreviewSettings().isVerticalSplit());
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSettings", "org/intellij/plugins/markdown/ui/split/SplitFileEditor$1", "beforeSettingsChanged"));
            }
        };
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(MarkdownApplicationSettings.SettingsChangedListener.TOPIC, (Object)settingsChangedListener);
    }

    private void triggerSplitOrientationChange(boolean isVerticalSplit) {
        if (this.myVerticalSplitOption == isVerticalSplit) {
            return;
        }
        this.myVerticalSplitOption = isVerticalSplit;
        this.myToolbarWrapper.refresh();
        this.mySplitter.setOrientation(!this.myVerticalSplitOption);
        this.myComponent.repaint();
    }

    @NotNull
    private JComponent createComponent() {
        this.mySplitter = new JBSplitter(!MarkdownApplicationSettings.getInstance().getMarkdownPreviewSettings().isVerticalSplit(), 0.5f, 0.15f, 0.85f);
        this.mySplitter.setSplitterProportionKey(MY_PROPORTION_KEY);
        this.mySplitter.setFirstComponent(this.myMainEditor.getComponent());
        this.mySplitter.setSecondComponent(this.mySecondEditor.getComponent());
        this.mySplitter.setDividerWidth(3);
        this.myToolbarWrapper = SplitFileEditor.createMarkdownToolbarWrapper((JComponent)this.mySplitter);
        Disposer.register((Disposable)this, (Disposable)this.myToolbarWrapper);
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)this.myToolbarWrapper, "North");
        result.add((Component)this.mySplitter, "Center");
        this.adjustEditorsVisibility();
        JPanel jPanel = result;
        if (jPanel == null) {
            SplitFileEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @NotNull
    private static SplitEditorToolbar createMarkdownToolbarWrapper(@NotNull JComponent targetComponentForActions) {
        if (targetComponentForActions == null) {
            SplitFileEditor.$$$reportNull$$$0(3);
        }
        ActionToolbar leftToolbar = SplitFileEditor.createToolbarFromGroupId("Markdown.Toolbar.Left");
        leftToolbar.setTargetComponent(targetComponentForActions);
        leftToolbar.setReservePlaceAutoPopupIcon(false);
        ActionToolbar rightToolbar = SplitFileEditor.createToolbarFromGroupId("Markdown.Toolbar.Right");
        rightToolbar.setTargetComponent(targetComponentForActions);
        rightToolbar.setReservePlaceAutoPopupIcon(false);
        SplitEditorToolbar splitEditorToolbar = new SplitEditorToolbar(leftToolbar, rightToolbar);
        if (splitEditorToolbar == null) {
            SplitFileEditor.$$$reportNull$$$0(4);
        }
        return splitEditorToolbar;
    }

    @NotNull
    private static ActionToolbar createToolbarFromGroupId(@NotNull String groupId) {
        ActionManager actionManager;
        if (groupId == null) {
            SplitFileEditor.$$$reportNull$$$0(5);
        }
        if (!(actionManager = ActionManager.getInstance()).isGroup(groupId)) {
            throw new IllegalStateException(groupId + " should have been a group");
        }
        ActionGroup group = (ActionGroup)actionManager.getAction(groupId);
        ActionToolbarImpl editorToolbar = (ActionToolbarImpl)actionManager.createActionToolbar("EditorToolbar", group, true);
        editorToolbar.setOpaque(false);
        editorToolbar.setBorder((Border)new JBEmptyBorder(0, 2, 0, 2));
        ActionToolbarImpl actionToolbarImpl = editorToolbar;
        if (actionToolbarImpl == null) {
            SplitFileEditor.$$$reportNull$$$0(6);
        }
        return actionToolbarImpl;
    }

    public void triggerLayoutChange() {
        int oldValue = this.mySplitEditorLayout.ordinal();
        int N = SplitEditorLayout.values().length;
        int newValue = (oldValue + N - 1) % N;
        this.triggerLayoutChange(SplitEditorLayout.values()[newValue], true);
    }

    public void triggerLayoutChange(@NotNull SplitEditorLayout newLayout, boolean requestFocus) {
        if (newLayout == null) {
            SplitFileEditor.$$$reportNull$$$0(7);
        }
        if (this.mySplitEditorLayout == newLayout) {
            return;
        }
        this.mySplitEditorLayout = newLayout;
        this.invalidateLayout(requestFocus);
    }

    @NotNull
    public SplitEditorLayout getCurrentEditorLayout() {
        SplitEditorLayout splitEditorLayout = this.mySplitEditorLayout;
        if (splitEditorLayout == null) {
            SplitFileEditor.$$$reportNull$$$0(8);
        }
        return splitEditorLayout;
    }

    private void invalidateLayout(boolean requestFocus) {
        this.adjustEditorsVisibility();
        this.myToolbarWrapper.refresh();
        this.myComponent.repaint();
        if (!requestFocus) {
            return;
        }
        JComponent focusComponent = this.getPreferredFocusedComponent();
        if (focusComponent != null) {
            IdeFocusManager.findInstanceByComponent((Component)focusComponent).requestFocus((Component)focusComponent, true);
        }
    }

    private void adjustEditorsVisibility() {
        this.myMainEditor.getComponent().setVisible(this.mySplitEditorLayout.showFirst);
        this.mySecondEditor.getComponent().setVisible(this.mySplitEditorLayout.showSecond);
    }

    @NotNull
    public E1 getMainEditor() {
        E1 E1 = this.myMainEditor;
        if (E1 == null) {
            SplitFileEditor.$$$reportNull$$$0(9);
        }
        return E1;
    }

    @NotNull
    public E2 getSecondEditor() {
        E2 E2 = this.mySecondEditor;
        if (E2 == null) {
            SplitFileEditor.$$$reportNull$$$0(10);
        }
        return E2;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            SplitFileEditor.$$$reportNull$$$0(11);
        }
        return jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (this.mySplitEditorLayout.showFirst) {
            return this.myMainEditor.getPreferredFocusedComponent();
        }
        if (this.mySplitEditorLayout.showSecond) {
            return this.mySecondEditor.getPreferredFocusedComponent();
        }
        return null;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            SplitFileEditor.$$$reportNull$$$0(12);
        }
        MyFileEditorState myFileEditorState = new MyFileEditorState(this.mySplitEditorLayout.name(), this.myMainEditor.getState(level), this.mySecondEditor.getState(level));
        if (myFileEditorState == null) {
            SplitFileEditor.$$$reportNull$$$0(13);
        }
        return myFileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            SplitFileEditor.$$$reportNull$$$0(14);
        }
        if (state instanceof MyFileEditorState) {
            MyFileEditorState compositeState = (MyFileEditorState)state;
            if (compositeState.getFirstState() != null) {
                this.myMainEditor.setState(compositeState.getFirstState());
            }
            if (compositeState.getSecondState() != null) {
                this.mySecondEditor.setState(compositeState.getSecondState());
            }
            if (compositeState.getSplitLayout() != null) {
                this.mySplitEditorLayout = SplitEditorLayout.valueOf(compositeState.getSplitLayout());
                this.invalidateLayout(true);
            }
        }
    }

    public boolean isModified() {
        return this.myMainEditor.isModified() || this.mySecondEditor.isModified();
    }

    public boolean isValid() {
        return this.myMainEditor.isValid() && this.mySecondEditor.isValid();
    }

    public void selectNotify() {
        this.myMainEditor.selectNotify();
        this.mySecondEditor.selectNotify();
    }

    public void deselectNotify() {
        this.myMainEditor.deselectNotify();
        this.mySecondEditor.deselectNotify();
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            SplitFileEditor.$$$reportNull$$$0(15);
        }
        this.myMainEditor.addPropertyChangeListener(listener);
        this.mySecondEditor.addPropertyChangeListener(listener);
        DoublingEventListenerDelegate delegate = this.myListenersGenerator.addListenerAndGetDelegate(listener);
        this.myMainEditor.addPropertyChangeListener((PropertyChangeListener)delegate);
        this.mySecondEditor.addPropertyChangeListener((PropertyChangeListener)delegate);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            SplitFileEditor.$$$reportNull$$$0(16);
        }
        this.myMainEditor.removePropertyChangeListener(listener);
        this.mySecondEditor.removePropertyChangeListener(listener);
        DoublingEventListenerDelegate delegate = this.myListenersGenerator.removeListenerAndGetDelegate(listener);
        if (delegate != null) {
            this.myMainEditor.removePropertyChangeListener((PropertyChangeListener)delegate);
            this.mySecondEditor.removePropertyChangeListener((PropertyChangeListener)delegate);
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return this.myMainEditor.getBackgroundHighlighter();
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return this.myMainEditor.getCurrentLocation();
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return this.myMainEditor.getStructureViewBuilder();
    }

    public void dispose() {
        Disposer.dispose(this.myMainEditor);
        Disposer.dispose(this.mySecondEditor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondEditor";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/ui/split/SplitFileEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetComponentForActions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newLayout";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/ui/split/SplitFileEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createMarkdownToolbarWrapper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarFromGroupId";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentEditorLayout";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainEditor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSecondEditor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createMarkdownToolbarWrapper";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createToolbarFromGroupId";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "triggerLayoutChange";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum SplitEditorLayout {
        FIRST(true, false, MarkdownBundle.message("markdown.layout.editor.only", new Object[0])),
        SECOND(false, true, MarkdownBundle.message("markdown.layout.preview.only", new Object[0])),
        SPLIT(true, true, MarkdownBundle.message("markdown.layout.editor.and.preview", new Object[0]));

        public final boolean showFirst;
        public final boolean showSecond;
        public final String presentationName;

        private SplitEditorLayout(boolean showFirst, boolean showSecond, String presentationName) {
            this.showFirst = showFirst;
            this.showSecond = showSecond;
            this.presentationName = presentationName;
        }

        public String getPresentationText() {
            return StringUtil.capitalize((String)StringUtil.substringAfter((String)this.presentationName, (String)"Show "));
        }

        public String toString() {
            return this.presentationName;
        }
    }

    private class MyListenersMultimap {
        private final Map<PropertyChangeListener, Pair<Integer, DoublingEventListenerDelegate>> myMap = new HashMap<PropertyChangeListener, Pair<Integer, DoublingEventListenerDelegate>>();

        private MyListenersMultimap() {
        }

        @NotNull
        public DoublingEventListenerDelegate addListenerAndGetDelegate(@NotNull PropertyChangeListener listener) {
            if (listener == null) {
                MyListenersMultimap.$$$reportNull$$$0(0);
            }
            if (!this.myMap.containsKey(listener)) {
                this.myMap.put(listener, (Pair<Integer, DoublingEventListenerDelegate>)Pair.create((Object)1, (Object)new DoublingEventListenerDelegate(listener)));
            } else {
                Pair<Integer, DoublingEventListenerDelegate> oldPair = this.myMap.get(listener);
                this.myMap.put(listener, (Pair<Integer, DoublingEventListenerDelegate>)Pair.create((Object)((Integer)oldPair.getFirst() + 1), (Object)oldPair.getSecond()));
            }
            DoublingEventListenerDelegate doublingEventListenerDelegate = (DoublingEventListenerDelegate)this.myMap.get(listener).getSecond();
            if (doublingEventListenerDelegate == null) {
                MyListenersMultimap.$$$reportNull$$$0(1);
            }
            return doublingEventListenerDelegate;
        }

        @Nullable
        public DoublingEventListenerDelegate removeListenerAndGetDelegate(@NotNull PropertyChangeListener listener) {
            Pair<Integer, DoublingEventListenerDelegate> oldPair;
            if (listener == null) {
                MyListenersMultimap.$$$reportNull$$$0(2);
            }
            if ((oldPair = this.myMap.get(listener)) == null) {
                return null;
            }
            if ((Integer)oldPair.getFirst() == 1) {
                this.myMap.remove(listener);
            } else {
                this.myMap.put(listener, (Pair<Integer, DoublingEventListenerDelegate>)Pair.create((Object)((Integer)oldPair.getFirst() - 1), (Object)oldPair.getSecond()));
            }
            return (DoublingEventListenerDelegate)oldPair.getSecond();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/plugins/markdown/ui/split/SplitFileEditor$MyListenersMultimap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/plugins/markdown/ui/split/SplitFileEditor$MyListenersMultimap";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addListenerAndGetDelegate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addListenerAndGetDelegate";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "removeListenerAndGetDelegate";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class DoublingEventListenerDelegate
    implements PropertyChangeListener {
        @NotNull
        private final PropertyChangeListener myDelegate;

        private DoublingEventListenerDelegate(PropertyChangeListener delegate) {
            if (delegate == null) {
                DoublingEventListenerDelegate.$$$reportNull$$$0(0);
            }
            this.myDelegate = delegate;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.myDelegate.propertyChange(new PropertyChangeEvent((Object)SplitFileEditor.this, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/intellij/plugins/markdown/ui/split/SplitFileEditor$DoublingEventListenerDelegate", "<init>"));
        }
    }

    public static class MyFileEditorState
    implements FileEditorState {
        @Nullable
        private final String mySplitLayout;
        @Nullable
        private final FileEditorState myFirstState;
        @Nullable
        private final FileEditorState mySecondState;

        public MyFileEditorState(@Nullable String splitLayout, @Nullable FileEditorState firstState, @Nullable FileEditorState secondState) {
            this.mySplitLayout = splitLayout;
            this.myFirstState = firstState;
            this.mySecondState = secondState;
        }

        @Nullable
        public String getSplitLayout() {
            return this.mySplitLayout;
        }

        @Nullable
        public FileEditorState getFirstState() {
            return this.myFirstState;
        }

        @Nullable
        public FileEditorState getSecondState() {
            return this.mySecondState;
        }

        public boolean canBeMergedWith(FileEditorState otherState, FileEditorStateLevel level) {
            return !(!(otherState instanceof MyFileEditorState) || this.myFirstState != null && !this.myFirstState.canBeMergedWith(((MyFileEditorState)otherState).myFirstState, level) || this.mySecondState != null && !this.mySecondState.canBeMergedWith(((MyFileEditorState)otherState).mySecondState, level));
        }
    }
}

