/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.formatter;

import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.lang.MarkdownLanguage;
import org.intellij.plugins.markdown.lang.formatter.MarkdownCodeStyleConfigurable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lorg/intellij/plugins/markdown/lang/formatter/MarkdownLanguageCodeStyleSettingsProvider;", "Lcom/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider;", "()V", "STANDARD_WRAPPING_OPTIONS", "", "", "[Ljava/lang/String;", "createConfigurable", "Lcom/intellij/psi/codeStyle/CodeStyleConfigurable;", "baseSettings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "modelSettings", "customizeSettings", "", "consumer", "Lcom/intellij/psi/codeStyle/CodeStyleSettingsCustomizable;", "settingsType", "Lcom/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider$SettingsType;", "getCodeSample", "getConfigurableDisplayName", "getLanguage", "Lcom/intellij/lang/Language;", "intellij.markdown"})
public final class MarkdownLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    private final String[] STANDARD_WRAPPING_OPTIONS = new String[]{"RIGHT_MARGIN", "WRAP_ON_TYPING"};

    @NotNull
    public Language getLanguage() {
        MarkdownLanguage markdownLanguage = MarkdownLanguage.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)markdownLanguage), (String)"MarkdownLanguage.INSTANCE");
        return markdownLanguage;
    }

    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings baseSettings, @NotNull CodeStyleSettings modelSettings) {
        Intrinsics.checkParameterIsNotNull((Object)baseSettings, (String)"baseSettings");
        Intrinsics.checkParameterIsNotNull((Object)modelSettings, (String)"modelSettings");
        return (CodeStyleConfigurable)new MarkdownCodeStyleConfigurable(baseSettings, modelSettings);
    }

    @NotNull
    public String getConfigurableDisplayName() {
        return "Markdown";
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        Intrinsics.checkParameterIsNotNull((Object)consumer, (String)"consumer");
        Intrinsics.checkParameterIsNotNull((Object)settingsType, (String)"settingsType");
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            consumer.showStandardOptions(Arrays.copyOf(this.STANDARD_WRAPPING_OPTIONS, this.STANDARD_WRAPPING_OPTIONS.length));
        }
    }

    @NotNull
    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        Intrinsics.checkParameterIsNotNull((Object)settingsType, (String)"settingsType");
        return "**Markdown parser and generator written in Kotlin**\n\nIntroduction\n-------------\n\n[intellij-markdown][self] is a fast and extensible markdown processor.\nIt is aimed to suit the following needs:\n- Use one code base for both client and server-side processing;\n- Support different flavours;\n- Be easily extensible.\n\nSince the parser is written in [Kotlin], it can be compiled to both JS and Java bytecode\nthus can be used everywhere.\n\nUsage\n-----\n\nOne of the goals of this project is to provide flexibility in terms of the tasks being solved.\n[Markdown plugin] for JetBrains IDEs is an example of usage when markdown processing is done\nin several stages:\n\n* Parse block structure without parsing inlines to provide lazy parsable blocks for IDE;\n* Quickly parse inlines of a given block to provide faster syntax highlighting update;\n* Generate HTML for preview.\n\nThese tasks may be completed independently according to the current needs.\n\n#### Simple html generation (Kotlin)\n\n```kotlin\nval src = \"Some *Markdown*\"\nval flavour = CommonMarkFlavourDescriptor()\nval parsedTree = MarkdownParser(flavour).buildMarkdownTreeFromString(src)\nval html = HtmlGenerator(src, parsedTree, flavour).generateHtml()\n```";
    }
}

