/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageOptions;
import com.intellij.coverage.JavaCoverageOptionsProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.IdeBorderFactory;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class JavaCoverageOptions
extends CoverageOptions {
    private final JavaCoverageOptionsProvider myCoverageOptionsProvider;
    private JavaCoverageOptionsEditor myEditor;

    JavaCoverageOptions(@NotNull Project project) {
        if (project == null) {
            JavaCoverageOptions.$$$reportNull$$$0(0);
        }
        this.myCoverageOptionsProvider = JavaCoverageOptionsProvider.getInstance(project);
    }

    public JComponent createComponent() {
        this.myEditor = new JavaCoverageOptionsEditor();
        return this.myEditor.getComponent();
    }

    public boolean isModified() {
        return this.myEditor.isModified(this.myCoverageOptionsProvider);
    }

    public void apply() {
        this.myEditor.apply(this.myCoverageOptionsProvider);
    }

    public void reset() {
        this.myEditor.reset(this.myCoverageOptionsProvider);
    }

    public void disposeUIResources() {
        this.myEditor = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/coverage/JavaCoverageOptions", "<init>"));
    }

    private static class JavaCoverageOptionsEditor {
        private final JPanel myPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        private final JCheckBox myImplicitCheckBox = new JCheckBox("Ignore implicitly declared default constructors", true);
        private final JCheckBox myEmptyCheckBox = new JCheckBox("Ignore empty private constructors of utility classes", true);

        JavaCoverageOptionsEditor() {
            this.myPanel.setBorder(IdeBorderFactory.createTitledBorder((String)"Java coverage"));
            this.myPanel.add(this.myImplicitCheckBox);
            this.myPanel.add(this.myEmptyCheckBox);
        }

        public JPanel getComponent() {
            return this.myPanel;
        }

        public boolean isModified(JavaCoverageOptionsProvider provider) {
            return this.myImplicitCheckBox.isSelected() != provider.ignoreImplicitConstructors() || this.myEmptyCheckBox.isSelected() != provider.ignoreEmptyPrivateConstructors();
        }

        public void apply(JavaCoverageOptionsProvider provider) {
            provider.setIgnoreImplicitConstructors(this.myImplicitCheckBox.isSelected());
            provider.setIgnoreEmptyPrivateConstructors(this.myEmptyCheckBox.isSelected());
        }

        public void reset(JavaCoverageOptionsProvider provider) {
            this.myImplicitCheckBox.setSelected(provider.ignoreImplicitConstructors());
            this.myEmptyCheckBox.setSelected(provider.ignoreEmptyPrivateConstructors());
        }
    }
}

