/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.themes;

import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonProperty;
import com.intellij.model.SymbolResolveResult;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.impl.JsonSchemaBaseReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.themes.ThemeJsonUtil;

class ThemeJsonNamedColorPsiReference
extends JsonSchemaBaseReference<JsonLiteral> {
    private final String myName;

    ThemeJsonNamedColorPsiReference(JsonLiteral element) {
        super((PsiElement)element, element.getTextLength() >= 2 ? new TextRange(1, element.getTextLength() - 1) : TextRange.EMPTY_RANGE);
        this.myName = StringUtil.unquoteString((String)element.getText());
    }

    @Nullable
    public PsiElement resolveInner() {
        PsiFile containingFile = ((JsonLiteral)this.getElement()).getContainingFile();
        if (!(containingFile instanceof JsonFile)) {
            return null;
        }
        List<JsonProperty> namedColors = ThemeJsonUtil.getNamedColors((JsonFile)containingFile);
        return (PsiElement)ContainerUtil.find(namedColors, property -> property.getName().equals(this.myName));
    }

    @NotNull
    public Object[] getVariants() {
        if (EMPTY_ARRAY == null) {
            ThemeJsonNamedColorPsiReference.$$$reportNull$$$0(0);
        }
        return EMPTY_ARRAY;
    }

    @NotNull
    public Collection<? extends SymbolResolveResult> resolveReference() {
        List list = Collections.emptyList();
        if (list == null) {
            ThemeJsonNamedColorPsiReference.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/idea/devkit/themes/ThemeJsonNamedColorPsiReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveReference";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

