/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.themes;

import com.intellij.codeInsight.javadoc.JavaDocInfoGenerator;
import com.intellij.ide.ui.UIThemeMetadata;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.themes.ThemeJsonUtil;

public class ThemeJsonDocumentationProvider
extends AbstractDocumentationProvider {
    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        Pair<UIThemeMetadata, UIThemeMetadata.UIKeyMetadata> resolve = ThemeJsonDocumentationProvider.resolve(element);
        if (resolve == null) {
            return null;
        }
        return "<b>" + ((UIThemeMetadata.UIKeyMetadata)resolve.second).getKey() + "</b> [" + ((UIThemeMetadata)resolve.first).getName() + "]\n" + StringUtil.notNullize((String)((UIThemeMetadata.UIKeyMetadata)resolve.second).getDescription());
    }

    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        String since;
        Pair<UIThemeMetadata, UIThemeMetadata.UIKeyMetadata> resolve = ThemeJsonDocumentationProvider.resolve(element);
        if (resolve == null) {
            return null;
        }
        UIThemeMetadata uiThemeMetadata = (UIThemeMetadata)resolve.first;
        UIThemeMetadata.UIKeyMetadata uiKeyMetadata = (UIThemeMetadata.UIKeyMetadata)resolve.second;
        StringBuilder sb = new StringBuilder("<div class='definition'><pre>");
        sb.append("<b>").append(uiKeyMetadata.getKey()).append("</b><br>");
        sb.append("[").append(uiThemeMetadata.getName()).append("] - ");
        sb.append("[").append(uiThemeMetadata.getPluginId()).append("]");
        sb.append("</pre></div>");
        sb.append("<div class='content'>");
        if (uiKeyMetadata.isDeprecated()) {
            sb.append("<font color='#").append(ColorUtil.toHex((Color)JBColor.RED)).append("'><b>Deprecated</b></font><br>");
        }
        sb.append(StringUtil.notNullize((String)uiKeyMetadata.getDescription(), (String)"(no description)"));
        sb.append("<br><br>");
        sb.append("</div>");
        sb.append("<table class='sections'>");
        String source = uiKeyMetadata.getSource();
        if (source != null) {
            ThemeJsonDocumentationProvider.appendSection(sb, "Source", () -> {
                PsiClassType type = JavaPsiFacade.getElementFactory((Project)element.getProject()).createTypeByFQClassName(source);
                StringBuilder typeBuilder = new StringBuilder();
                JavaDocInfoGenerator.generateType((StringBuilder)typeBuilder, (PsiType)type, (PsiElement)element);
                return typeBuilder.toString();
            });
        }
        if ((since = uiKeyMetadata.getSince()) != null) {
            ThemeJsonDocumentationProvider.appendSection(sb, "Since", since);
        }
        sb.append("</table>");
        return sb.toString();
    }

    private static void appendSection(StringBuilder sb, String sectionName, String sectionContent) {
        ThemeJsonDocumentationProvider.appendSection(sb, sectionName, () -> sectionContent);
    }

    private static void appendSection(StringBuilder sb, String sectionName, Supplier<String> content) {
        sb.append("<tr><td valign='top' class='section'><p>").append(sectionName).append(":").append("</td><td valign='top'>");
        sb.append(content.get());
        sb.append("</td>");
    }

    @Nullable
    private static Pair<UIThemeMetadata, UIThemeMetadata.UIKeyMetadata> resolve(PsiElement element) {
        if (!(element instanceof JsonProperty)) {
            return null;
        }
        if (!ThemeJsonUtil.isThemeFilename(element.getContainingFile().getName())) {
            return null;
        }
        return ThemeJsonUtil.findMetadata((JsonProperty)element);
    }
}

