/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references.extensions;

import com.intellij.codeInsight.javadoc.JavaDocInfoGenerator;
import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.lang.documentation.DocumentationProviderEx;
import com.intellij.lang.java.JavaDocumentationProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.DomUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.With;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

public class ExtensionPointDocumentationProvider
extends DocumentationProviderEx {
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        ExtensionPoint extensionPoint = ExtensionPointDocumentationProvider.findExtensionPoint(element);
        if (extensionPoint == null) {
            return null;
        }
        XmlFile epDeclarationFile = DomUtil.getFile((DomElement)extensionPoint);
        Module epModule = ModuleUtilCore.findModuleForFile((VirtualFile)epDeclarationFile.getVirtualFile(), (Project)element.getProject());
        String epPrefix = extensionPoint.getNamePrefix();
        PsiClass epClass = ExtensionPointDocumentationProvider.getExtensionPointClass(extensionPoint);
        StringBuilder epClassText = new StringBuilder();
        if (epClass != null) {
            ExtensionPointDocumentationProvider.generateClassLink(epClassText, epClass);
        } else {
            epClassText.append("<unknown>");
        }
        String moduleAndPrefix = (epModule == null ? "" : "[" + epModule.getName() + "]") + (epPrefix == null ? "" : " " + epPrefix);
        if (!moduleAndPrefix.isEmpty()) {
            moduleAndPrefix = moduleAndPrefix + "<br/>";
        }
        return moduleAndPrefix + "<b>" + extensionPoint.getEffectiveName() + "</b> (" + epDeclarationFile.getName() + ")<br/>" + epClassText.toString();
    }

    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        ExtensionPoint extensionPoint = ExtensionPointDocumentationProvider.findExtensionPoint(element);
        if (extensionPoint == null) {
            return null;
        }
        PsiClass epClass = ExtensionPointDocumentationProvider.getExtensionPointClass(extensionPoint);
        if (epClass != null) {
            StringBuilder sb = new StringBuilder("<div class='definition'><pre>");
            sb.append("<b>").append(extensionPoint.getEffectiveName()).append("</b>");
            String namePrefix = extensionPoint.getNamePrefix();
            if (StringUtil.isNotEmpty((String)namePrefix)) {
                sb.append(" [").append(namePrefix).append("]");
            }
            sb.append("<br>");
            ExtensionPointDocumentationProvider.generateClassLink(sb, epClass);
            sb.append("<br>").append(DomUtil.getFile((DomElement)extensionPoint).getName());
            List<With> withElements = extensionPoint.getWithElements();
            if (!withElements.isEmpty()) {
                sb.append("<table class='sections'>");
                for (With withElement : withElements) {
                    String name = StringUtil.notNullize((String)(DomUtil.hasXml(withElement.getAttribute()) ? withElement.getAttribute().getStringValue() : "<" + withElement.getTag().getStringValue() + ">"));
                    StringBuilder classLinkSb = new StringBuilder();
                    ExtensionPointDocumentationProvider.generateClassLink(classLinkSb, (PsiClass)withElement.getImplements().getValue());
                    ExtensionPointDocumentationProvider.appendSection(sb, XmlUtil.escape((String)name), classLinkSb.toString());
                }
                sb.append("</table>");
            }
            sb.append("</pre></div>");
            sb.append("<div class='content'>");
            String epDocumentationType = DomUtil.hasXml(extensionPoint.getBeanClass()) ? "Bean Class" : "Implementation Class";
            sb.append("<em>Extension Point ").append(epDocumentationType).append("</em>");
            sb.append(JavaDocumentationProvider.generateExternalJavadoc((PsiElement)epClass));
            sb.append("</div>");
            return sb.toString();
        }
        return null;
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return JavaDocUtil.findReferenceTarget((PsiManager)psiManager, (String)link, (PsiElement)context);
    }

    private static void generateClassLink(StringBuilder epClassText, @Nullable PsiClass epClass) {
        if (epClass == null) {
            return;
        }
        JavaDocInfoGenerator.generateType((StringBuilder)epClassText, (PsiType)PsiTypesUtil.getClassType((PsiClass)epClass), (PsiElement)epClass, (boolean)true);
    }

    private static void appendSection(StringBuilder sb, String sectionName, String sectionContent) {
        sb.append("<tr><td valign='top' class='section'><p>").append(sectionName).append(":").append("</td><td valign='top'>");
        sb.append(sectionContent);
        sb.append("</td>");
    }

    @Nullable
    private static ExtensionPoint findExtensionPoint(PsiElement element) {
        DomElement domElement;
        if (element instanceof PomTargetPsiElement && DescriptorUtil.isPluginXml(element.getContainingFile())) {
            DomElement domElement2;
            PomTarget pomTarget = ((PomTargetPsiElement)element).getTarget();
            if (pomTarget instanceof DomTarget && (domElement2 = ((DomTarget)pomTarget).getDomElement()) instanceof ExtensionPoint) {
                return (ExtensionPoint)domElement2;
            }
        } else if (element instanceof XmlTag && DescriptorUtil.isPluginXml(element.getContainingFile()) && (domElement = DomUtil.getDomElement((PsiElement)element)) instanceof ExtensionPoint) {
            return (ExtensionPoint)domElement;
        }
        return null;
    }

    @Nullable
    private static PsiClass getExtensionPointClass(ExtensionPoint extensionPoint) {
        return DomUtil.hasXml(extensionPoint.getInterface()) ? (PsiClass)extensionPoint.getInterface().getValue() : (PsiClass)extensionPoint.getBeanClass().getValue();
    }
}

