/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.missingApi.update;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.util.messages.MessageBusConnection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.missingApi.update.IdeExternalAnnotationsUpdater;
import org.jetbrains.idea.devkit.projectRoots.IdeaJdk;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/devkit/inspections/missingApi/update/IdeExternalAnnotationsUpdateStartupActivity;", "Lcom/intellij/openapi/startup/StartupActivity;", "()V", "getIdeaBuildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "ideaJdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "subscribeToJdkChanges", "application", "Lcom/intellij/openapi/application/Application;", "updateAnnotationsLaterIfNecessary", "intellij.devkit"})
public final class IdeExternalAnnotationsUpdateStartupActivity
implements StartupActivity {
    public void runActivity(@NotNull Project project) {
        Application application;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Application application2 = application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application2, (String)"application");
        if (application2.isUnitTestMode()) {
            return;
        }
        this.subscribeToJdkChanges(project, application);
    }

    private final void updateAnnotationsLaterIfNecessary(Project project, Sdk ideaJdk) {
        BuildNumber buildNumber = this.getIdeaBuildNumber(ideaJdk);
        if (buildNumber != null) {
            IdeExternalAnnotationsUpdater.Companion.getInstance().updateIdeaJdkAnnotationsIfNecessary(project, ideaJdk, buildNumber);
        }
    }

    private final void subscribeToJdkChanges(Project project, Application application) {
        MessageBusConnection messageBusConnection = application.getMessageBus().connect((Disposable)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)messageBusConnection, (String)"application.messageBus.connect(project)");
        MessageBusConnection connection = messageBusConnection;
        connection.subscribe(ProjectJdkTable.JDK_TABLE_TOPIC, (Object)new ProjectJdkTable.Adapter(this, project){
            final /* synthetic */ IdeExternalAnnotationsUpdateStartupActivity this$0;
            final /* synthetic */ Project $project;

            public void jdkAdded(@NotNull Sdk jdk) {
                Intrinsics.checkParameterIsNotNull((Object)jdk, (String)"jdk");
                if (Intrinsics.areEqual((Object)jdk.getSdkType(), (Object)IdeaJdk.getInstance())) {
                    IdeExternalAnnotationsUpdateStartupActivity.access$updateAnnotationsLaterIfNecessary(this.this$0, this.$project, jdk);
                }
            }

            public void jdkNameChanged(@NotNull Sdk jdk, @NotNull String previousName) {
                Intrinsics.checkParameterIsNotNull((Object)jdk, (String)"jdk");
                Intrinsics.checkParameterIsNotNull((Object)previousName, (String)"previousName");
                if (Intrinsics.areEqual((Object)jdk.getSdkType(), (Object)IdeaJdk.getInstance())) {
                    IdeExternalAnnotationsUpdateStartupActivity.access$updateAnnotationsLaterIfNecessary(this.this$0, this.$project, jdk);
                }
            }
            {
                this.this$0 = $outer;
                this.$project = $captured_local_variable$1;
            }
        });
    }

    private final BuildNumber getIdeaBuildNumber(Sdk ideaJdk) {
        String string = ideaJdk.getHomePath();
        if (string == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ideaJdk.homePath ?: return null");
        String homePath = string;
        String string2 = IdeaJdk.getBuildNumber(homePath);
        if (string2 == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"IdeaJdk.getBuildNumber(homePath) ?: return null");
        String buildNumberStr = string2;
        return BuildNumber.fromStringOrNull((String)buildNumberStr);
    }

    public static final /* synthetic */ void access$updateAnnotationsLaterIfNecessary(IdeExternalAnnotationsUpdateStartupActivity $this, Project project, Sdk ideaJdk) {
        $this.updateAnnotationsLaterIfNecessary(project, ideaJdk);
    }
}

