/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.missingApi.resolve;

import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0002\"\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"ANNOTATIONS_BUILD_NUMBER_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/util/BuildNumber;", "kotlin.jvm.PlatformType", "BUILD_TXT_FILE_NAME", "", "getAnnotationsBuildNumber", "annotationsRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "isAnnotationsRoot", "", "virtualFile", "loadBuildNumber", "intellij.devkit"})
public final class IdeExternalAnnotationsKt {
    private static final String BUILD_TXT_FILE_NAME = "build.txt";
    private static final Key<BuildNumber> ANNOTATIONS_BUILD_NUMBER_KEY;

    @Nullable
    public static final BuildNumber getAnnotationsBuildNumber(@NotNull VirtualFile annotationsRoot) {
        Intrinsics.checkParameterIsNotNull((Object)annotationsRoot, (String)"annotationsRoot");
        BuildNumber cachedValue = (BuildNumber)annotationsRoot.getUserData(ANNOTATIONS_BUILD_NUMBER_KEY);
        if (cachedValue != null) {
            return cachedValue;
        }
        BuildNumber loadedValue = IdeExternalAnnotationsKt.loadBuildNumber(annotationsRoot);
        annotationsRoot.putUserData(ANNOTATIONS_BUILD_NUMBER_KEY, (Object)loadedValue);
        return loadedValue;
    }

    private static final BuildNumber loadBuildNumber(VirtualFile annotationsRoot) {
        VirtualFile buildTxtFile = annotationsRoot.findFileByRelativePath(BUILD_TXT_FILE_NAME);
        if (buildTxtFile != null) {
            return BuildNumber.fromStringOrNull((String)VfsUtil.loadText((VirtualFile)buildTxtFile));
        }
        return null;
    }

    public static final boolean isAnnotationsRoot(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        return IdeExternalAnnotationsKt.getAnnotationsBuildNumber(virtualFile) != null;
    }

    static {
        Key key = Key.create((String)"devkit.intellij.api.annotations.build.number");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<BuildNumber>(\u2026nnotations.build.number\")");
        ANNOTATIONS_BUILD_NUMBER_KEY = key;
    }
}

