/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;

public class UnsafeVfsRecursionInspection
extends DevKitInspectionBase {
    private static final String VIRTUAL_FILE_CLASS_NAME = VirtualFile.class.getName();
    private static final String GET_CHILDREN_METHOD_NAME = "getChildren";
    private static final String MESSAGE = "VirtualFile.getChildren() is called from a recursive method. This may cause an endless loop on cyclic symlinks. Please use VfsUtilCore.visitChildrenRecursively() instead.";

    @Override
    @NotNull
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UnsafeVfsRecursionInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(final PsiMethodCallExpression expression) {
                PsiClass virtualFileClass;
                PsiReferenceExpression methodRef = expression.getMethodExpression();
                if (!UnsafeVfsRecursionInspection.GET_CHILDREN_METHOD_NAME.equals(methodRef.getReferenceName())) {
                    return;
                }
                PsiElement methodElement = methodRef.resolve();
                if (!(methodElement instanceof PsiMethod)) {
                    return;
                }
                PsiMethod method = (PsiMethod)methodElement;
                Project project = holder.getProject();
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
                PsiClass aClass = method.getContainingClass();
                if (!InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)(virtualFileClass = facade.findClass(VIRTUAL_FILE_CLASS_NAME, GlobalSearchScope.allScope((Project)project))), (boolean)true)) {
                    return;
                }
                final PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class);
                if (containingMethod == null) {
                    return;
                }
                final String containingMethodName = containingMethod.getName();
                final Ref result = Ref.create();
                containingMethod.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                    public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                        super.visitMethodCallExpression(expression2);
                        if (expression2 != expression && containingMethodName.equals(expression2.getMethodExpression().getReferenceName()) && expression2.resolveMethod() == containingMethod) {
                            result.set((Object)Boolean.TRUE);
                        }
                    }
                });
                if (!result.isNull()) {
                    holder.registerProblem((PsiElement)expression, UnsafeVfsRecursionInspection.MESSAGE, new LocalQuickFix[0]);
                }
            }
        };
        if (javaElementVisitor == null) {
            UnsafeVfsRecursionInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/internal/UnsafeVfsRecursionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/UnsafeVfsRecursionInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildInternalVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildInternalVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

