/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;
import org.jetbrains.idea.devkit.inspections.RegistrationCheckerUtil;
import org.jetbrains.idea.devkit.inspections.quickfix.CreateConstructorFix;
import org.jetbrains.idea.devkit.inspections.quickfix.ImplementOrExtendFix;
import org.jetbrains.idea.devkit.util.ActionType;
import org.jetbrains.idea.devkit.util.ComponentType;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

public class RegistrationProblemsInspection
extends DevKitInspectionBase {
    public boolean CHECK_PLUGIN_XML = true;
    public boolean CHECK_JAVA_CODE = true;
    public boolean CHECK_ACTIONS = true;

    @NotNull
    @NonNls
    public String getShortName() {
        if ("ComponentRegistrationProblems" == null) {
            RegistrationProblemsInspection.$$$reportNull$$$0(0);
        }
        return "ComponentRegistrationProblems";
    }

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        final JCheckBox checkPluginXml = new JCheckBox(DevKitBundle.message("inspections.registration.problems.option.check.plugin.xml", new Object[0]), this.CHECK_PLUGIN_XML);
        checkPluginXml.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RegistrationProblemsInspection.this.CHECK_PLUGIN_XML = checkPluginXml.isSelected();
            }
        });
        final JCheckBox checkJavaActions = new JCheckBox(DevKitBundle.message("inspections.registration.problems.option.check.java.actions", new Object[0]), this.CHECK_ACTIONS);
        checkJavaActions.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RegistrationProblemsInspection.this.CHECK_ACTIONS = checkJavaActions.isSelected();
            }
        });
        final JCheckBox checkJavaCode = new JCheckBox(DevKitBundle.message("inspections.registration.problems.option.check.java.code", new Object[0]), this.CHECK_JAVA_CODE);
        checkJavaCode.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean selected;
                RegistrationProblemsInspection.this.CHECK_JAVA_CODE = selected = checkJavaCode.isSelected();
                checkJavaActions.setEnabled(selected);
            }
        });
        jPanel.add(checkPluginXml);
        jPanel.add(checkJavaCode);
        jPanel.add(checkJavaActions);
        return jPanel;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            RegistrationProblemsInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            RegistrationProblemsInspection.$$$reportNull$$$0(2);
        }
        if (this.CHECK_PLUGIN_XML && DescriptorUtil.isPluginXml(file)) {
            return RegistrationProblemsInspection.checkPluginXml((XmlFile)file, manager, isOnTheFly);
        }
        return null;
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass checkedClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        RegistrationCheckerUtil.RegistrationType registrationType;
        Set<PsiClass> componentClasses;
        if (checkedClass == null) {
            RegistrationProblemsInspection.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            RegistrationProblemsInspection.$$$reportNull$$$0(4);
        }
        PsiIdentifier nameIdentifier = checkedClass.getNameIdentifier();
        if (!(!this.CHECK_JAVA_CODE || nameIdentifier == null || checkedClass.getQualifiedName() == null || checkedClass.getContainingFile().getVirtualFile() == null || checkedClass.isInterface() || checkedClass.isEnum() || checkedClass.hasModifierProperty("private") || checkedClass.hasModifierProperty("protected") || PsiUtil.isInnerClass((PsiClass)checkedClass) || (componentClasses = RegistrationCheckerUtil.getRegistrationTypes(checkedClass, registrationType = this.CHECK_ACTIONS ? RegistrationCheckerUtil.RegistrationType.ALL : RegistrationCheckerUtil.RegistrationType.ALL_COMPONENTS)) == null || componentClasses.isEmpty())) {
            SmartList problems = new SmartList();
            for (PsiClass compClass : componentClasses) {
                if (!ActionType.ACTION.myClassName.equals(compClass.getQualifiedName()) || checkedClass.isInheritor(compClass, true)) continue;
                problems.add(manager.createProblemDescriptor((PsiElement)nameIdentifier, DevKitBundle.message("inspections.registration.problems.incompatible.message", compClass.isInterface() ? DevKitBundle.message("keyword.implement", new Object[0]) : DevKitBundle.message("keyword.extend", new Object[0]), compClass.getQualifiedName()), isOnTheFly, ImplementOrExtendFix.createFix(compClass, checkedClass, isOnTheFly), ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
            }
            if (ActionType.ACTION.isOfType(checkedClass) && ConstructorType.getNoArgCtor(checkedClass) == null) {
                problems.add(manager.createProblemDescriptor((PsiElement)nameIdentifier, DevKitBundle.message("inspections.registration.problems.missing.noarg.ctor", new Object[0]), (LocalQuickFix)new CreateConstructorFix(checkedClass, isOnTheFly), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
            }
            if (RegistrationProblemsInspection.isAbstract((PsiModifierListOwner)checkedClass)) {
                problems.add(manager.createProblemDescriptor((PsiElement)nameIdentifier, DevKitBundle.message("inspections.registration.problems.abstract", new Object[0]), isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
            }
            return problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
        }
        return null;
    }

    @Nullable
    private static ProblemDescriptor[] checkPluginXml(XmlFile xmlFile, InspectionManager manager, boolean isOnTheFly) {
        XmlDocument document = xmlFile.getDocument();
        if (document == null) {
            return null;
        }
        XmlTag rootTag = document.getRootTag();
        assert (rootTag != null);
        RegistrationChecker checker = new RegistrationChecker(manager, xmlFile, isOnTheFly);
        DescriptorUtil.processComponents(rootTag, checker);
        DescriptorUtil.processActions(rootTag, checker);
        return checker.getProblems();
    }

    private static boolean isAbstract(PsiModifierListOwner checkedClass) {
        return checkedClass.hasModifierProperty("abstract");
    }

    @Nullable
    private static PsiElement getAttValueToken(@NotNull XmlAttribute attribute) {
        XmlAttributeValue valueElement;
        if (attribute == null) {
            RegistrationProblemsInspection.$$$reportNull$$$0(5);
        }
        if ((valueElement = attribute.getValueElement()) == null) {
            return null;
        }
        PsiElement[] children = valueElement.getChildren();
        if (children.length == 3 && children[1] instanceof XmlToken) {
            return children[1];
        }
        if (children.length == 1 && children[0] instanceof PsiErrorElement) {
            return null;
        }
        return valueElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/RegistrationProblemsInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkedClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/RegistrationProblemsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAttValueToken";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ConstructorType {
        static final ConstructorType DEFAULT = new ConstructorType();
        final PsiMethod myCtor;

        private ConstructorType() {
            this.myCtor = null;
        }

        protected ConstructorType(PsiMethod ctor) {
            assert (ctor != null);
            this.myCtor = ctor;
        }

        public static ConstructorType getNoArgCtor(PsiClass checkedClass) {
            PsiMethod[] constructors = checkedClass.getConstructors();
            if (constructors.length > 0) {
                for (PsiMethod ctor : constructors) {
                    if (!ctor.getParameterList().isEmpty()) continue;
                    return new ConstructorType(ctor);
                }
                return null;
            }
            return DEFAULT;
        }
    }

    private static class RegistrationChecker
    implements ComponentType.Processor,
    ActionType.Processor {
        private List<ProblemDescriptor> myList;
        private final InspectionManager myManager;
        private final XmlFile myXmlFile;
        private final PsiManager myPsiManager;
        private final GlobalSearchScope myScope;
        private final MultiMap<ComponentType, String> myInterfaceClasses = MultiMap.createSet();
        private final boolean myOnTheFly;

        private RegistrationChecker(InspectionManager manager, XmlFile xmlFile, boolean onTheFly) {
            this.myManager = manager;
            this.myXmlFile = xmlFile;
            this.myOnTheFly = onTheFly;
            this.myPsiManager = xmlFile.getManager();
            this.myScope = xmlFile.getResolveScope();
        }

        @Nullable
        private PsiClass findClass(@NotNull String fqn) {
            if (fqn == null) {
                RegistrationChecker.$$$reportNull$$$0(0);
            }
            return ClassUtil.findPsiClass((PsiManager)this.myPsiManager, (String)fqn, null, (boolean)true, (GlobalSearchScope)this.myScope);
        }

        @Override
        public boolean process(ComponentType type, XmlTag component, @Nullable XmlTagValue impl, @Nullable XmlTagValue intf) {
            if (impl == null) {
                this.addProblem((PsiElement)component, DevKitBundle.message("inspections.registration.problems.missing.implementation.class", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, new LocalQuickFix[0]);
            } else {
                String implClassName;
                PsiClass implClass;
                String intfName = null;
                PsiClass intfClass = null;
                if (intf != null) {
                    intfName = intf.getTrimmedText();
                    intfClass = this.findClass(intfName);
                }
                if ((implClass = this.findClass(implClassName = impl.getTrimmedText())) == null) {
                    this.addProblem(impl, DevKitBundle.message("inspections.registration.problems.cannot.resolve.class", DevKitBundle.message("class.implementation", new Object[0])), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, this.myOnTheFly, (LocalQuickFix)QuickFixFactory.getInstance().createCreateClassOrInterfaceFix((PsiElement)this.myXmlFile, implClassName, true, intfClass != null ? intfName : type.myClassName));
                } else if (RegistrationProblemsInspection.isAbstract((PsiModifierListOwner)implClass)) {
                    this.addProblem(impl, DevKitBundle.message("inspections.registration.problems.abstract", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, new LocalQuickFix[0]);
                }
                if (intfName != null) {
                    if (intfClass == null) {
                        this.addProblem(intf, DevKitBundle.message("inspections.registration.problems.cannot.resolve.class", DevKitBundle.message("class.interface", new Object[0])), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, this.myOnTheFly, (LocalQuickFix)QuickFixFactory.getInstance().createCreateClassOrInterfaceFix((PsiElement)this.myXmlFile, intfName, false, type.myClassName), (LocalQuickFix)QuickFixFactory.getInstance().createCreateClassOrInterfaceFix((PsiElement)this.myXmlFile, intfName, true, type.myClassName));
                    } else if (implClass != null) {
                        String fqn = intfClass.getQualifiedName();
                        if (type == ComponentType.MODULE) {
                            if (!this.checkInterface(type, fqn, intf)) {
                                String[] keys;
                                for (String key : keys = RegistrationChecker.makeQualifiedModuleInterfaceNames(component, fqn)) {
                                    this.checkInterface(type, key, intf);
                                    this.myInterfaceClasses.putValue((Object)type, (Object)key);
                                }
                            }
                        } else {
                            this.checkInterface(type, fqn, intf);
                            this.myInterfaceClasses.putValue((Object)type, (Object)fqn);
                        }
                        if (intfClass != implClass && !implClass.isInheritor(intfClass, true)) {
                            this.addProblem(impl, DevKitBundle.message("inspections.registration.problems.component.incompatible.interface", fqn), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, new LocalQuickFix[0]);
                        }
                    }
                }
            }
            return true;
        }

        private boolean checkInterface(ComponentType type, String fqn, XmlTagValue value) {
            if (this.myInterfaceClasses.get((Object)type).contains(fqn)) {
                this.addProblem(value, DevKitBundle.message("inspections.registration.problems.component.duplicate.interface", fqn), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, new LocalQuickFix[0]);
                return true;
            }
            return false;
        }

        private static String[] makeQualifiedModuleInterfaceNames(XmlTag component, String fqn) {
            XmlTag[] children;
            for (XmlTag child : children = component.findSubTags("option")) {
                if (!"type".equals(child.getAttributeValue("name"))) continue;
                String value = child.getAttributeValue("value");
                SmartList names = new SmartList();
                if (value != null) {
                    String[] moduleTypes;
                    for (String moduleType : moduleTypes = value.split(";")) {
                        names.add((Object)(fqn + "#" + moduleType));
                    }
                }
                return ArrayUtilRt.toStringArray((Collection)names);
            }
            return new String[]{fqn};
        }

        @Override
        public boolean process(ActionType type, XmlTag action) {
            PsiElement token;
            XmlAttribute attribute = action.getAttribute("class");
            if (attribute != null && (token = RegistrationProblemsInspection.getAttValueToken(attribute)) != null) {
                String actionClassName = attribute.getValue().trim();
                PsiClass actionClass = this.findClass(actionClassName);
                if (actionClass == null) {
                    this.addProblem(token, DevKitBundle.message("inspections.registration.problems.cannot.resolve.class", DevKitBundle.message("class.action", new Object[0])), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, this.myOnTheFly, (LocalQuickFix)QuickFixFactory.getInstance().createCreateClassOrInterfaceFix(token, actionClassName, true, AnAction.class.getName()));
                } else {
                    ConstructorType noArgCtor;
                    PsiClass psiClass;
                    if (!type.isOfType(actionClass) && (psiClass = this.findClass(type.myClassName)) != null && !actionClass.isInheritor(psiClass, true)) {
                        this.addProblem(token, DevKitBundle.message("inspections.registration.problems.action.incompatible.class", type.myClassName), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, ImplementOrExtendFix.createFix(psiClass, actionClass, this.myOnTheFly));
                    }
                    if ((noArgCtor = ConstructorType.getNoArgCtor(actionClass)) == null) {
                        this.addProblem(token, DevKitBundle.message("inspections.registration.problems.missing.noarg.ctor", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, new CreateConstructorFix(actionClass, this.myOnTheFly));
                    }
                    if (RegistrationProblemsInspection.isAbstract((PsiModifierListOwner)actionClass)) {
                        this.addProblem(token, DevKitBundle.message("inspections.registration.problems.abstract", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, new LocalQuickFix[0]);
                    }
                }
            }
            return true;
        }

        private void addProblem(XmlTagValue impl, String problem, ProblemHighlightType type, boolean isOnTheFly, LocalQuickFix ... fixes) {
            XmlText[] textElements;
            for (XmlText text : textElements = impl.getTextElements()) {
                if (text.getValue().trim().length() <= 0) continue;
                this.addProblem((PsiElement)text, problem, type, isOnTheFly, fixes);
            }
        }

        private void addProblem(PsiElement element, String problem, ProblemHighlightType type, boolean onTheFly, LocalQuickFix ... fixes) {
            if (this.myList == null) {
                this.myList = new SmartList();
            }
            this.myList.add(this.myManager.createProblemDescriptor(element, problem, onTheFly, fixes, type));
        }

        @Nullable
        public ProblemDescriptor[] getProblems() {
            return this.myList != null ? this.myList.toArray(ProblemDescriptor.EMPTY_ARRAY) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "org/jetbrains/idea/devkit/inspections/RegistrationProblemsInspection$RegistrationChecker", "findClass"));
        }
    }
}

