/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.NlsCapitalizationUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.properties.ResourceBundleReference;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomChildrenDescription;
import com.intellij.xml.util.XmlUtil;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Action;
import org.jetbrains.idea.devkit.dom.ActionOrGroup;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;

public class PluginXmlCapitalizationInspection
extends BasicDomElementsInspection<IdeaPlugin> {
    private static final Set<String> EXTENSION_KNOWN_NON_NLS_ATTRIBUTES = ContainerUtil.immutableSet((Object[])new String[]{"id", "order", "os"});

    public PluginXmlCapitalizationInspection() {
        super(IdeaPlugin.class, new Class[0]);
    }

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        if (element instanceof ActionOrGroup) {
            PluginXmlCapitalizationInspection.checkActionOrGroup((ActionOrGroup)element, holder);
        } else if (element instanceof Extension) {
            PluginXmlCapitalizationInspection.checkExtension((Extension)element, holder);
        }
    }

    private static void checkActionOrGroup(ActionOrGroup actionOrGroup, DomElementAnnotationHolder holder) {
        PluginXmlCapitalizationInspection.checkActionOrGroupCapitalization(holder, actionOrGroup, ActionOrGroupText.TEXT);
        PluginXmlCapitalizationInspection.checkActionOrGroupCapitalization(holder, actionOrGroup, ActionOrGroupText.DESCRIPTION);
    }

    private static void checkActionOrGroupCapitalization(DomElementAnnotationHolder holder, ActionOrGroup actionOrGroup, ActionOrGroupText actionOrGroupText) {
        Nls.Capitalization capitalization;
        GenericDomValue genericDomValue = (GenericDomValue)actionOrGroupText.myGetter.apply(actionOrGroup);
        if (PluginXmlCapitalizationInspection.checkCapitalization(holder, genericDomValue, capitalization = actionOrGroupText.myCapitalization)) {
            return;
        }
        IdeaPlugin ideaPlugin = (IdeaPlugin)DomUtil.getParentOfType((DomElement)actionOrGroup, IdeaPlugin.class, (boolean)true);
        if (ideaPlugin == null) {
            return;
        }
        XmlElement resourceBundleTag = ideaPlugin.getResourceBundle().getXmlElement();
        if (resourceBundleTag == null) {
            return;
        }
        ResourceBundleReference bundleReference = (ResourceBundleReference)ContainerUtil.findInstance((Object[])resourceBundleTag.getReferences(), ResourceBundleReference.class);
        if (bundleReference == null) {
            return;
        }
        PropertiesFileImpl bundleFile = (PropertiesFileImpl)ObjectUtils.tryCast((Object)bundleReference.resolve(), PropertiesFileImpl.class);
        if (bundleFile == null) {
            return;
        }
        String resourceKey = "action." + actionOrGroup.getId().getStringValue() + actionOrGroupText.mySuffix;
        Property property = (Property)ObjectUtils.tryCast((Object)bundleFile.findPropertyByKey(resourceKey), Property.class);
        if (property == null) {
            if (((Boolean)actionOrGroupText.myRequired.apply(actionOrGroup)).booleanValue()) {
                holder.createProblem((DomElement)actionOrGroup, "Missing resource bundle key '" + resourceKey + "'", new LocalQuickFix[0]);
            }
        } else {
            PluginXmlCapitalizationInspection.highlightCapitalization(holder, actionOrGroup, property.getValue(), capitalization, property);
        }
    }

    private static void checkExtension(Extension extension, DomElementAnnotationHolder holder) {
        for (DomChildrenDescription child : extension.getGenericInfo().getFixedChildrenDescriptions()) {
            for (DomElement value : child.getValues((DomElement)extension)) {
                if (!value.exists() || !(value instanceof GenericDomValue)) continue;
                GenericDomValue genericDomValue = (GenericDomValue)value;
                PluginXmlCapitalizationInspection.checkDomValue(extension, holder, child, genericDomValue);
            }
        }
        List attributes = extension.getGenericInfo().getAttributeChildrenDescriptions();
        if (attributes.size() == EXTENSION_KNOWN_NON_NLS_ATTRIBUTES.size() + 1) {
            return;
        }
        for (DomAttributeChildDescription attributeDescription : attributes) {
            GenericAttributeValue attributeValue;
            String attributeName = attributeDescription.getXmlElementName();
            if (EXTENSION_KNOWN_NON_NLS_ATTRIBUTES.contains(attributeName) || Extension.isClassField(attributeName) || !DomUtil.hasXml((DomElement)(attributeValue = attributeDescription.getDomAttributeValue((DomElement)extension)))) continue;
            PluginXmlCapitalizationInspection.checkDomValue(extension, holder, (DomChildrenDescription)attributeDescription, (GenericDomValue)attributeValue);
        }
    }

    private static void checkDomValue(Extension extension, DomElementAnnotationHolder holder, DomChildrenDescription childrenDescription, GenericDomValue genericDomValue) {
        Class attributeType = DomUtil.getGenericValueParameter((Type)childrenDescription.getType());
        if (attributeType != String.class) {
            return;
        }
        PsiElement declaration = childrenDescription.getDeclaration(extension.getManager().getProject());
        if (declaration instanceof PsiField) {
            Nls.Capitalization capitalization = NlsCapitalizationUtil.getCapitalizationFromAnno((PsiModifierListOwner)((PsiModifierListOwner)declaration));
            if (capitalization == Nls.Capitalization.NotSpecified) {
                return;
            }
            PluginXmlCapitalizationInspection.checkCapitalizationWithKey(holder, genericDomValue, capitalization);
        }
    }

    private static void checkCapitalizationWithKey(DomElementAnnotationHolder holder, GenericDomValue genericDomValue, Nls.Capitalization capitalization) {
        if (!DomUtil.hasXml((DomElement)genericDomValue)) {
            return;
        }
        XmlElement xmlElement = DomUtil.getValueElement((GenericDomValue)genericDomValue);
        if (xmlElement == null) {
            return;
        }
        for (PsiReference reference : xmlElement.getReferences()) {
            PsiElement element;
            if (!(reference instanceof PropertyReference)) continue;
            ResolveResult[] resolveResults = ((PropertyReference)reference).multiResolve(false);
            if (resolveResults.length == 1 && resolveResults[0].isValidResult() && (element = resolveResults[0].getElement()) instanceof Property) {
                Property property = (Property)element;
                String value = property.getValue();
                PluginXmlCapitalizationInspection.highlightCapitalization(holder, (DomElement)genericDomValue, value, capitalization, property);
                return;
            }
            return;
        }
        PluginXmlCapitalizationInspection.checkCapitalization(holder, genericDomValue, capitalization);
    }

    private static boolean checkCapitalization(DomElementAnnotationHolder holder, GenericDomValue genericDomValue, Nls.Capitalization capitalization) {
        if (!DomUtil.hasXml((DomElement)genericDomValue)) {
            return false;
        }
        String stringValue = genericDomValue.getStringValue();
        PluginXmlCapitalizationInspection.highlightCapitalization(holder, (DomElement)genericDomValue, stringValue, capitalization, null);
        return true;
    }

    private static void highlightCapitalization(DomElementAnnotationHolder holder, final DomElement domElement, final String value, final Nls.Capitalization capitalization, final @Nullable Property property) {
        if (StringUtil.isEmptyOrSpaces((String)value)) {
            return;
        }
        String escapedValue = XmlUtil.unescape((String)value).replace("_", "");
        if (NlsCapitalizationUtil.isCapitalizationSatisfied((String)escapedValue, (Nls.Capitalization)capitalization)) {
            return;
        }
        LocalQuickFixBase quickFix = new LocalQuickFixBase("Properly capitalize '" + escapedValue + '\'', "Properly capitalize"){

            public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
                if (currentFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                return property != null ? property : currentFile;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (descriptor == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (property != null) {
                    property.setValue(NlsCapitalizationUtil.fixValue((String)value, (Nls.Capitalization)capitalization));
                } else {
                    assert (domElement instanceof GenericDomValue) : domElement;
                    ((GenericDomValue)domElement).setStringValue(NlsCapitalizationUtil.fixValue((String)value, (Nls.Capitalization)capitalization));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "currentFile";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/PluginXmlCapitalizationInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getElementToMakeWritable";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "applyFix";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        holder.createProblem(domElement, "String '" + escapedValue + "' is not properly capitalized. It should have " + StringUtil.toLowerCase((String)capitalization.toString()) + " capitalization", new LocalQuickFix[]{quickFix});
    }

    static enum ActionOrGroupText {
        TEXT(ActionOrGroup::getText, Nls.Capitalization.Title, ".text", actionOrGroup -> {
            if (!(actionOrGroup instanceof Action)) {
                return false;
            }
            PsiClass actionClass = (PsiClass)((Action)actionOrGroup).getClazz().getValue();
            return actionClass == null || actionClass.getConstructors().length == 0;
        }),
        DESCRIPTION(ActionOrGroup::getDescription, Nls.Capitalization.Sentence, ".description", actionOrGroup -> false);

        private final Function<ActionOrGroup, GenericDomValue> myGetter;
        private final Nls.Capitalization myCapitalization;
        private final String mySuffix;
        private final Function<ActionOrGroup, Boolean> myRequired;

        private ActionOrGroupText(Function<ActionOrGroup, GenericDomValue> getter, Nls.Capitalization capitalization, String propertyKeySuffix, Function<ActionOrGroup, Boolean> required) {
            this.myGetter = getter;
            this.myCapitalization = capitalization;
            this.mySuffix = propertyKeySuffix;
            this.myRequired = required;
        }
    }
}

