/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.Language;
import com.intellij.lang.jvm.JvmClassKind;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.idea.devkit.inspections.NonDefaultConstructorInspectionKt;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastLanguagePlugin;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/idea/devkit/inspections/NonDefaultConstructorInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitUastInspectionBase;", "()V", "checkClass", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "aClass", "Lorg/jetbrains/uast/UClass;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lorg/jetbrains/uast/UClass;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.devkit"})
public final class NonDefaultConstructorInspection
extends DevKitUastInspectionBase {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        ProblemDescriptor[] problemDescriptorArray;
        PsiMethod[] constructors;
        Intrinsics.checkParameterIsNotNull((Object)aClass, (String)"aClass");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        PsiClass javaPsi = aClass.getJavaPsi();
        Language language = javaPsi.getLanguage();
        Intrinsics.checkExpressionValueIsNotNull((Object)language, (String)"javaPsi.language");
        if (Intrinsics.areEqual((Object)language.getID(), (Object)"Groovy") || javaPsi.getClassKind() != JvmClassKind.CLASS || PsiUtil.isInnerClass((PsiClass)javaPsi) || PsiUtil.isLocalOrAnonymousClass((PsiClass)javaPsi) || PsiUtil.isAbstractClass((PsiClass)javaPsi) || javaPsi.hasModifierProperty("private")) {
            return null;
        }
        PsiMethod[] psiMethodArray = javaPsi.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray, (String)"javaPsi.constructors");
        PsiMethod[] psiMethodArray2 = constructors = psiMethodArray;
        boolean bl = false;
        if (psiMethodArray2.length == 0) {
            return null;
        }
        ExtensionPoint extensionPoint = null;
        if (!NonDefaultConstructorInspectionKt.access$isExtensionBean(aClass)) {
            Project project = manager.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"manager.project");
            ExtensionPoint extensionPoint2 = NonDefaultConstructorInspectionKt.access$findExtensionPoint(aClass, project);
            if (extensionPoint2 == null) {
                return null;
            }
            extensionPoint = extensionPoint2;
        } else if (Intrinsics.areEqual((Object)javaPsi.getName(), (Object)"VcsConfigurableEP")) {
            return null;
        }
        List errors = null;
        PsiMethod[] psiMethodArray3 = constructors;
        int n = psiMethodArray3.length;
        for (int i = 0; i < n; ++i) {
            PsiElement psiElement;
            PsiParameterList parameters;
            PsiMethod method;
            PsiMethod psiMethod = method = psiMethodArray3[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"method");
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod.getParameterList(), (String)"method.parameterList");
            if (NonDefaultConstructorInspectionKt.access$isAllowedParameters(parameters, extensionPoint)) {
                return null;
            }
            if (errors == null) {
                errors = (List)new SmartList();
            }
            if (method.isPhysical()) {
                psiElement = (PsiElement)method;
            } else {
                void $this$convert$iv;
                UastLanguagePlugin uastLanguagePlugin = UastUtils.getLanguagePlugin((UElement)((UElement)aClass));
                PsiElement element$iv = (PsiElement)method;
                boolean $i$f$convert = false;
                UElement uElement = $this$convert$iv.convertElement(element$iv, (UElement)aClass, UMethod.class);
                if (uElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.UMethod");
                }
                psiElement = ((UMethod)uElement).getSourcePsi();
                if (psiElement == null) {
                    continue;
                }
            }
            PsiElement anchorElement = psiElement;
            ProblemDescriptor problemDescriptor = manager.createProblemDescriptor(anchorElement, "Extension class should not have constructor with parameters", true, ProblemHighlightType.ERROR, isOnTheFly, new LocalQuickFix[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)problemDescriptor, (String)"manager.createProblemDes\u2026htType.ERROR, isOnTheFly)");
            errors.add(problemDescriptor);
        }
        List list = errors;
        if (list != null) {
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection collection = $this$toTypedArray$iv;
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = collection;
            ProblemDescriptor[] problemDescriptorArray2 = thisCollection$iv.toArray(new ProblemDescriptor[0]);
            if (problemDescriptorArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            problemDescriptorArray = problemDescriptorArray2;
        } else {
            problemDescriptorArray = null;
        }
        return problemDescriptorArray;
    }
}

