/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.DescriptionNotFoundInspectionBase;
import org.jetbrains.idea.devkit.inspections.DescriptionType;
import org.jetbrains.idea.devkit.inspections.quickfix.CreateHtmlDescriptionFix;
import org.jetbrains.idea.devkit.util.ExtensionCandidate;
import org.jetbrains.idea.devkit.util.ExtensionLocatorKt;

public class IntentionDescriptionNotFoundInspection
extends DescriptionNotFoundInspectionBase {
    public IntentionDescriptionNotFoundInspection() {
        super(DescriptionType.INTENTION);
    }

    @Override
    protected CreateHtmlDescriptionFix getFix(Module module, String descriptionDir) {
        return new CreateHtmlDescriptionFix(descriptionDir, module, DescriptionType.INTENTION);
    }

    @Override
    protected boolean skipIfNotRegistered(PsiClass epClass) {
        List<ExtensionCandidate> registrations = ExtensionLocatorKt.locateExtensionsByPsiClass(epClass);
        return registrations.isEmpty();
    }

    @Override
    @NotNull
    protected String getHasNotDescriptionError() {
        if ("Intention does not have a description" == null) {
            IntentionDescriptionNotFoundInspection.$$$reportNull$$$0(0);
        }
        return "Intention does not have a description";
    }

    @Override
    @NotNull
    protected String getHasNotBeforeAfterError() {
        if ("Intention must have 'before.*.template' and 'after.*.template' beside 'description.html'" == null) {
            IntentionDescriptionNotFoundInspection.$$$reportNull$$$0(1);
        }
        return "Intention must have 'before.*.template' and 'after.*.template' beside 'description.html'";
    }

    @NotNull
    public String getShortName() {
        if ("IntentionDescriptionNotFoundInspection" == null) {
            IntentionDescriptionNotFoundInspection.$$$reportNull$$$0(2);
        }
        return "IntentionDescriptionNotFoundInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/idea/devkit/inspections/IntentionDescriptionNotFoundInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHasNotDescriptionError";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHasNotBeforeAfterError";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

