/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.DescriptionCheckerUtil;
import org.jetbrains.idea.devkit.inspections.DescriptionType;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;
import org.jetbrains.idea.devkit.inspections.quickfix.CreateHtmlDescriptionFix;
import org.jetbrains.idea.devkit.util.PsiUtil;

abstract class DescriptionNotFoundInspectionBase
extends DevKitInspectionBase {
    private final DescriptionType myDescriptionType;

    protected DescriptionNotFoundInspectionBase(DescriptionType descriptionType) {
        this.myDescriptionType = descriptionType;
    }

    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            DescriptionNotFoundInspectionBase.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            DescriptionNotFoundInspectionBase.$$$reportNull$$$0(1);
        }
        Project project = aClass.getProject();
        PsiIdentifier nameIdentifier = aClass.getNameIdentifier();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
        if (nameIdentifier == null || module == null || !PsiUtil.isInstantiable(aClass)) {
            return null;
        }
        PsiClass base = JavaPsiFacade.getInstance((Project)project).findClass(this.getClassName(), aClass.getResolveScope());
        if (base == null || !aClass.isInheritor(base, true)) {
            return null;
        }
        String descriptionDir = DescriptionCheckerUtil.getDescriptionDirName(aClass);
        if (StringUtil.isEmptyOrSpaces((String)descriptionDir)) {
            return null;
        }
        for (PsiDirectory description2 : this.getDescriptionsDirs(module)) {
            PsiFile descr;
            PsiDirectory dir = description2.findSubdirectory(descriptionDir);
            if (dir == null || (descr = dir.findFile("description.html")) == null) continue;
            if (!this.skipIfNotRegistered(aClass) && !DescriptionNotFoundInspectionBase.hasBeforeAndAfterTemplate(dir.getVirtualFile())) {
                PsiIdentifier problem = aClass.getNameIdentifier();
                ProblemDescriptor problemDescriptor = manager.createProblemDescriptor((PsiElement)(problem == null ? nameIdentifier : problem), this.getHasNotBeforeAfterError(), isOnTheFly, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[0]);
                return new ProblemDescriptor[]{problemDescriptor};
            }
            return null;
        }
        if (this.skipIfNotRegistered(aClass)) {
            return null;
        }
        PsiIdentifier problem = aClass.getNameIdentifier();
        ProblemDescriptor problemDescriptor = manager.createProblemDescriptor((PsiElement)(problem == null ? nameIdentifier : problem), this.getHasNotDescriptionError(), isOnTheFly, new LocalQuickFix[]{this.getFix(module, descriptionDir)}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        return new ProblemDescriptor[]{problemDescriptor};
    }

    protected CreateHtmlDescriptionFix getFix(Module module, String descriptionDir) {
        return new CreateHtmlDescriptionFix(descriptionDir, module, this.myDescriptionType);
    }

    protected abstract boolean skipIfNotRegistered(PsiClass var1);

    private static boolean hasBeforeAndAfterTemplate(@NotNull VirtualFile dir) {
        if (dir == null) {
            DescriptionNotFoundInspectionBase.$$$reportNull$$$0(2);
        }
        boolean hasBefore = false;
        boolean hasAfter = false;
        for (VirtualFile file : dir.getChildren()) {
            String name = file.getName();
            if (!name.endsWith(".template")) continue;
            if (name.startsWith("before.")) {
                hasBefore = true;
                continue;
            }
            if (!name.startsWith("after.")) continue;
            hasAfter = true;
        }
        return hasBefore && hasAfter;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    protected String getClassName() {
        String string = this.myDescriptionType.getClassName();
        if (string == null) {
            DescriptionNotFoundInspectionBase.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    protected PsiDirectory[] getDescriptionsDirs(@NotNull Module module) {
        if (module == null) {
            DescriptionNotFoundInspectionBase.$$$reportNull$$$0(4);
        }
        PsiDirectory[] psiDirectoryArray = DescriptionCheckerUtil.getDescriptionsDirs(module, this.myDescriptionType);
        if (psiDirectoryArray == null) {
            DescriptionNotFoundInspectionBase.$$$reportNull$$$0(5);
        }
        return psiDirectoryArray;
    }

    @NotNull
    protected abstract String getHasNotDescriptionError();

    @NotNull
    protected abstract String getHasNotBeforeAfterError();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/DescriptionNotFoundInspectionBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/DescriptionNotFoundInspectionBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionsDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasBeforeAndAfterTemplate";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptionsDirs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

