/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.index;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.Action;
import org.jetbrains.idea.devkit.dom.Actions;
import org.jetbrains.idea.devkit.dom.Component;
import org.jetbrains.idea.devkit.dom.Group;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.index.RegistrationEntry;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

class RegistrationIndexer {
    private final FileContent myContent;
    private Map<String, List<RegistrationEntry>> myValueMap;

    RegistrationIndexer(FileContent content) {
        this.myContent = content;
    }

    @NotNull
    Map<String, List<RegistrationEntry>> indexFile() {
        CharSequence text = this.myContent.getContentAsText();
        if (CharArrayUtil.indexOf((CharSequence)text, (CharSequence)"<idea-plugin", (int)0) == -1) {
            Map<String, List<RegistrationEntry>> map = Collections.emptyMap();
            if (map == null) {
                RegistrationIndexer.$$$reportNull$$$0(0);
            }
            return map;
        }
        PsiFile file = this.myContent.getPsiFile();
        if (!(file instanceof XmlFile)) {
            Map<String, List<RegistrationEntry>> map = Collections.emptyMap();
            if (map == null) {
                RegistrationIndexer.$$$reportNull$$$0(1);
            }
            return map;
        }
        DomFileElement<IdeaPlugin> fileElement = DescriptorUtil.getIdeaPlugin((XmlFile)file);
        if (fileElement == null) {
            Map<String, List<RegistrationEntry>> map = Collections.emptyMap();
            if (map == null) {
                RegistrationIndexer.$$$reportNull$$$0(2);
            }
            return map;
        }
        this.myValueMap = FactoryMap.create(s -> new SmartList());
        this.process((IdeaPlugin)fileElement.getRootElement());
        Map<String, List<RegistrationEntry>> map = this.myValueMap;
        if (map == null) {
            RegistrationIndexer.$$$reportNull$$$0(3);
        }
        return map;
    }

    private void process(IdeaPlugin ideaPlugin) {
        this.processActions(ideaPlugin);
        this.processComponents(ideaPlugin.getApplicationComponents(), components -> components.getComponents(), RegistrationEntry.RegistrationType.APPLICATION_COMPONENT);
        this.processComponents(ideaPlugin.getProjectComponents(), components -> components.getComponents(), RegistrationEntry.RegistrationType.PROJECT_COMPONENT);
        this.processComponents(ideaPlugin.getModuleComponents(), components -> components.getComponents(), RegistrationEntry.RegistrationType.MODULE_COMPONENT);
    }

    private <T extends DomElement> void processComponents(List<T> componentWrappers, Function<T, List<? extends Component>> componentGetter, RegistrationEntry.RegistrationType type) {
        for (DomElement wrapper : componentWrappers) {
            for (Component component : (List)componentGetter.fun((Object)wrapper)) {
                this.addEntry(component, component.getImplementationClass(), type);
            }
        }
    }

    private void processActions(IdeaPlugin ideaPlugin) {
        for (Actions actions : ideaPlugin.getActions()) {
            for (Action action : actions.getActions()) {
                this.processAction(action);
            }
            for (Group group : actions.getGroups()) {
                this.processGroup(group);
            }
        }
    }

    private void processGroup(Group group) {
        this.addEntry(group, (GenericDomValue<PsiClass>)group.getClazz(), RegistrationEntry.RegistrationType.ACTION);
        for (Action action : group.getActions()) {
            this.processAction(action);
        }
        for (Group nestedGroup : group.getGroups()) {
            this.processGroup(nestedGroup);
        }
    }

    private void processAction(Action action) {
        this.addEntry(action, (GenericDomValue<PsiClass>)action.getClazz(), RegistrationEntry.RegistrationType.ACTION);
    }

    private void addEntry(DomElement domElement, GenericDomValue<PsiClass> clazzValue, RegistrationEntry.RegistrationType type) {
        if (!DomUtil.hasXml(clazzValue)) {
            return;
        }
        String clazz = clazzValue.getStringValue();
        if (clazz == null) {
            return;
        }
        String className = clazz.replace('$', '.');
        List<RegistrationEntry> entries = this.myValueMap.get(className);
        RegistrationEntry entry = new RegistrationEntry(type, RegistrationIndexer.getOffset(domElement));
        entries.add(entry);
    }

    private static int getOffset(DomElement element) {
        XmlElement xmlElement = element.getXmlElement();
        assert (xmlElement != null) : element;
        return xmlElement.getTextOffset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/dom/index/RegistrationIndexer", "indexFile"));
    }
}

