/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.codeInsight.completion.CompletionConfidenceEP;
import com.intellij.codeInsight.completion.CompletionContributorEP;
import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;

class LanguageResolvingUtil {
    private static final String ANY_LANGUAGE_DEFAULT_ID = Language.ANY.getID();
    private static final Set<String> EP_WITH_ANY_LANGUAGE_ID = ContainerUtil.immutableSet((Object[])new String[]{CompletionContributorEP.class.getName(), CompletionConfidenceEP.class.getName()});

    LanguageResolvingUtil() {
    }

    static Collection<LanguageDefinition> getAllLanguageDefinitions(ConvertContext context) {
        List<LanguageDefinition> languageDefinitions = LanguageResolvingUtil.collectLanguageDefinitions(context);
        ContainerUtil.addIfNotNull(languageDefinitions, (Object)LanguageResolvingUtil.createAnyLanguageDefinition(context));
        return languageDefinitions;
    }

    private static List<LanguageDefinition> collectLanguageDefinitions(ConvertContext context) {
        Project project = context.getProject();
        Collection allLanguages = (Collection)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            PsiClass languageClass = JavaPsiFacade.getInstance((Project)project).findClass(Language.class.getName(), GlobalSearchScope.allScope((Project)project));
            if (languageClass == null) {
                return CachedValueProvider.Result.create(Collections.emptyList(), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
            GlobalSearchScope projectProductionScope = GlobalSearchScopesCore.projectProductionScope((Project)project);
            GlobalSearchScope allScope = projectProductionScope.union((SearchScope)ProjectScope.getLibrariesScope((Project)project));
            Collection allInheritors = ClassInheritorsSearch.search((PsiClass)languageClass, (SearchScope)allScope, (boolean)true).findAll();
            return CachedValueProvider.Result.create((Object)allInheritors, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
        if (allLanguages.isEmpty()) {
            return new SmartList();
        }
        List<LanguageDefinition> libraryDefinitions = LanguageResolvingUtil.collectLibraryLanguages(context, allLanguages);
        GlobalSearchScope projectProductionScope = GlobalSearchScopesCore.projectProductionScope((Project)project);
        List projectLanguages = ContainerUtil.filter((Collection)allLanguages, aClass -> PsiSearchScopeUtil.isInScope((GlobalSearchScope)projectProductionScope, (PsiElement)aClass));
        List<LanguageDefinition> projectDefinitions = LanguageResolvingUtil.collectProjectLanguages(projectLanguages, libraryDefinitions);
        ArrayList<LanguageDefinition> all = new ArrayList<LanguageDefinition>(libraryDefinitions);
        all.addAll(projectDefinitions);
        return all;
    }

    private static List<LanguageDefinition> collectLibraryLanguages(ConvertContext context, Collection<PsiClass> allLanguages) {
        return ContainerUtil.mapNotNull((Collection)Language.getRegisteredLanguages(), (Function)((NullableFunction)language -> {
            if (language.getID().isEmpty()) {
                return null;
            }
            PsiClass psiClass = DomJavaUtil.findClass((String)language.getClass().getName(), (DomElement)context.getInvocationElement(), (boolean)true);
            if (psiClass == null || !allLanguages.contains(psiClass)) {
                return null;
            }
            LanguageFileType type = language.getAssociatedFileType();
            Icon icon = type != null ? type.getIcon() : null;
            return new LanguageDefinition(language.getID(), psiClass, icon, language.getDisplayName());
        }));
    }

    private static List<LanguageDefinition> collectProjectLanguages(Collection<PsiClass> projectLanguages, List<LanguageDefinition> libraryLanguages) {
        return ContainerUtil.mapNotNull(projectLanguages, (Function)((NullableFunction)language -> {
            if (language.hasModifierProperty("abstract")) {
                return null;
            }
            if (ContainerUtil.exists((Iterable)libraryLanguages, definition -> definition.clazz.equals(language))) {
                return null;
            }
            return (LanguageDefinition)CachedValuesManager.getCachedValue((PsiElement)language, () -> {
                String languageId = LanguageResolvingUtil.computeConstantSuperCtorCallParameter(language, 0);
                if (languageId == null) {
                    languageId = LanguageResolvingUtil.computeConstantSuperCtorCallParameter(language, 1);
                }
                if (languageId == null) {
                    languageId = LanguageResolvingUtil.computeConstantReturnValue(language, "getID");
                }
                if (StringUtil.isEmpty((String)languageId)) {
                    return CachedValueProvider.Result.create((Object)null, (Object[])new Object[]{language});
                }
                String displayName = LanguageResolvingUtil.computeConstantReturnValue(language, "getDisplayName");
                return CachedValueProvider.Result.createSingleDependency((Object)new LanguageDefinition(languageId, (PsiClass)language, null, displayName), (Object)language);
            });
        }));
    }

    @Nullable
    private static String computeConstantReturnValue(PsiClass languagePsiClass, String methodName) {
        PsiMethod[] methods = languagePsiClass.findMethodsByName(methodName, false);
        if (methods.length != 1) {
            return null;
        }
        return LanguageResolvingUtil.getStringConstantExpression((PsiElement)methods[0]);
    }

    private static String computeConstantSuperCtorCallParameter(PsiClass languagePsiClass, int index) {
        if (languagePsiClass instanceof PsiAnonymousClass) {
            return LanguageResolvingUtil.getStringConstantExpression(((PsiAnonymousClass)languagePsiClass).getArgumentList(), index);
        }
        PsiMethod defaultConstructor = null;
        for (PsiMethod constructor : languagePsiClass.getConstructors()) {
            if (!constructor.getParameterList().isEmpty()) continue;
            defaultConstructor = constructor;
            break;
        }
        if (defaultConstructor == null) {
            return null;
        }
        PsiCodeBlock body = defaultConstructor.getBody();
        if (body == null) {
            return null;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length < 1) {
            return null;
        }
        PsiStatement statement = statements[0];
        if (!(statement instanceof PsiExpressionStatement)) {
            return null;
        }
        PsiExpression expression = ((PsiExpressionStatement)statement).getExpression();
        if (!(expression instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
        PsiExpressionList expressionList = methodCallExpression.getArgumentList();
        return LanguageResolvingUtil.getStringConstantExpression(expressionList, index);
    }

    @Nullable
    private static String getStringConstantExpression(@Nullable PsiExpressionList expressionList, int index) {
        if (expressionList == null) {
            return null;
        }
        PsiExpression[] argumentExpressions = expressionList.getExpressions();
        if (argumentExpressions.length < index + 1) {
            return null;
        }
        return LanguageResolvingUtil.getStringConstantExpression((PsiElement)argumentExpressions[index]);
    }

    @Nullable
    private static String getStringConstantExpression(PsiElement psiElement) {
        Pair pair = StringExpressionHelper.evaluateConstantExpression((PsiElement)psiElement);
        return (String)Pair.getSecond((Pair)pair);
    }

    @Nullable
    private static LanguageDefinition createAnyLanguageDefinition(ConvertContext context) {
        PsiClass languageClass = DomJavaUtil.findClass((String)Language.class.getName(), (DomElement)context.getInvocationElement());
        if (languageClass == null) {
            return null;
        }
        String anyLanguageId = LanguageResolvingUtil.calculateAnyLanguageId(context);
        return new LanguageDefinition(anyLanguageId, languageClass, AllIcons.FileTypes.Any_type, "<any language>");
    }

    private static String calculateAnyLanguageId(ConvertContext context) {
        Extension extension = (Extension)context.getInvocationElement().getParentOfType(Extension.class, true);
        if (extension == null) {
            return ANY_LANGUAGE_DEFAULT_ID;
        }
        ExtensionPoint extensionPoint = extension.getExtensionPoint();
        if (extensionPoint == null) {
            return ANY_LANGUAGE_DEFAULT_ID;
        }
        GenericAttributeValue<PsiClass> epBeanClass = extensionPoint.getBeanClass();
        if (EP_WITH_ANY_LANGUAGE_ID.contains(epBeanClass.getStringValue())) {
            return "any";
        }
        return ANY_LANGUAGE_DEFAULT_ID;
    }

    static class LanguageDefinition {
        final String id;
        final PsiClass clazz;
        final Icon icon;
        final String displayName;
        final String type;

        LanguageDefinition(@NotNull String id, @NotNull PsiClass clazz, @Nullable Icon icon, @Nullable String displayName) {
            if (id == null) {
                LanguageDefinition.$$$reportNull$$$0(0);
            }
            if (clazz == null) {
                LanguageDefinition.$$$reportNull$$$0(1);
            }
            this.id = id;
            this.clazz = clazz;
            this.type = clazz instanceof PsiAnonymousClass ? ((PsiAnonymousClass)clazz).getBaseClassReference().getQualifiedName() : clazz.getQualifiedName();
            this.icon = icon;
            this.displayName = displayName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LanguageDefinition)) {
                return false;
            }
            return this.clazz.equals(((LanguageDefinition)o).clazz);
        }

        public int hashCode() {
            return this.clazz.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "id";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "clazz";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/devkit/dom/impl/LanguageResolvingUtil$LanguageDefinition";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

