/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.impl.ExtensionDomExtender;

public abstract class ExtensionPointImpl
implements ExtensionPoint {
    @Override
    @NotNull
    public String getEffectiveName() {
        if (DomUtil.hasXml(this.getName())) {
            String string = StringUtil.notNullize((String)this.getName().getRawText());
            if (string == null) {
                ExtensionPointImpl.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = StringUtil.notNullize((String)this.getQualifiedName().getRawText());
        if (string == null) {
            ExtensionPointImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public String getNamePrefix() {
        if (DomUtil.hasXml(this.getQualifiedName())) {
            return null;
        }
        IdeaPlugin plugin = (IdeaPlugin)this.getParentOfType(IdeaPlugin.class, false);
        if (plugin == null) {
            return null;
        }
        return StringUtil.notNullize((String)plugin.getPluginId(), (String)"com.intellij");
    }

    @Override
    @NotNull
    public String getEffectiveQualifiedName() {
        if (DomUtil.hasXml(this.getQualifiedName())) {
            String string = StringUtil.notNullize((String)this.getQualifiedName().getRawText());
            if (string == null) {
                ExtensionPointImpl.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = this.getNamePrefix() + "." + StringUtil.notNullize((String)this.getName().getRawText());
        if (string == null) {
            ExtensionPointImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public List<PsiField> collectMissingWithTags() {
        PsiClass beanClass = (PsiClass)this.getBeanClass().getValue();
        if (beanClass == null) {
            return Collections.emptyList();
        }
        SmartList result = new SmartList();
        for (PsiField field : beanClass.getAllFields()) {
            String fieldName = field.getName();
            if (fieldName == null || !Extension.isClassField(fieldName) || ExtensionDomExtender.findWithElement(this.getWithElements(), field) != null) continue;
            result.add(field);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/idea/devkit/dom/impl/ExtensionPointImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveQualifiedName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

