/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.ide;

import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.module.PluginDescriptorConstants;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/idea/devkit/dom/ide/PluginDescriptorEditorTabTitleProvider;", "Lcom/intellij/openapi/fileEditor/impl/EditorTabTitleProvider;", "()V", "getEditorTabTitle", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.devkit"})
public final class PluginDescriptorEditorTabTitleProvider
implements EditorTabTitleProvider {
    @Nullable
    public String getEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        ConfigFileMetaData configFileMetaData = PluginDescriptorConstants.META_DATA;
        Intrinsics.checkExpressionValueIsNotNull((Object)configFileMetaData, (String)"PluginDescriptorConstants.META_DATA");
        if (Intrinsics.areEqual((Object)configFileMetaData.getFileName(), (Object)file.getName()) ^ true) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (!(psiFile instanceof XmlFile)) {
            psiFile = null;
        }
        XmlFile xmlFile = (XmlFile)psiFile;
        if (xmlFile == null) {
            return null;
        }
        XmlFile xmlFile2 = xmlFile;
        DomFileElement<IdeaPlugin> domFileElement = DescriptorUtil.getIdeaPlugin(xmlFile2);
        if (domFileElement == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull(domFileElement, (String)"DescriptorUtil.getIdeaPl\u2026n(xmlFile) ?: return null");
        DomFileElement<IdeaPlugin> ideaPlugin = domFileElement;
        StringBuilder stringBuilder = new StringBuilder();
        ConfigFileMetaData configFileMetaData2 = PluginDescriptorConstants.META_DATA;
        Intrinsics.checkExpressionValueIsNotNull((Object)configFileMetaData2, (String)"PluginDescriptorConstants.META_DATA");
        StringBuilder stringBuilder2 = stringBuilder.append(configFileMetaData2.getFileName()).append(" (");
        DomElement domElement = ideaPlugin.getRootElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)domElement, (String)"ideaPlugin.rootElement");
        return stringBuilder2.append(((IdeaPlugin)domElement).getPluginId()).append(')').toString();
    }
}

