/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.build;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.build.PrepareToDeployAction;
import org.jetbrains.idea.devkit.module.PluginModuleType;

public class PrepareAllToDeployAction
extends PrepareToDeployAction {
    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            PrepareAllToDeployAction.$$$reportNull$$$0(0);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        ArrayList<Module> pluginModules = new ArrayList<Module>();
        for (Module aModule : ModuleManager.getInstance((Project)project).getModules()) {
            if (!PluginModuleType.isOfType(aModule)) continue;
            pluginModules.add(aModule);
        }
        ChooseModulesDialog dialog = new ChooseModulesDialog(project, pluginModules, DevKitBundle.message("select.plugin.modules.title", new Object[0]), DevKitBundle.message("select.plugin.modules.description", new Object[0]));
        if (dialog.showAndGet()) {
            this.doPrepare(dialog.getChosenElements(), project);
        }
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Module module;
        if (e == null) {
            PrepareAllToDeployAction.$$$reportNull$$$0(1);
        }
        long moduleCount = 0L;
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project != null) {
            moduleCount = Arrays.stream(ModuleManager.getInstance((Project)project).getModules()).filter(PluginModuleType::isOfType).limit(2L).count();
        }
        boolean enabled = false;
        if (moduleCount > 1L) {
            enabled = true;
        } else if (!(moduleCount <= 0L || (module = (Module)e.getData(LangDataKeys.MODULE)) != null && PluginModuleType.isOfType(module))) {
            enabled = true;
        }
        e.getPresentation().setEnabledAndVisible(enabled);
        if (enabled) {
            e.getPresentation().setText(DevKitBundle.message("prepare.for.deployment.all", new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "org/jetbrains/idea/devkit/build/PrepareAllToDeployAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

