/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.dsl.impl;

import com.intellij.debugger.streams.trace.dsl.ArrayVariable;
import com.intellij.debugger.streams.trace.dsl.CodeBlock;
import com.intellij.debugger.streams.trace.dsl.CodeContext;
import com.intellij.debugger.streams.trace.dsl.CompositeCodeBlock;
import com.intellij.debugger.streams.trace.dsl.Convertable;
import com.intellij.debugger.streams.trace.dsl.Dsl;
import com.intellij.debugger.streams.trace.dsl.Expression;
import com.intellij.debugger.streams.trace.dsl.ForLoopBody;
import com.intellij.debugger.streams.trace.dsl.IfBranch;
import com.intellij.debugger.streams.trace.dsl.Lambda;
import com.intellij.debugger.streams.trace.dsl.LambdaBody;
import com.intellij.debugger.streams.trace.dsl.ListVariable;
import com.intellij.debugger.streams.trace.dsl.MapVariable;
import com.intellij.debugger.streams.trace.dsl.Statement;
import com.intellij.debugger.streams.trace.dsl.StatementFactory;
import com.intellij.debugger.streams.trace.dsl.TryBlock;
import com.intellij.debugger.streams.trace.dsl.Types;
import com.intellij.debugger.streams.trace.dsl.Variable;
import com.intellij.debugger.streams.trace.dsl.VariableDeclaration;
import com.intellij.debugger.streams.trace.dsl.impl.TextExpression;
import com.intellij.debugger.streams.trace.impl.handler.type.GenericType;
import com.intellij.debugger.streams.wrapper.IntermediateStreamCall;
import java.util.Arrays;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u000e\u0018\u00002\u00020\u0001:\u0001BB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J!\u0010\u0015\u001a\u00020\u00162\u0017\u0010\u0017\u001a\u0013\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018\u00a2\u0006\u0002\b\u001bH\u0016J!\u0010\u001c\u001a\u00020\u00142\u0017\u0010\u0017\u001a\u0013\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018\u00a2\u0006\u0002\b\u001bH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0014H\u0016J\b\u0010\"\u001a\u00020\u0006H\u0016J \u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010'\u001a\u00020(H\u0016J/\u0010\u001f\u001a\u00020 2\u0006\u0010)\u001a\u00020\u00142\u001d\u0010\u0017\u001a\u0019\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001a0*\u00a2\u0006\u0002\b\u001bH\u0016J \u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u00100\u001a\u0002012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u00102\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J)\u00103\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u00104\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000605\"\u00020\u0006H\u0016\u00a2\u0006\u0002\u00106J)\u00107\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u00104\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000605\"\u00020\u0006H\u0016\u00a2\u0006\u0002\u00106J\u0018\u00108\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00109\u001a\u00020\u0006H\u0016J\b\u0010:\u001a\u00020$H\u0016J\b\u0010;\u001a\u00020\u0006H\u0016J\u0018\u0010%\u001a\u00020&2\u0006\u0010<\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0015\u0010=\u001a\u00020\u0006*\u00020\u00062\u0006\u0010>\u001a\u00020\u0006H\u0096\u0004J\u0015\u0010?\u001a\u00020\u0006*\u00020\u00062\u0006\u0010>\u001a\u00020\u0006H\u0096\u0004J\r\u0010@\u001a\u00020\u0006*\u00020\u0006H\u0096\u0002J\u0015\u0010A\u001a\u00020\u0006*\u00020\u00062\u0006\u0010>\u001a\u00020\u0006H\u0096\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006C"}, d2={"Lcom/intellij/debugger/streams/trace/dsl/impl/DslImpl;", "Lcom/intellij/debugger/streams/trace/dsl/Dsl;", "statementFactory", "Lcom/intellij/debugger/streams/trace/dsl/StatementFactory;", "(Lcom/intellij/debugger/streams/trace/dsl/StatementFactory;)V", "nullExpression", "Lcom/intellij/debugger/streams/trace/dsl/Expression;", "getNullExpression", "()Lcom/intellij/debugger/streams/trace/dsl/Expression;", "thisExpression", "getThisExpression", "types", "Lcom/intellij/debugger/streams/trace/dsl/Types;", "getTypes", "()Lcom/intellij/debugger/streams/trace/dsl/Types;", "array", "Lcom/intellij/debugger/streams/trace/dsl/ArrayVariable;", "elementType", "Lcom/intellij/debugger/streams/trace/impl/handler/type/GenericType;", "name", "", "block", "Lcom/intellij/debugger/streams/trace/dsl/CodeBlock;", "init", "Lkotlin/Function1;", "Lcom/intellij/debugger/streams/trace/dsl/CodeContext;", "", "Lkotlin/ExtensionFunctionType;", "code", "createPeekCall", "Lcom/intellij/debugger/streams/wrapper/IntermediateStreamCall;", "lambda", "Lcom/intellij/debugger/streams/trace/dsl/Lambda;", "elementsType", "currentTime", "declaration", "Lcom/intellij/debugger/streams/trace/dsl/VariableDeclaration;", "variable", "Lcom/intellij/debugger/streams/trace/dsl/Variable;", "isMutable", "", "argName", "Lkotlin/Function2;", "Lcom/intellij/debugger/streams/trace/dsl/LambdaBody;", "linkedMap", "Lcom/intellij/debugger/streams/trace/dsl/MapVariable;", "keyType", "valueType", "list", "Lcom/intellij/debugger/streams/trace/dsl/ListVariable;", "map", "newArray", "args", "", "(Lcom/intellij/debugger/streams/trace/impl/handler/type/GenericType;[Lcom/intellij/debugger/streams/trace/dsl/Expression;)Lcom/intellij/debugger/streams/trace/dsl/Expression;", "newList", "newSizedArray", "size", "timeDeclaration", "updateTime", "type", "and", "right", "equals", "not", "same", "MyContext", "intellij.java.debugger.streams"})
public final class DslImpl
implements Dsl {
    @NotNull
    private final Expression nullExpression;
    @NotNull
    private final Expression thisExpression;
    @NotNull
    private final Types types;
    private final StatementFactory statementFactory;

    @Override
    @NotNull
    public Expression getNullExpression() {
        return this.nullExpression;
    }

    @Override
    @NotNull
    public Expression getThisExpression() {
        return this.thisExpression;
    }

    @Override
    @NotNull
    public Types getTypes() {
        return this.types;
    }

    @Override
    @NotNull
    public Variable variable(@NotNull GenericType type, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.statementFactory.createVariable(type, name);
    }

    @Override
    @NotNull
    public String code(@NotNull Function1<? super CodeContext, Unit> init) {
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        MyContext fragment = new MyContext();
        init.invoke((Object)fragment);
        return fragment.toCode(0);
    }

    @Override
    @NotNull
    public CodeBlock block(@NotNull Function1<? super CodeContext, Unit> init) {
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        MyContext fragment = new MyContext();
        init.invoke((Object)fragment);
        return fragment;
    }

    @Override
    @NotNull
    public ArrayVariable array(@NotNull GenericType elementType, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.statementFactory.createArrayVariable(elementType, name);
    }

    @Override
    @NotNull
    public Expression newArray(@NotNull GenericType elementType, Expression ... args) {
        Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        return this.statementFactory.createNewArrayExpression(elementType, args);
    }

    @Override
    @NotNull
    public Expression newSizedArray(@NotNull GenericType elementType, @NotNull Expression size) {
        Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
        Intrinsics.checkParameterIsNotNull((Object)size, (String)"size");
        return this.statementFactory.createNewSizedArray(elementType, size);
    }

    @Override
    @NotNull
    public MapVariable map(@NotNull GenericType keyType, @NotNull GenericType valueType, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)keyType, (String)"keyType");
        Intrinsics.checkParameterIsNotNull((Object)valueType, (String)"valueType");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.statementFactory.createMapVariable(keyType, valueType, name, false);
    }

    @Override
    @NotNull
    public ListVariable list(@NotNull GenericType elementType, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.statementFactory.createListVariable(elementType, name);
    }

    @Override
    @NotNull
    public Expression newList(@NotNull GenericType elementType, Expression ... args) {
        Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        return this.statementFactory.createNewListExpression(elementType, Arrays.copyOf(args, args.length));
    }

    @Override
    @NotNull
    public MapVariable linkedMap(@NotNull GenericType keyType, @NotNull GenericType valueType, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)keyType, (String)"keyType");
        Intrinsics.checkParameterIsNotNull((Object)valueType, (String)"valueType");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.statementFactory.createMapVariable(keyType, valueType, name, true);
    }

    @Override
    @NotNull
    public Lambda lambda(@NotNull String argName, @NotNull Function2<? super LambdaBody, ? super Expression, Unit> init) {
        Intrinsics.checkParameterIsNotNull((Object)argName, (String)"argName");
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        LambdaBody lambdaBody = this.statementFactory.createEmptyLambdaBody(argName);
        init.invoke((Object)lambdaBody, (Object)this.getExpr(argName));
        return this.statementFactory.createLambda(argName, lambdaBody);
    }

    @Override
    @NotNull
    public VariableDeclaration declaration(@NotNull Variable variable, @NotNull Expression init, boolean isMutable) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)init, (String)"init");
        return this.statementFactory.createVariableDeclaration(variable, init, isMutable);
    }

    @Override
    @NotNull
    public VariableDeclaration timeDeclaration() {
        return this.statementFactory.createTimeVariableDeclaration();
    }

    @Override
    @NotNull
    public Expression currentTime() {
        return this.statementFactory.currentTimeExpression();
    }

    @Override
    @NotNull
    public Expression updateTime() {
        return this.statementFactory.updateCurrentTimeExpression();
    }

    @Override
    @NotNull
    public IntermediateStreamCall createPeekCall(@NotNull GenericType elementsType, @NotNull String lambda2) {
        Intrinsics.checkParameterIsNotNull((Object)elementsType, (String)"elementsType");
        Intrinsics.checkParameterIsNotNull((Object)lambda2, (String)"lambda");
        return this.statementFactory.createPeekCall(elementsType, lambda2);
    }

    @Override
    @NotNull
    public IntermediateStreamCall createPeekCall(@NotNull GenericType elementType, @NotNull Lambda lambda2) {
        Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
        Intrinsics.checkParameterIsNotNull((Object)lambda2, (String)"lambda");
        return this.statementFactory.createPeekCall(elementType, lambda2);
    }

    @Override
    @NotNull
    public Expression and(@NotNull Expression $this$and, @NotNull Expression right) {
        Intrinsics.checkParameterIsNotNull((Object)$this$and, (String)"$this$and");
        Intrinsics.checkParameterIsNotNull((Object)right, (String)"right");
        return this.statementFactory.and($this$and, right);
    }

    @Override
    @NotNull
    public Expression equals(@NotNull Expression $this$equals, @NotNull Expression right) {
        Intrinsics.checkParameterIsNotNull((Object)$this$equals, (String)"$this$equals");
        Intrinsics.checkParameterIsNotNull((Object)right, (String)"right");
        return this.statementFactory.equals($this$equals, right);
    }

    @Override
    @NotNull
    public Expression same(@NotNull Expression $this$same, @NotNull Expression right) {
        Intrinsics.checkParameterIsNotNull((Object)$this$same, (String)"$this$same");
        Intrinsics.checkParameterIsNotNull((Object)right, (String)"right");
        return this.statementFactory.same($this$same, right);
    }

    @Override
    @NotNull
    public Expression not(@NotNull Expression $this$not) {
        Intrinsics.checkParameterIsNotNull((Object)$this$not, (String)"$this$not");
        return this.statementFactory.not($this$not);
    }

    public DslImpl(@NotNull StatementFactory statementFactory) {
        Intrinsics.checkParameterIsNotNull((Object)statementFactory, (String)"statementFactory");
        this.statementFactory = statementFactory;
        this.nullExpression = new TextExpression("null");
        this.thisExpression = new TextExpression("this");
        this.types = this.statementFactory.getTypes();
    }

    @Override
    @NotNull
    public Expression newSizedArray(@NotNull GenericType elementType, int size) {
        Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
        return Dsl.DefaultImpls.newSizedArray(this, elementType, size);
    }

    @Override
    @NotNull
    public Expression getExpr(@NotNull String $this$expr) {
        Intrinsics.checkParameterIsNotNull((Object)$this$expr, (String)"$this$expr");
        return Dsl.DefaultImpls.getExpr(this, $this$expr);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0096\u0001J\u0019\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0014H\u0096\u0001J\"\u0010\u0019\u001a\u00020\u00032\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00180 \u00a2\u0006\u0002\b!H\u0096\u0001J2\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u00142\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060&\"\u00020\u0006H\u0096\u0001\u00a2\u0006\u0002\u0010'J\"\u0010(\u001a\u00020\u00142\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00180 \u00a2\u0006\u0002\b!H\u0096\u0001J\u0019\u0010)\u001a\u00020*2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020,H\u0096\u0001J\u0019\u0010)\u001a\u00020*2\u0006\u0010-\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u0014H\u0097\u0001J\t\u0010.\u001a\u00020\u0006H\u0096\u0001J!\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u00103\u001a\u000204H\u0096\u0001J!\u00105\u001a\u0002022\u0006\u00101\u001a\u0002022\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u00103\u001a\u000204H\u0096\u0001J\u0019\u00105\u001a\u0002022\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0096\u0001J\u0011\u00105\u001a\u0002022\u0006\u0010/\u001a\u000200H\u0096\u0001J\u0011\u00106\u001a\u00020\u00182\u0006\u00107\u001a\u00020\u0006H\u0096\u0001J2\u00108\u001a\u00020\u00182\u0006\u00109\u001a\u0002022\u0006\u0010:\u001a\u00020\u00062\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020\u00180 \u00a2\u0006\u0002\b!H\u0096\u0001J:\u0010<\u001a\u00020\u00182\u0006\u0010=\u001a\u0002002\u0006\u0010>\u001a\u00020\u00062\u0006\u0010?\u001a\u00020\u00062\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020\u00180 \u00a2\u0006\u0002\b!H\u0096\u0001J\u000f\u0010@\u001a\b\u0012\u0004\u0012\u00020B0AH\u0096\u0001J*\u0010C\u001a\u00020D2\u0006\u0010>\u001a\u00020\u00062\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00180 \u00a2\u0006\u0002\b!H\u0096\u0001J0\u0010+\u001a\u00020,2\u0006\u0010E\u001a\u00020\u00142\u001d\u0010\u001f\u001a\u0019\u0012\u0004\u0012\u00020G\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00180F\u00a2\u0006\u0002\b!H\u0096\u0001J!\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\u001d2\u0006\u0010K\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0014H\u0096\u0001J\u0019\u0010L\u001a\u00020M2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0014H\u0096\u0001J!\u0010N\u001a\u00020I2\u0006\u0010J\u001a\u00020\u001d2\u0006\u0010K\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0014H\u0096\u0001J*\u0010O\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060&\"\u00020\u0006H\u0096\u0001\u00a2\u0006\u0002\u0010PJ*\u0010Q\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060&\"\u00020\u0006H\u0096\u0001\u00a2\u0006\u0002\u0010PJ\u0019\u0010R\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\u0006H\u0096\u0001J\u0019\u0010R\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\nH\u0096\u0001J\"\u0010S\u001a\u00020\u00182\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00180 \u00a2\u0006\u0002\b!H\u0096\u0001J\u0017\u0010T\u001a\u00020\u00182\f\u0010T\u001a\b\u0012\u0004\u0012\u00020V0UH\u0096\u0001J\t\u0010W\u001a\u000200H\u0096\u0001J\u0011\u0010X\u001a\u00020\u00142\u0006\u0010Y\u001a\u00020\nH\u0096\u0001J\"\u0010Z\u001a\u00020[2\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00180 \u00a2\u0006\u0002\b!H\u0096\u0001J\t\u0010\\\u001a\u00020\u0006H\u0096\u0001J\u0019\u00101\u001a\u0002022\u0006\u0010]\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0014H\u0096\u0001J\u0015\u0010^\u001a\u00020\u0006*\u00020\u00062\u0006\u0010_\u001a\u00020\u0006H\u0096\u0005J\u0015\u0010`\u001a\u00020\u0018*\u0002022\u0006\u00107\u001a\u00020\u0006H\u0096\u0005J\u0015\u0010a\u001a\u00020\u0006*\u00020\u00062\u0006\u0010_\u001a\u00020\u0006H\u0096\u0005J\r\u0010b\u001a\u00020\u0006*\u00020\u0006H\u0096\u0003J\u0015\u0010c\u001a\u00020\u0006*\u00020\u00062\u0006\u0010_\u001a\u00020\u0006H\u0096\u0005J\r\u0010d\u001a\u00020\u0018*\u00020VH\u0096\u0003J\u0015\u0010e\u001a\u00020\u0014*\u00020\u00142\u0006\u0010Y\u001a\u00020\nH\u0096\u0001R\u0012\u0010\u0005\u001a\u00020\u0006X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u0006X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u0012\u0010\u000f\u001a\u00020\u0010X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\u00020\u0006*\u00020\u00148VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006f"}, d2={"Lcom/intellij/debugger/streams/trace/dsl/impl/DslImpl$MyContext;", "Lcom/intellij/debugger/streams/trace/dsl/CodeContext;", "Lcom/intellij/debugger/streams/trace/dsl/Dsl;", "Lcom/intellij/debugger/streams/trace/dsl/CodeBlock;", "(Lcom/intellij/debugger/streams/trace/dsl/impl/DslImpl;)V", "nullExpression", "Lcom/intellij/debugger/streams/trace/dsl/Expression;", "getNullExpression", "()Lcom/intellij/debugger/streams/trace/dsl/Expression;", "size", "", "getSize", "()I", "thisExpression", "getThisExpression", "types", "Lcom/intellij/debugger/streams/trace/dsl/Types;", "getTypes", "()Lcom/intellij/debugger/streams/trace/dsl/Types;", "expr", "", "getExpr", "(Ljava/lang/String;)Lcom/intellij/debugger/streams/trace/dsl/Expression;", "add", "", "block", "array", "Lcom/intellij/debugger/streams/trace/dsl/ArrayVariable;", "elementType", "Lcom/intellij/debugger/streams/trace/impl/handler/type/GenericType;", "name", "init", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "call", "receiver", "methodName", "args", "", "(Lcom/intellij/debugger/streams/trace/dsl/Expression;Ljava/lang/String;[Lcom/intellij/debugger/streams/trace/dsl/Expression;)Lcom/intellij/debugger/streams/trace/dsl/Expression;", "code", "createPeekCall", "Lcom/intellij/debugger/streams/wrapper/IntermediateStreamCall;", "lambda", "Lcom/intellij/debugger/streams/trace/dsl/Lambda;", "elementsType", "currentTime", "declaration", "Lcom/intellij/debugger/streams/trace/dsl/VariableDeclaration;", "variable", "Lcom/intellij/debugger/streams/trace/dsl/Variable;", "isMutable", "", "declare", "doReturn", "expression", "forEachLoop", "iterateVariable", "collection", "Lcom/intellij/debugger/streams/trace/dsl/ForLoopBody;", "forLoop", "initialization", "condition", "afterThought", "getStatements", "", "Lcom/intellij/debugger/streams/trace/dsl/Convertable;", "ifBranch", "Lcom/intellij/debugger/streams/trace/dsl/IfBranch;", "argName", "Lkotlin/Function2;", "Lcom/intellij/debugger/streams/trace/dsl/LambdaBody;", "linkedMap", "Lcom/intellij/debugger/streams/trace/dsl/MapVariable;", "keyType", "valueType", "list", "Lcom/intellij/debugger/streams/trace/dsl/ListVariable;", "map", "newArray", "(Lcom/intellij/debugger/streams/trace/impl/handler/type/GenericType;[Lcom/intellij/debugger/streams/trace/dsl/Expression;)Lcom/intellij/debugger/streams/trace/dsl/Expression;", "newList", "newSizedArray", "scope", "statement", "Lkotlin/Function0;", "Lcom/intellij/debugger/streams/trace/dsl/Statement;", "timeDeclaration", "toCode", "indent", "tryBlock", "Lcom/intellij/debugger/streams/trace/dsl/TryBlock;", "updateTime", "type", "and", "right", "assign", "equals", "not", "same", "unaryPlus", "withIndent", "intellij.java.debugger.streams"})
    private final class MyContext
    implements CodeContext,
    Dsl,
    CodeBlock {
        private final /* synthetic */ DslImpl $$delegate_0;
        private final /* synthetic */ CompositeCodeBlock $$delegate_1;

        public MyContext() {
            this.$$delegate_0 = DslImpl.this;
            this.$$delegate_1 = DslImpl.this.statementFactory.createEmptyCompositeCodeBlock();
        }

        @Override
        @NotNull
        public Expression getNullExpression() {
            return this.$$delegate_0.getNullExpression();
        }

        @Override
        @NotNull
        public Expression getThisExpression() {
            return this.$$delegate_0.getThisExpression();
        }

        @Override
        @NotNull
        public Types getTypes() {
            return this.$$delegate_0.getTypes();
        }

        @Override
        @NotNull
        public Expression getExpr(@NotNull String $this$expr) {
            Intrinsics.checkParameterIsNotNull((Object)$this$expr, (String)"$this$expr");
            return this.$$delegate_0.getExpr($this$expr);
        }

        @Override
        @NotNull
        public ArrayVariable array(@NotNull GenericType elementType, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return this.$$delegate_0.array(elementType, name);
        }

        @Override
        @NotNull
        public CodeBlock block(@NotNull Function1<? super CodeContext, Unit> init) {
            Intrinsics.checkParameterIsNotNull(init, (String)"init");
            return this.$$delegate_0.block(init);
        }

        @Override
        @NotNull
        public String code(@NotNull Function1<? super CodeContext, Unit> init) {
            Intrinsics.checkParameterIsNotNull(init, (String)"init");
            return this.$$delegate_0.code(init);
        }

        @Override
        @NotNull
        public IntermediateStreamCall createPeekCall(@NotNull GenericType elementType, @NotNull Lambda lambda2) {
            Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
            Intrinsics.checkParameterIsNotNull((Object)lambda2, (String)"lambda");
            return this.$$delegate_0.createPeekCall(elementType, lambda2);
        }

        @Override
        @Deprecated(message="use createPeekCall(GenericType, Lambda): IntermediateStreamCall instead")
        @NotNull
        public IntermediateStreamCall createPeekCall(@NotNull GenericType elementsType, @NotNull String lambda2) {
            Intrinsics.checkParameterIsNotNull((Object)elementsType, (String)"elementsType");
            Intrinsics.checkParameterIsNotNull((Object)lambda2, (String)"lambda");
            return this.$$delegate_0.createPeekCall(elementsType, lambda2);
        }

        @Override
        @NotNull
        public Expression currentTime() {
            return this.$$delegate_0.currentTime();
        }

        @Override
        @NotNull
        public VariableDeclaration declaration(@NotNull Variable variable, @NotNull Expression init, boolean isMutable) {
            Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
            Intrinsics.checkParameterIsNotNull((Object)init, (String)"init");
            return this.$$delegate_0.declaration(variable, init, isMutable);
        }

        @Override
        @NotNull
        public Lambda lambda(@NotNull String argName, @NotNull Function2<? super LambdaBody, ? super Expression, Unit> init) {
            Intrinsics.checkParameterIsNotNull((Object)argName, (String)"argName");
            Intrinsics.checkParameterIsNotNull(init, (String)"init");
            return this.$$delegate_0.lambda(argName, init);
        }

        @Override
        @NotNull
        public MapVariable linkedMap(@NotNull GenericType keyType, @NotNull GenericType valueType, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)keyType, (String)"keyType");
            Intrinsics.checkParameterIsNotNull((Object)valueType, (String)"valueType");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return this.$$delegate_0.linkedMap(keyType, valueType, name);
        }

        @Override
        @NotNull
        public ListVariable list(@NotNull GenericType elementType, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return this.$$delegate_0.list(elementType, name);
        }

        @Override
        @NotNull
        public MapVariable map(@NotNull GenericType keyType, @NotNull GenericType valueType, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)keyType, (String)"keyType");
            Intrinsics.checkParameterIsNotNull((Object)valueType, (String)"valueType");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return this.$$delegate_0.map(keyType, valueType, name);
        }

        @Override
        @NotNull
        public Expression newArray(@NotNull GenericType elementType, Expression ... args) {
            Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            return this.$$delegate_0.newArray(elementType, args);
        }

        @Override
        @NotNull
        public Expression newList(@NotNull GenericType elementType, Expression ... args) {
            Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            return this.$$delegate_0.newList(elementType, args);
        }

        @Override
        @NotNull
        public Expression newSizedArray(@NotNull GenericType elementType, @NotNull Expression size) {
            Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
            Intrinsics.checkParameterIsNotNull((Object)size, (String)"size");
            return this.$$delegate_0.newSizedArray(elementType, size);
        }

        @Override
        @NotNull
        public Expression newSizedArray(@NotNull GenericType elementType, int size) {
            Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
            return this.$$delegate_0.newSizedArray(elementType, size);
        }

        @Override
        @NotNull
        public VariableDeclaration timeDeclaration() {
            return this.$$delegate_0.timeDeclaration();
        }

        @Override
        @NotNull
        public Expression updateTime() {
            return this.$$delegate_0.updateTime();
        }

        @Override
        @NotNull
        public Variable variable(@NotNull GenericType type, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return this.$$delegate_0.variable(type, name);
        }

        @Override
        @NotNull
        public Expression and(@NotNull Expression $this$and, @NotNull Expression right) {
            Intrinsics.checkParameterIsNotNull((Object)$this$and, (String)"$this$and");
            Intrinsics.checkParameterIsNotNull((Object)right, (String)"right");
            return this.$$delegate_0.and($this$and, right);
        }

        @Override
        @NotNull
        public Expression equals(@NotNull Expression $this$equals, @NotNull Expression right) {
            Intrinsics.checkParameterIsNotNull((Object)$this$equals, (String)"$this$equals");
            Intrinsics.checkParameterIsNotNull((Object)right, (String)"right");
            return this.$$delegate_0.equals($this$equals, right);
        }

        @Override
        @NotNull
        public Expression not(@NotNull Expression $this$not) {
            Intrinsics.checkParameterIsNotNull((Object)$this$not, (String)"$this$not");
            return this.$$delegate_0.not($this$not);
        }

        @Override
        @NotNull
        public Expression same(@NotNull Expression $this$same, @NotNull Expression right) {
            Intrinsics.checkParameterIsNotNull((Object)$this$same, (String)"$this$same");
            Intrinsics.checkParameterIsNotNull((Object)right, (String)"right");
            return this.$$delegate_0.same($this$same, right);
        }

        @Override
        public int getSize() {
            return this.$$delegate_1.getSize();
        }

        @Override
        public void add(@NotNull CodeBlock block2) {
            Intrinsics.checkParameterIsNotNull((Object)block2, (String)"block");
            this.$$delegate_1.add(block2);
        }

        @Override
        @NotNull
        public Expression call(@NotNull Expression receiver, @NotNull String methodName, Expression ... args) {
            Intrinsics.checkParameterIsNotNull((Object)receiver, (String)"receiver");
            Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            return this.$$delegate_1.call(receiver, methodName, args);
        }

        @Override
        @NotNull
        public Variable declare(@NotNull Variable variable, @NotNull Expression init, boolean isMutable) {
            Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
            Intrinsics.checkParameterIsNotNull((Object)init, (String)"init");
            return this.$$delegate_1.declare(variable, init, isMutable);
        }

        @Override
        @NotNull
        public Variable declare(@NotNull Variable variable, boolean isMutable) {
            Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
            return this.$$delegate_1.declare(variable, isMutable);
        }

        @Override
        @NotNull
        public Variable declare(@NotNull VariableDeclaration declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            return this.$$delegate_1.declare(declaration);
        }

        @Override
        public void doReturn(@NotNull Expression expression) {
            Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
            this.$$delegate_1.doReturn(expression);
        }

        @Override
        public void forEachLoop(@NotNull Variable iterateVariable, @NotNull Expression collection, @NotNull Function1<? super ForLoopBody, Unit> init) {
            Intrinsics.checkParameterIsNotNull((Object)iterateVariable, (String)"iterateVariable");
            Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
            Intrinsics.checkParameterIsNotNull(init, (String)"init");
            this.$$delegate_1.forEachLoop(iterateVariable, collection, init);
        }

        @Override
        public void forLoop(@NotNull VariableDeclaration initialization, @NotNull Expression condition, @NotNull Expression afterThought, @NotNull Function1<? super ForLoopBody, Unit> init) {
            Intrinsics.checkParameterIsNotNull((Object)initialization, (String)"initialization");
            Intrinsics.checkParameterIsNotNull((Object)condition, (String)"condition");
            Intrinsics.checkParameterIsNotNull((Object)afterThought, (String)"afterThought");
            Intrinsics.checkParameterIsNotNull(init, (String)"init");
            this.$$delegate_1.forLoop(initialization, condition, afterThought, init);
        }

        @Override
        @NotNull
        public List<Convertable> getStatements() {
            return this.$$delegate_1.getStatements();
        }

        @Override
        @NotNull
        public IfBranch ifBranch(@NotNull Expression condition, @NotNull Function1<? super CodeBlock, Unit> init) {
            Intrinsics.checkParameterIsNotNull((Object)condition, (String)"condition");
            Intrinsics.checkParameterIsNotNull(init, (String)"init");
            return this.$$delegate_1.ifBranch(condition, init);
        }

        @Override
        public void scope(@NotNull Function1<? super CodeBlock, Unit> init) {
            Intrinsics.checkParameterIsNotNull(init, (String)"init");
            this.$$delegate_1.scope(init);
        }

        @Override
        public void statement(@NotNull Function0<? extends Statement> statement) {
            Intrinsics.checkParameterIsNotNull(statement, (String)"statement");
            this.$$delegate_1.statement(statement);
        }

        @Override
        @NotNull
        public String toCode(int indent) {
            return this.$$delegate_1.toCode(indent);
        }

        @Override
        @NotNull
        public TryBlock tryBlock(@NotNull Function1<? super CodeBlock, Unit> init) {
            Intrinsics.checkParameterIsNotNull(init, (String)"init");
            return this.$$delegate_1.tryBlock(init);
        }

        @Override
        public void assign(@NotNull Variable $this$assign, @NotNull Expression expression) {
            Intrinsics.checkParameterIsNotNull((Object)$this$assign, (String)"$this$assign");
            Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
            this.$$delegate_1.assign($this$assign, expression);
        }

        @Override
        public void unaryPlus(@NotNull Statement $this$unaryPlus) {
            Intrinsics.checkParameterIsNotNull((Object)$this$unaryPlus, (String)"$this$unaryPlus");
            this.$$delegate_1.unaryPlus($this$unaryPlus);
        }

        @Override
        @NotNull
        public String withIndent(@NotNull String $this$withIndent, int indent) {
            Intrinsics.checkParameterIsNotNull((Object)$this$withIndent, (String)"$this$withIndent");
            return this.$$delegate_1.withIndent($this$withIndent, indent);
        }
    }
}

