/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.sessions;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CpuCaptureSessionArtifact;
import com.android.tools.profilers.memory.HprofSessionArtifact;
import com.android.tools.profilers.memory.LegacyAllocationsSessionArtifact;
import com.android.tools.profilers.sessions.SessionArtifact;
import com.android.tools.profilers.sessions.SessionAspect;
import com.android.tools.profilers.sessions.SessionItem;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SessionsManager
extends AspectModel<SessionAspect> {
    private static final SessionArtifactComparator ARTIFACT_COMPARATOR = new SessionArtifactComparator();
    @NotNull
    private final StudioProfilers myProfilers;
    @NotNull
    private Map<Long, SessionItem> mySessionItems;
    @NotNull
    private Map<Long, Common.SessionMetaData> mySessionMetaDatas;
    @NotNull
    private List<SessionArtifact> mySessionArtifacts;
    @NotNull
    private Common.Session mySelectedSession;
    @NotNull
    private Common.Session myProfilingSession;
    private final Map<Long, Range> mySessionViewRangeMap;
    private final Map<String, Consumer<File>> myImportHandlers;
    private int importedSessionCount;
    @NotNull
    private final List<ArtifactFetcher> myArtifactsFetchers;

    public SessionsManager(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            SessionsManager.$$$reportNull$$$0(0);
        }
        this.myImportHandlers = new HashMap<String, Consumer<File>>();
        this.importedSessionCount = 0;
        this.myProfilers = profilers;
        this.mySelectedSession = this.myProfilingSession = Common.Session.getDefaultInstance();
        this.mySessionItems = new HashMap<Long, SessionItem>();
        this.mySessionMetaDatas = new HashMap<Long, Common.SessionMetaData>();
        this.mySessionMetaDatas.put(Common.Session.getDefaultInstance().getSessionId(), Common.SessionMetaData.getDefaultInstance());
        this.mySessionArtifacts = new ArrayList<SessionArtifact>();
        this.mySessionViewRangeMap = new HashMap<Long, Range>();
        this.myArtifactsFetchers = new ArrayList<ArtifactFetcher>();
        this.myArtifactsFetchers.add(HprofSessionArtifact::getSessionArtifacts);
        this.myArtifactsFetchers.add(LegacyAllocationsSessionArtifact::getSessionArtifacts);
        this.myArtifactsFetchers.add(CpuCaptureSessionArtifact::getSessionArtifacts);
    }

    @NotNull
    public Common.Session getSelectedSession() {
        Common.Session session = this.mySelectedSession;
        if (session == null) {
            SessionsManager.$$$reportNull$$$0(1);
        }
        return session;
    }

    @NotNull
    public Common.Session getProfilingSession() {
        Common.Session session = this.myProfilingSession;
        if (session == null) {
            SessionsManager.$$$reportNull$$$0(2);
        }
        return session;
    }

    @NotNull
    public Common.SessionMetaData getSelectedSessionMetaData() {
        Common.SessionMetaData sessionMetaData = this.mySessionMetaDatas.get(this.mySelectedSession.getSessionId());
        if (sessionMetaData == null) {
            SessionsManager.$$$reportNull$$$0(3);
        }
        return sessionMetaData;
    }

    @NotNull
    public List<SessionArtifact> getSessionArtifacts() {
        List<SessionArtifact> list = this.mySessionArtifacts;
        if (list == null) {
            SessionsManager.$$$reportNull$$$0(4);
        }
        return list;
    }

    public boolean isSessionAlive() {
        return SessionsManager.isSessionAlive(this.mySelectedSession);
    }

    public static boolean isSessionAlive(@NotNull Common.Session session) {
        if (session == null) {
            SessionsManager.$$$reportNull$$$0(5);
        }
        return session.getEndTimestamp() == Long.MAX_VALUE;
    }

    @NotNull
    public Range getSessionPreferredViewRange(@NotNull Common.Session session) {
        if (session == null) {
            SessionsManager.$$$reportNull$$$0(6);
        }
        double viewRangeMin = TimeUnit.NANOSECONDS.toMicros(session.getStartTimestamp());
        double viewRangeMax = TimeUnit.NANOSECONDS.toMicros(session.getEndTimestamp());
        if (this.mySessionViewRangeMap.containsKey(session.getSessionId())) {
            Range cachedRange = this.mySessionViewRangeMap.get(session.getSessionId());
            viewRangeMin = Math.max(viewRangeMin, cachedRange.getMin());
            viewRangeMax = Math.min(viewRangeMax, cachedRange.getMax());
        }
        Range range = new Range(viewRangeMin, viewRangeMax);
        if (range == null) {
            SessionsManager.$$$reportNull$$$0(7);
        }
        return range;
    }

    public void update() {
        Profiler.GetSessionsResponse sessionsResponse = this.myProfilers.getClient().getProfilerClient().getSessions(Profiler.GetSessionsRequest.getDefaultInstance());
        this.updateSessionItems(sessionsResponse.getSessionsList());
    }

    public void setSession(@NotNull Common.Session session) {
        if (session == null) {
            SessionsManager.$$$reportNull$$$0(8);
        }
        this.myProfilers.setAutoProfilingEnabled(false);
        this.setSessionInternal(session);
    }

    private void setSessionInternal(@NotNull Common.Session session) {
        if (session == null) {
            SessionsManager.$$$reportNull$$$0(9);
        }
        if (session.equals((Object)this.mySelectedSession)) {
            return;
        }
        assert (Common.Session.getDefaultInstance().equals((Object)session) || this.mySessionItems.containsKey(session.getSessionId()) && this.mySessionItems.get(session.getSessionId()).getSession().equals((Object)session));
        if (!Common.Session.getDefaultInstance().equals((Object)this.mySelectedSession)) {
            this.mySessionViewRangeMap.put(this.mySelectedSession.getSessionId(), new Range(this.myProfilers.getTimeline().getViewRange()));
        }
        this.mySelectedSession = session;
        this.changed(SessionAspect.SELECTED_SESSION);
    }

    private void setProfilingSession(@NotNull Common.Session session) {
        if (session == null) {
            SessionsManager.$$$reportNull$$$0(10);
        }
        if (session.equals((Object)this.myProfilingSession)) {
            return;
        }
        this.myProfilingSession = session;
        this.changed(SessionAspect.PROFILING_SESSION);
    }

    public void beginSession(@NotNull Common.Device device, @Nullable Common.Process process) {
        if (device == null) {
            SessionsManager.$$$reportNull$$$0(11);
        }
        assert (Common.Session.getDefaultInstance().equals((Object)this.myProfilingSession));
        if (process == null) {
            this.setProfilingSession(Common.Session.getDefaultInstance());
            this.setSessionInternal(this.myProfilingSession);
            return;
        }
        if (device.getState() != Common.Device.State.ONLINE || process.getState() != Common.Process.State.ALIVE) {
            return;
        }
        Profiler.BeginSessionRequest.Builder requestBuilder = Profiler.BeginSessionRequest.newBuilder().setDeviceId(device.getDeviceId()).setPid(process.getPid()).setSessionName(StudioProfilers.buildSessionName(device, process)).setRequestTimeEpochMs(System.currentTimeMillis());
        if (device.getFeatureLevel() >= 26) {
            requestBuilder.setJvmtiConfig(Profiler.BeginSessionRequest.JvmtiConfig.newBuilder().setAttachAgent(true).setAgentLibFileName(String.format("libperfa_%s.so", process.getAbiCpuArch())).setLiveAllocationEnabled(this.myProfilers.getIdeServices().getFeatureConfig().isLiveAllocationsEnabled()).build());
        }
        Profiler.BeginSessionResponse response = this.myProfilers.getClient().getProfilerClient().beginSession(requestBuilder.build());
        Common.Session session = response.getSession();
        this.setProfilingSession(session);
        this.updateSessionItems(Collections.singletonList(session));
        this.setSessionInternal(session);
    }

    public void endCurrentSession() {
        if (Common.Session.getDefaultInstance().equals((Object)this.myProfilingSession)) {
            return;
        }
        Profiler.EndSessionResponse response = this.myProfilers.getClient().getProfilerClient().endSession(Profiler.EndSessionRequest.newBuilder().setDeviceId(this.myProfilingSession.getDeviceId()).setSessionId(this.myProfilingSession.getSessionId()).build());
        boolean selectedSessionIsProfilingSession = this.myProfilingSession.equals((Object)this.mySelectedSession);
        this.setProfilingSession(Common.Session.getDefaultInstance());
        Common.Session session = response.getSession();
        this.updateSessionItems(Collections.singletonList(session));
        if (selectedSessionIsProfilingSession) {
            this.setSessionInternal(session);
        }
    }

    public void deleteSession(@NotNull Common.Session session) {
        if (session == null) {
            SessionsManager.$$$reportNull$$$0(12);
        }
        assert (this.mySessionItems.containsKey(session.getSessionId()) && this.mySessionItems.get(session.getSessionId()).getSession().equals((Object)session));
        boolean sessionIsSelectedSession = this.mySelectedSession.equals((Object)session);
        if (this.myProfilingSession.equals((Object)session)) {
            this.myProfilers.setDevice(null);
        }
        if (sessionIsSelectedSession) {
            this.setSessionInternal(Common.Session.getDefaultInstance());
        }
        Profiler.DeleteSessionRequest request = Profiler.DeleteSessionRequest.newBuilder().setSessionId(session.getSessionId()).build();
        this.myProfilers.getClient().getProfilerClient().deleteSession(request);
        this.mySessionItems.remove(session.getSessionId());
        this.updateSessionItems(Collections.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Common.Session createImportedSession(@NotNull String sessionName, @NotNull Common.SessionMetaData.SessionType sessionType, long startTimestampNs, long endTimestampNs, long l) {
        void startTimestampEpochMs;
        if (sessionName == null) {
            SessionsManager.$$$reportNull$$$0(13);
        }
        if (sessionType == null) {
            SessionsManager.$$$reportNull$$$0(14);
        }
        Common.Session session = Common.Session.newBuilder().setSessionId((long)this.generateUniqueSessionId()).setStartTimestamp(startTimestampNs).setEndTimestamp(endTimestampNs).build();
        Profiler.ImportSessionRequest sessionRequest = Profiler.ImportSessionRequest.newBuilder().setSession(session).setSessionName(sessionName).setSessionType(sessionType).setStartTimestampEpochMs((long)startTimestampEpochMs).build();
        this.myProfilers.getClient().getProfilerClient().importSession(sessionRequest);
        Common.Session session2 = session;
        if (session2 == null) {
            SessionsManager.$$$reportNull$$$0(15);
        }
        return session2;
    }

    public void registerImportHandler(@NotNull String extension, @NotNull Consumer<File> handler) {
        if (extension == null) {
            SessionsManager.$$$reportNull$$$0(16);
        }
        if (handler == null) {
            SessionsManager.$$$reportNull$$$0(17);
        }
        this.myImportHandlers.put(extension, handler);
    }

    public boolean importSessionFromFile(@NotNull File file) {
        int indexOfDot;
        if (file == null) {
            SessionsManager.$$$reportNull$$$0(18);
        }
        if ((indexOfDot = file.getName().indexOf(46)) == -1) {
            return false;
        }
        String extension = StringUtil.toLowerCase((String)file.getName().substring(indexOfDot + 1));
        if (this.myImportHandlers.get(extension) == null) {
            return false;
        }
        this.myImportHandlers.get(extension).accept(file);
        return true;
    }

    private int generateUniqueSessionId() {
        return ++this.importedSessionCount;
    }

    private void updateSessionItems(@NotNull List<Common.Session> sessions) {
        if (sessions == null) {
            SessionsManager.$$$reportNull$$$0(19);
        }
        List previousProtos = this.mySessionArtifacts.stream().map(artifact -> artifact.getArtifactProto()).collect(Collectors.toList());
        sessions.forEach(session -> {
            SessionItem sessionItem = this.mySessionItems.get(session.getSessionId());
            if (sessionItem == null) {
                Profiler.GetSessionMetaDataResponse response = this.myProfilers.getClient().getProfilerClient().getSessionMetaData(Profiler.GetSessionMetaDataRequest.newBuilder().setSessionId(session.getSessionId()).build());
                Common.SessionMetaData metadata = response.getData();
                sessionItem = new SessionItem(this.myProfilers, (Common.Session)session, metadata);
                this.mySessionItems.put(session.getSessionId(), sessionItem);
                this.mySessionMetaDatas.put(session.getSessionId(), metadata);
            } else {
                sessionItem.setSession((Common.Session)session);
            }
        });
        ArrayList<SessionArtifact> sessionArtifacts = new ArrayList<SessionArtifact>();
        for (SessionItem item : this.mySessionItems.values()) {
            sessionArtifacts.add(item);
            ArrayList<SessionArtifact> artifacts = new ArrayList<SessionArtifact>();
            this.myArtifactsFetchers.forEach(fetcher -> artifacts.addAll(fetcher.fetch(this.myProfilers, item.getSession(), item.getSessionMetaData())));
            item.setChildArtifacts(artifacts);
            if (item.getSessionMetaData().getType() != Common.SessionMetaData.SessionType.FULL) continue;
            sessionArtifacts.addAll(artifacts);
        }
        Collections.sort(sessionArtifacts, ARTIFACT_COMPARATOR);
        List newProtos = sessionArtifacts.stream().map(artifact -> artifact.getArtifactProto()).collect(Collectors.toList());
        if (!previousProtos.equals(newProtos)) {
            this.mySessionArtifacts.forEach(artifact -> this.myProfilers.getUpdater().unregister((Updatable)artifact));
            this.mySessionArtifacts = sessionArtifacts;
            this.changed(SessionAspect.SESSIONS);
            this.mySessionArtifacts.forEach(artifact -> this.myProfilers.getUpdater().register((Updatable)artifact));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/sessions/SessionsManager";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/sessions/SessionsManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedSession";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilingSession";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedSessionMetaData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionArtifacts";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionPreferredViewRange";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportedSession";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSessionAlive";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSessionPreferredViewRange";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setSession";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setSessionInternal";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setProfilingSession";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "beginSession";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deleteSession";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createImportedSession";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "registerImportHandler";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "importSessionFromFile";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "updateSessionItems";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SessionArtifactComparator
    implements Comparator<SessionArtifact> {
        private SessionArtifactComparator() {
        }

        @Override
        public int compare(SessionArtifact artifact1, SessionArtifact artifact2) {
            int result = Long.compare(artifact2.getSessionMetaData().getStartTimestampEpochMs(), artifact1.getSessionMetaData().getStartTimestampEpochMs());
            if (result != 0) {
                return result;
            }
            if (artifact1 instanceof SessionItem) {
                return -1;
            }
            if (artifact2 instanceof SessionItem) {
                return 1;
            }
            return Long.compare(artifact2.getTimestampNs(), artifact1.getTimestampNs());
        }
    }

    private static interface ArtifactFetcher {
        public List<SessionArtifact> fetch(@NotNull StudioProfilers var1, @NotNull Common.Session var2, @NotNull Common.SessionMetaData var3);
    }

    public static enum SessionCreationSource {
        MANUAL;

    }
}

