/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network.httpdata;

import com.android.tools.profiler.protobuf3jarjar.ByteString;
import com.android.tools.profilers.network.NetworkConnectionsModel;
import com.android.tools.profilers.network.httpdata.HttpData;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Payload {
    @NotNull
    private final NetworkConnectionsModel myModel;
    @Nullable
    private ByteString myCachedBytes;

    private Payload(@NotNull NetworkConnectionsModel model) {
        if (model == null) {
            Payload.$$$reportNull$$$0(0);
        }
        this.myModel = model;
    }

    @NotNull
    public static Payload newRequestPayload(@NotNull NetworkConnectionsModel model, final @NotNull HttpData httpData) {
        if (model == null) {
            Payload.$$$reportNull$$$0(1);
        }
        if (httpData == null) {
            Payload.$$$reportNull$$$0(2);
        }
        Payload payload = new Payload(model){

            @Override
            protected String getId() {
                return httpData.getRequestPayloadId();
            }

            @Override
            @NotNull
            protected HttpData.Header getHeader() {
                HttpData.RequestHeader requestHeader = httpData.getRequestHeader();
                if (requestHeader == null) {
                    1.$$$reportNull$$$0(0);
                }
                return requestHeader;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/profilers/network/httpdata/Payload$1", "getHeader"));
            }
        };
        if (payload == null) {
            Payload.$$$reportNull$$$0(3);
        }
        return payload;
    }

    @NotNull
    public static Payload newResponsePayload(@NotNull NetworkConnectionsModel model, final @NotNull HttpData httpData) {
        if (model == null) {
            Payload.$$$reportNull$$$0(4);
        }
        if (httpData == null) {
            Payload.$$$reportNull$$$0(5);
        }
        Payload payload = new Payload(model){

            @Override
            protected String getId() {
                return httpData.getResponsePayloadId();
            }

            @Override
            @NotNull
            protected HttpData.Header getHeader() {
                HttpData.ResponseHeader responseHeader = httpData.getResponseHeader();
                if (responseHeader == null) {
                    2.$$$reportNull$$$0(0);
                }
                return responseHeader;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/profilers/network/httpdata/Payload$2", "getHeader"));
            }
        };
        if (payload == null) {
            Payload.$$$reportNull$$$0(6);
        }
        return payload;
    }

    protected abstract String getId();

    @NotNull
    protected abstract HttpData.Header getHeader();

    @NotNull
    public final ByteString getBytes() {
        if (this.myCachedBytes != null) {
            ByteString byteString = this.myCachedBytes;
            if (byteString == null) {
                Payload.$$$reportNull$$$0(7);
            }
            return byteString;
        }
        this.myCachedBytes = this.myModel.requestBytes(this.getId());
        String contentEncoding = this.getHeader().getContentEncoding();
        if (StringUtil.toLowerCase((String)contentEncoding).contains("gzip")) {
            try (GZIPInputStream inputStream = new GZIPInputStream(new ByteArrayInputStream(this.myCachedBytes.toByteArray()));){
                this.myCachedBytes = ByteString.copyFrom((byte[])FileUtil.loadBytes((InputStream)inputStream));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ByteString byteString = this.myCachedBytes;
        if (byteString == null) {
            Payload.$$$reportNull$$$0(8);
        }
        return byteString;
    }

    @NotNull
    public HttpData.ContentType getContentType() {
        HttpData.ContentType contentType = this.getHeader().getContentType();
        if (contentType == null) {
            Payload.$$$reportNull$$$0(9);
        }
        return contentType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "httpData";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/network/httpdata/Payload";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/network/httpdata/Payload";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "newRequestPayload";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "newResponsePayload";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBytes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "newRequestPayload";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "newResponsePayload";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

