/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network.details;

import com.android.tools.adtui.TreeWalker;
import com.android.tools.adtui.ui.BreakWordWrapHtmlTextPane;
import com.android.tools.adtui.ui.HideablePanel;
import com.android.tools.profilers.ProfilerFonts;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TabUiUtils {
    public static final int SCROLL_UNIT = JBUIScale.scale((int)10);
    public static final int HORIZONTAL_PADDING = 15;
    public static final int TAB_SECTION_VGAP = JBUIScale.scale((int)5);
    public static final int PAGE_VGAP = JBUIScale.scale((int)28);
    public static final int SECTION_VGAP = JBUIScale.scale((int)10);
    public static final String SECTION_TITLE_HEADERS = "Headers";

    private TabUiUtils() {
    }

    @NotNull
    public static JPanel createVerticalPanel(int verticalGap) {
        JPanel jPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, verticalGap));
        if (jPanel == null) {
            TabUiUtils.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    @NotNull
    public static JBScrollPane createScrollPane(@NotNull JComponent component) {
        if (component == null) {
            TabUiUtils.$$$reportNull$$$0(1);
        }
        JBScrollPane scrollPane = new JBScrollPane((Component)component);
        scrollPane.getVerticalScrollBar().setUnitIncrement(SCROLL_UNIT);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(SCROLL_UNIT);
        JBScrollPane jBScrollPane = scrollPane;
        if (jBScrollPane == null) {
            TabUiUtils.$$$reportNull$$$0(2);
        }
        return jBScrollPane;
    }

    @NotNull
    public static JBScrollPane createVerticalScrollPane(@NotNull JComponent component) {
        if (component == null) {
            TabUiUtils.$$$reportNull$$$0(3);
        }
        JBScrollPane scrollPane = TabUiUtils.createScrollPane(component);
        scrollPane.setHorizontalScrollBarPolicy(31);
        JBScrollPane jBScrollPane = scrollPane;
        if (jBScrollPane == null) {
            TabUiUtils.$$$reportNull$$$0(4);
        }
        return jBScrollPane;
    }

    @NotNull
    public static HideablePanel createHideablePanel(@NotNull String title, @NotNull JComponent content, @Nullable JComponent northEastComponent) {
        if (title == null) {
            TabUiUtils.$$$reportNull$$$0(5);
        }
        if (content == null) {
            TabUiUtils.$$$reportNull$$$0(6);
        }
        title = String.format("<html><b>%s</b></html>", title);
        HideablePanel hideablePanel = new HideablePanel.Builder(title, content).setNorthEastComponent(northEastComponent).setPanelBorder((Border)new JBEmptyBorder(10, 0, 0, 0)).setContentBorder((Border)new JBEmptyBorder(10, 12, 0, 0)).build();
        if (hideablePanel == null) {
            TabUiUtils.$$$reportNull$$$0(7);
        }
        return hideablePanel;
    }

    @NotNull
    public static JComponent createStyledMapComponent(@NotNull Map<String, String> map) {
        if (map == null) {
            TabUiUtils.$$$reportNull$$$0(8);
        }
        if (map.isEmpty()) {
            JLabel jLabel = new JLabel("Not available");
            if (jLabel == null) {
                TabUiUtils.$$$reportNull$$$0(9);
            }
            return jLabel;
        }
        BreakWordWrapHtmlTextPane textPane = new BreakWordWrapHtmlTextPane();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuilder.append(String.format("<p><b>%s</b>:&nbsp;<span>%s</span></p>", entry.getKey(), entry.getValue()));
        }
        stringBuilder.append("</html>");
        textPane.setText(stringBuilder.toString());
        BreakWordWrapHtmlTextPane breakWordWrapHtmlTextPane = textPane;
        if (breakWordWrapHtmlTextPane == null) {
            TabUiUtils.$$$reportNull$$$0(10);
        }
        return breakWordWrapHtmlTextPane;
    }

    public static void adjustFont(@NotNull Component c) {
        if (c == null) {
            TabUiUtils.$$$reportNull$$$0(11);
        }
        if (c.getFont() == null) {
            return;
        }
        c.setFont(c.getFont().deriveFont(0, ProfilerFonts.STANDARD_FONT.getSize2D()));
    }

    @Nullable
    public static JComponent findComponentWithUniqueName(@NotNull JComponent root, @NotNull String name) {
        List matches;
        if (root == null) {
            TabUiUtils.$$$reportNull$$$0(12);
        }
        if (name == null) {
            TabUiUtils.$$$reportNull$$$0(13);
        }
        if ((matches = new TreeWalker((Component)root).descendantStream().filter(c -> name.equals(c.getName())).collect(Collectors.toList())).size() > 1) {
            throw new IllegalStateException("More than one component found with the name: " + name);
        }
        return matches.size() == 1 ? (JComponent)matches.get(0) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/network/details/TabUiUtils";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createVerticalPanel";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/network/details/TabUiUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createScrollPane";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createVerticalScrollPane";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createHideablePanel";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createStyledMapComponent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createScrollPane";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createVerticalScrollPane";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createHideablePanel";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createStyledMapComponent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "adjustFont";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findComponentWithUniqueName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

