/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profiler.protobuf3jarjar.ByteString;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.StudioProfiler;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.memory.AllocationSamplingRateDataSeries;
import com.android.tools.profilers.memory.AllocationSamplingRateDurationData;
import com.android.tools.profilers.memory.LegacyAllocationConverter;
import com.android.tools.profilers.memory.MemoryMonitor;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.sessions.SessionsManager;
import com.intellij.openapi.diagnostic.Logger;
import io.grpc.StatusRuntimeException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class MemoryProfiler
extends StudioProfiler {
    @NotNull
    private final AspectObserver myAspectObserver;

    private static Logger getLogger() {
        return Logger.getInstance(MemoryProfiler.class);
    }

    public MemoryProfiler(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            MemoryProfiler.$$$reportNull$$$0(0);
        }
        super(profilers);
        this.myAspectObserver = new AspectObserver();
        this.myProfilers.addDependency(this.myAspectObserver).onChange((Enum)ProfilerAspect.AGENT, this::agentStatusChanged);
        SessionsManager sessionsManager = this.myProfilers.getSessionsManager();
        sessionsManager.registerImportHandler("hprof", this::importHprof);
        sessionsManager.registerImportHandler("alloc", this::importLegacyAllocations);
        this.myProfilers.registerSessionChangeListener(Common.SessionMetaData.SessionType.MEMORY_CAPTURE, () -> {
            MemoryProfilerStage stage = new MemoryProfilerStage(this.myProfilers);
            this.myProfilers.setStage(stage);
            stage.setPendingCaptureStartTime(this.myProfilers.getSession().getStartTimestamp());
            ProfilerTimeline timeline = this.myProfilers.getTimeline();
            timeline.reset(this.myProfilers.getSession().getStartTimestamp(), this.myProfilers.getSession().getEndTimestamp());
            timeline.getViewRange().set(timeline.getDataRange());
            timeline.setIsPaused(true);
        });
    }

    @Override
    public ProfilerMonitor newMonitor() {
        return new MemoryMonitor(this.myProfilers);
    }

    @Override
    public void startProfiling(Common.Session session) {
        this.myProfilers.getClient().getMemoryClient().startMonitoringApp(MemoryProfiler.MemoryStartRequest.newBuilder().setSession(session).build());
    }

    @Override
    public void stopProfiling(Common.Session session) {
        try {
            Profiler.GetSessionMetaDataResponse response = this.myProfilers.getClient().getProfilerClient().getSessionMetaData(Profiler.GetSessionMetaDataRequest.newBuilder().setSessionId(session.getSessionId()).build());
            if (response.getData().getLiveAllocationEnabled() && MemoryProfiler.isUsingLiveAllocation(this.myProfilers, session)) {
                this.myProfilers.getClient().getMemoryClient().trackAllocations(MemoryProfiler.TrackAllocationsRequest.newBuilder().setSession(session).setEnabled(false).build());
            }
        }
        catch (StatusRuntimeException e) {
            MemoryProfiler.getLogger().info((Throwable)e);
        }
        this.myProfilers.getClient().getMemoryClient().stopMonitoringApp(MemoryProfiler.MemoryStopRequest.newBuilder().setSession(session).build());
    }

    private void agentStatusChanged() {
        Common.Session session = this.myProfilers.getSession();
        if (Common.Session.getDefaultInstance().equals((Object)session) || session.getEndTimestamp() != Long.MAX_VALUE) {
            return;
        }
        Profiler.GetSessionMetaDataResponse response = this.myProfilers.getClient().getProfilerClient().getSessionMetaData(Profiler.GetSessionMetaDataRequest.newBuilder().setSessionId(session.getSessionId()).build());
        if (!response.getData().getLiveAllocationEnabled()) {
            return;
        }
        if (MemoryProfiler.isUsingLiveAllocation(this.myProfilers, session)) {
            return;
        }
        if (!this.myProfilers.isAgentAttached()) {
            return;
        }
        Profiler.TimeResponse timeResponse = this.myProfilers.getClient().getProfilerClient().getCurrentTime(Profiler.TimeRequest.newBuilder().setDeviceId(session.getDeviceId()).build());
        long timeNs = timeResponse.getTimestampNs();
        try {
            this.myProfilers.getClient().getMemoryClient().trackAllocations(MemoryProfiler.TrackAllocationsRequest.newBuilder().setRequestTime(timeNs).setSession(session).setEnabled(false).build());
            this.myProfilers.getClient().getMemoryClient().trackAllocations(MemoryProfiler.TrackAllocationsRequest.newBuilder().setRequestTime(timeNs).setSession(session).setEnabled(true).build());
        }
        catch (StatusRuntimeException e) {
            MemoryProfiler.getLogger().info((Throwable)e);
        }
    }

    private void importHprof(@NotNull File file) {
        byte[] bytes;
        if (file == null) {
            MemoryProfiler.$$$reportNull$$$0(1);
        }
        SessionsManager sessionsManager = this.myProfilers.getSessionsManager();
        long startTimestampEpochMs = System.currentTimeMillis();
        long fileCreationTime = TimeUnit.MILLISECONDS.toNanos(startTimestampEpochMs);
        try {
            BasicFileAttributes attributes = Files.readAttributes(Paths.get(file.getPath(), new String[0]), BasicFileAttributes.class, new LinkOption[0]);
            fileCreationTime = TimeUnit.MILLISECONDS.toNanos(attributes.creationTime().toMillis());
        }
        catch (IOException e) {
            MemoryProfiler.getLogger().info("File creation time not provided, using system time instead...");
        }
        try {
            bytes = Files.readAllBytes(Paths.get(file.getPath(), new String[0]));
        }
        catch (IOException e) {
            MemoryProfiler.getLogger().error("Importing Session Failed: cannot read from file location...");
            return;
        }
        Common.Session session = sessionsManager.createImportedSession(file.getName(), Common.SessionMetaData.SessionType.MEMORY_CAPTURE, fileCreationTime, fileCreationTime + 1L, startTimestampEpochMs);
        MemoryProfiler.HeapDumpInfo heapDumpInfo = MemoryProfiler.HeapDumpInfo.newBuilder().setFileName(file.getName()).setStartTime(fileCreationTime).setEndTime(fileCreationTime + 1L).build();
        MemoryProfiler.ImportHeapDumpRequest heapDumpRequest = MemoryProfiler.ImportHeapDumpRequest.newBuilder().setSession(session).setData(ByteString.copyFrom((byte[])bytes)).setInfo(heapDumpInfo).build();
        MemoryProfiler.ImportHeapDumpResponse response = this.myProfilers.getClient().getMemoryClient().importHeapDump(heapDumpRequest);
        if (response.getStatus() == MemoryProfiler.ImportHeapDumpResponse.Status.SUCCESS) {
            sessionsManager.update();
            sessionsManager.setSession(session);
        } else {
            Logger.getInstance(this.getClass()).error("Importing Session Failed: cannot import heap dump...");
        }
        this.myProfilers.getIdeServices().getFeatureTracker().trackCreateSession(Common.SessionMetaData.SessionType.MEMORY_CAPTURE, SessionsManager.SessionCreationSource.MANUAL);
    }

    private void importLegacyAllocations(@NotNull File file) {
        byte[] bytes;
        if (file == null) {
            MemoryProfiler.$$$reportNull$$$0(2);
        }
        SessionsManager sessionsManager = this.myProfilers.getSessionsManager();
        long startTimestampEpochMs = System.currentTimeMillis();
        long sessionStartTimeNs = TimeUnit.MILLISECONDS.toNanos(startTimestampEpochMs);
        long sessionEndTimeNs = sessionStartTimeNs + 1L;
        try {
            bytes = Files.readAllBytes(Paths.get(file.getPath(), new String[0]));
        }
        catch (IOException e) {
            MemoryProfiler.getLogger().error("Importing Session Failed: cannot read from file location...");
            return;
        }
        Common.Session session = sessionsManager.createImportedSession(file.getName(), Common.SessionMetaData.SessionType.MEMORY_CAPTURE, sessionStartTimeNs, sessionEndTimeNs, startTimestampEpochMs);
        MemoryProfiler.AllocationsInfo info = MemoryProfiler.AllocationsInfo.newBuilder().setStartTime(sessionStartTimeNs).setEndTime(sessionEndTimeNs).setLegacy(true).build();
        MemoryProfiler.ImportLegacyAllocationsRequest request = MemoryProfiler.ImportLegacyAllocationsRequest.newBuilder().setSession(session).setInfo(info).setAllocations(MemoryProfiler.LegacyAllocationEventsResponse.newBuilder().setStatus(MemoryProfiler.LegacyAllocationEventsResponse.Status.NOT_READY)).build();
        MemoryProfiler.ImportLegacyAllocationsResponse response = this.myProfilers.getClient().getMemoryClient().importLegacyAllocations(request);
        if (response.getStatus() == MemoryProfiler.ImportLegacyAllocationsResponse.Status.SUCCESS) {
            sessionsManager.update();
            sessionsManager.setSession(session);
        } else {
            Logger.getInstance(this.getClass()).error("Importing Session Failed: cannot import allocation records...");
        }
        this.myProfilers.getIdeServices().getFeatureTracker().trackCreateSession(Common.SessionMetaData.SessionType.MEMORY_CAPTURE, SessionsManager.SessionCreationSource.MANUAL);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.submit(() -> {
            try {
                LegacyAllocationConverter converter = new LegacyAllocationConverter();
                converter.parseDump(bytes);
                MemoryProfiler.LegacyAllocationEventsResponse allocations = MemoryProfiler.LegacyAllocationEventsResponse.newBuilder().setStatus(MemoryProfiler.LegacyAllocationEventsResponse.Status.SUCCESS).addAllEvents(converter.getAllocationEvents(info.getStartTime(), info.getEndTime())).build();
                MemoryProfiler.AllocationContextsResponse contexts = MemoryProfiler.AllocationContextsResponse.newBuilder().addAllAllocatedClasses(converter.getClassNames()).addAllAllocationStacks(converter.getAllocationStacks()).build();
                MemoryProfiler.ImportLegacyAllocationsRequest updateRequest = request.toBuilder().setAllocations(allocations).setContexts(contexts).build();
                this.myProfilers.getClient().getMemoryClient().importLegacyAllocations(updateRequest);
            }
            catch (Exception e) {
                Logger.getInstance(this.getClass()).error("Importing Session Failed: cannot import allocation records...");
                MemoryProfiler.LegacyAllocationEventsResponse failedResponse = MemoryProfiler.LegacyAllocationEventsResponse.newBuilder().setStatus(MemoryProfiler.LegacyAllocationEventsResponse.Status.FAILURE_UNKNOWN).build();
                MemoryProfiler.ImportLegacyAllocationsRequest failedRequest = request.toBuilder().setAllocations(failedResponse).build();
                this.myProfilers.getClient().getMemoryClient().importLegacyAllocations(failedRequest);
            }
        });
        executorService.shutdown();
    }

    static boolean isUsingLiveAllocation(@NotNull StudioProfilers profilers, @NotNull Common.Session session) {
        long rangeMax;
        Range dataRange;
        long rangeMin;
        AllocationSamplingRateDataSeries samplingSeries;
        List<SeriesData<AllocationSamplingRateDurationData>> series;
        if (profilers == null) {
            MemoryProfiler.$$$reportNull$$$0(3);
        }
        if (session == null) {
            MemoryProfiler.$$$reportNull$$$0(4);
        }
        return !(series = (samplingSeries = new AllocationSamplingRateDataSeries(profilers.getClient().getMemoryClient(), session)).getDataForXRange(new Range((double)(rangeMin = TimeUnit.MICROSECONDS.toNanos((long)(dataRange = profilers.getTimeline().getDataRange()).getMin())), (double)(rangeMax = TimeUnit.MICROSECONDS.toNanos((long)dataRange.getMax()))))).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean hasOnlyFullAllocationTrackingWithinRegion(@NotNull MemoryServiceGrpc.MemoryServiceBlockingStub client, @NotNull Common.Session session, long startTimeUs, long l) {
        void endTimeUs;
        AllocationSamplingRateDataSeries series;
        List<SeriesData<AllocationSamplingRateDurationData>> samplingModes;
        if (client == null) {
            MemoryProfiler.$$$reportNull$$$0(5);
        }
        if (session == null) {
            MemoryProfiler.$$$reportNull$$$0(6);
        }
        return (samplingModes = (series = new AllocationSamplingRateDataSeries(client, session)).getDataForXRange(new Range((double)startTimeUs, (double)endTimeUs))).size() == 1 && ((AllocationSamplingRateDurationData)samplingModes.get((int)0).value).getCurrentRateEvent().getSamplingRate().getSamplingNumInterval() == MemoryProfilerStage.LiveAllocationSamplingMode.FULL.getValue();
    }

    public static void saveHeapDumpToFile(@NotNull MemoryServiceGrpc.MemoryServiceBlockingStub client, @NotNull Common.Session session, @NotNull MemoryProfiler.HeapDumpInfo info, @NotNull OutputStream outputStream, @NotNull FeatureTracker featureTracker) {
        MemoryProfiler.DumpDataResponse response;
        if (client == null) {
            MemoryProfiler.$$$reportNull$$$0(7);
        }
        if (session == null) {
            MemoryProfiler.$$$reportNull$$$0(8);
        }
        if (info == null) {
            MemoryProfiler.$$$reportNull$$$0(9);
        }
        if (outputStream == null) {
            MemoryProfiler.$$$reportNull$$$0(10);
        }
        if (featureTracker == null) {
            MemoryProfiler.$$$reportNull$$$0(11);
        }
        if ((response = client.getHeapDump(MemoryProfiler.DumpDataRequest.newBuilder().setSession(session).setDumpTime(info.getStartTime()).build())).getStatus() == MemoryProfiler.DumpDataResponse.Status.SUCCESS) {
            try {
                response.getData().writeTo(outputStream);
                featureTracker.trackExportHeap();
            }
            catch (IOException exception) {
                MemoryProfiler.getLogger().warn("Failed to export heap dump file:\n" + exception);
            }
        }
    }

    public static void saveLegacyAllocationToFile(@NotNull MemoryServiceGrpc.MemoryServiceBlockingStub client, @NotNull Common.Session session, @NotNull MemoryProfiler.AllocationsInfo info, @NotNull OutputStream outputStream, @NotNull FeatureTracker featureTracker) {
        MemoryProfiler.DumpDataResponse response;
        if (client == null) {
            MemoryProfiler.$$$reportNull$$$0(12);
        }
        if (session == null) {
            MemoryProfiler.$$$reportNull$$$0(13);
        }
        if (info == null) {
            MemoryProfiler.$$$reportNull$$$0(14);
        }
        if (outputStream == null) {
            MemoryProfiler.$$$reportNull$$$0(15);
        }
        if (featureTracker == null) {
            MemoryProfiler.$$$reportNull$$$0(16);
        }
        if ((response = client.getLegacyAllocationDump(MemoryProfiler.DumpDataRequest.newBuilder().setSession(session).setDumpTime(info.getStartTime()).build())).getStatus() == MemoryProfiler.DumpDataResponse.Status.SUCCESS) {
            try {
                response.getData().writeTo(outputStream);
                featureTracker.trackExportAllocation();
            }
            catch (IOException exception) {
                MemoryProfiler.getLogger().warn("Failed to export allocation records:\n" + exception);
            }
        }
    }

    @NotNull
    static String generateCaptureFileName() {
        StringBuilder builder = new StringBuilder("memory-");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss");
        builder.append(LocalDateTime.now().format(formatter));
        String string = builder.toString();
        if (string == null) {
            MemoryProfiler.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 5: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureTracker";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/MemoryProfiler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/MemoryProfiler";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "generateCaptureFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "importHprof";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "importLegacyAllocations";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isUsingLiveAllocation";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasOnlyFullAllocationTrackingWithinRegion";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "saveHeapDumpToFile";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "saveLegacyAllocationToFile";
                break;
            }
            case 17: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

