/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class MemoryDataSeries
implements DataSeries<Long> {
    @NotNull
    private MemoryServiceGrpc.MemoryServiceBlockingStub myClient;
    @NotNull
    private final Common.Session mySession;
    @NotNull
    private Function<MemoryProfiler.MemoryData.MemorySample, Long> mySampleTransformer;

    public MemoryDataSeries(@NotNull MemoryServiceGrpc.MemoryServiceBlockingStub client, @NotNull Common.Session session, @NotNull Function<MemoryProfiler.MemoryData.MemorySample, Long> transformer) {
        if (client == null) {
            MemoryDataSeries.$$$reportNull$$$0(0);
        }
        if (session == null) {
            MemoryDataSeries.$$$reportNull$$$0(1);
        }
        if (transformer == null) {
            MemoryDataSeries.$$$reportNull$$$0(2);
        }
        this.myClient = client;
        this.mySession = session;
        this.mySampleTransformer = transformer;
    }

    public List<SeriesData<Long>> getDataForXRange(@NotNull Range timeCurrentRangeUs) {
        if (timeCurrentRangeUs == null) {
            MemoryDataSeries.$$$reportNull$$$0(3);
        }
        long bufferNs = TimeUnit.SECONDS.toNanos(1L);
        MemoryProfiler.MemoryRequest.Builder dataRequestBuilder = MemoryProfiler.MemoryRequest.newBuilder().setSession(this.mySession).setStartTime(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMin()) - bufferNs).setEndTime(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMax()) + bufferNs);
        MemoryProfiler.MemoryData response = this.myClient.getData(dataRequestBuilder.build());
        ArrayList<SeriesData<Long>> seriesData = new ArrayList<SeriesData<Long>>();
        for (MemoryProfiler.MemoryData.MemorySample sample : response.getMemSamplesList()) {
            long dataTimestamp = TimeUnit.NANOSECONDS.toMicros(sample.getTimestamp());
            seriesData.add((SeriesData<Long>)new SeriesData(dataTimestamp, (Object)this.mySampleTransformer.apply(sample)));
        }
        return seriesData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeCurrentRangeUs";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/memory/MemoryDataSeries";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getDataForXRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

