/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.sessions.SessionArtifact;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class HprofSessionArtifact
implements SessionArtifact<MemoryProfiler.HeapDumpInfo> {
    @NotNull
    private final StudioProfilers myProfilers;
    @NotNull
    private final Common.Session mySession;
    @NotNull
    private final Common.SessionMetaData mySessionMetaData;
    @NotNull
    private final MemoryProfiler.HeapDumpInfo myInfo;

    public HprofSessionArtifact(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Common.SessionMetaData sessionMetaData, @NotNull MemoryProfiler.HeapDumpInfo info) {
        if (profilers == null) {
            HprofSessionArtifact.$$$reportNull$$$0(0);
        }
        if (session == null) {
            HprofSessionArtifact.$$$reportNull$$$0(1);
        }
        if (sessionMetaData == null) {
            HprofSessionArtifact.$$$reportNull$$$0(2);
        }
        if (info == null) {
            HprofSessionArtifact.$$$reportNull$$$0(3);
        }
        this.myProfilers = profilers;
        this.mySession = session;
        this.mySessionMetaData = sessionMetaData;
        this.myInfo = info;
    }

    @Override
    @NotNull
    public MemoryProfiler.HeapDumpInfo getArtifactProto() {
        MemoryProfiler.HeapDumpInfo heapDumpInfo = this.myInfo;
        if (heapDumpInfo == null) {
            HprofSessionArtifact.$$$reportNull$$$0(4);
        }
        return heapDumpInfo;
    }

    @Override
    @NotNull
    public StudioProfilers getProfilers() {
        StudioProfilers studioProfilers = this.myProfilers;
        if (studioProfilers == null) {
            HprofSessionArtifact.$$$reportNull$$$0(5);
        }
        return studioProfilers;
    }

    @Override
    @NotNull
    public Common.Session getSession() {
        Common.Session session = this.mySession;
        if (session == null) {
            HprofSessionArtifact.$$$reportNull$$$0(6);
        }
        return session;
    }

    @Override
    @NotNull
    public Common.SessionMetaData getSessionMetaData() {
        Common.SessionMetaData sessionMetaData = this.mySessionMetaData;
        if (sessionMetaData == null) {
            HprofSessionArtifact.$$$reportNull$$$0(7);
        }
        return sessionMetaData;
    }

    @Override
    @NotNull
    public String getName() {
        if ("Heap Dump" == null) {
            HprofSessionArtifact.$$$reportNull$$$0(8);
        }
        return "Heap Dump";
    }

    @NotNull
    public String getSubtitle() {
        if (this.mySessionMetaData.getType() == Common.SessionMetaData.SessionType.MEMORY_CAPTURE) {
            String string = TimeFormatter.getLocalizedDateTime((long)TimeUnit.NANOSECONDS.toMillis(this.mySession.getStartTimestamp()));
            if (string == null) {
                HprofSessionArtifact.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = this.isOngoing() ? "Recording..." : TimeFormatter.getFullClockString((long)TimeUnit.NANOSECONDS.toMicros(this.getTimestampNs()));
        if (string == null) {
            HprofSessionArtifact.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    public long getTimestampNs() {
        return this.myInfo.getStartTime() - this.mySession.getStartTimestamp();
    }

    @Override
    public boolean isOngoing() {
        return this.myInfo.getEndTime() == Long.MAX_VALUE;
    }

    @Override
    public boolean canExport() {
        return !this.isOngoing();
    }

    @Override
    public void onSelect() {
        boolean needsToOpenMemoryProfiler;
        boolean needsToChangeSession;
        boolean bl = needsToChangeSession = this.mySession != this.myProfilers.getSession();
        if (needsToChangeSession) {
            this.myProfilers.getSessionsManager().setSession(this.mySession);
        }
        boolean bl2 = needsToOpenMemoryProfiler = !(this.myProfilers.getStage() instanceof MemoryProfilerStage);
        if (needsToOpenMemoryProfiler) {
            this.myProfilers.setStage(new MemoryProfilerStage(this.myProfilers));
        }
        long startTimestamp = TimeUnit.NANOSECONDS.toMicros(this.myInfo.getStartTime());
        long endTimestamp = TimeUnit.NANOSECONDS.toMicros(this.myInfo.getEndTime());
        if (this.isOngoing()) {
            SessionArtifact.navigateTimelineToOngoingCapture(this.myProfilers.getTimeline(), startTimestamp);
        } else {
            assert (this.myProfilers.getStage() instanceof MemoryProfilerStage);
            MemoryProfilerStage stage = (MemoryProfilerStage)this.myProfilers.getStage();
            Range captureRange = new Range((double)startTimestamp, (double)endTimestamp);
            this.myProfilers.getTimeline().adjustRangeCloseToMiddleView(captureRange);
            stage.getSelectionModel().set(captureRange.getMin(), captureRange.getMax());
        }
        this.myProfilers.getIdeServices().getFeatureTracker().trackSessionArtifactSelected(this, this.myProfilers.getSessionsManager().isSessionAlive());
    }

    @Override
    public void export(@NotNull OutputStream outputStream) {
        if (outputStream == null) {
            HprofSessionArtifact.$$$reportNull$$$0(11);
        }
        assert (this.canExport());
        MemoryProfiler.saveHeapDumpToFile(this.myProfilers.getClient().getMemoryClient(), this.mySession, this.myInfo, outputStream, this.myProfilers.getIdeServices().getFeatureTracker());
    }

    public static List<SessionArtifact> getSessionArtifacts(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Common.SessionMetaData sessionMetaData) {
        if (profilers == null) {
            HprofSessionArtifact.$$$reportNull$$$0(12);
        }
        if (session == null) {
            HprofSessionArtifact.$$$reportNull$$$0(13);
        }
        if (sessionMetaData == null) {
            HprofSessionArtifact.$$$reportNull$$$0(14);
        }
        MemoryProfiler.ListHeapDumpInfosResponse response = profilers.getClient().getMemoryClient().listHeapDumpInfos(MemoryProfiler.ListDumpInfosRequest.newBuilder().setSession(session).setStartTime(session.getStartTimestamp()).setEndTime(session.getEndTimestamp()).build());
        ArrayList<SessionArtifact> artifacts = new ArrayList<SessionArtifact>();
        for (MemoryProfiler.HeapDumpInfo info : response.getInfosList()) {
            artifacts.add(new HprofSessionArtifact(profilers, session, sessionMetaData, info));
        }
        return artifacts;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionMetaData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/HprofSessionArtifact";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/HprofSessionArtifact";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactProto";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilers";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSession";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionMetaData";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubtitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "export";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSessionArtifacts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

