/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.memory.CaptureDataSeries;
import com.android.tools.profilers.memory.CaptureDurationData;
import com.android.tools.profilers.memory.CaptureEntry;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.LegacyAllocationCaptureObject;
import com.android.tools.profilers.memory.adapters.LiveAllocationCaptureObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AllocationInfosDataSeries
extends CaptureDataSeries<CaptureObject> {
    @Nullable
    private MemoryProfilerStage myStage;

    AllocationInfosDataSeries(@NotNull MemoryServiceGrpc.MemoryServiceBlockingStub client, @NotNull Common.Session session, @NotNull FeatureTracker featureTracker, @Nullable MemoryProfilerStage stage) {
        if (client == null) {
            AllocationInfosDataSeries.$$$reportNull$$$0(0);
        }
        if (session == null) {
            AllocationInfosDataSeries.$$$reportNull$$$0(1);
        }
        if (featureTracker == null) {
            AllocationInfosDataSeries.$$$reportNull$$$0(2);
        }
        super(client, session, featureTracker);
        this.myStage = stage;
    }

    @NotNull
    List<MemoryProfiler.AllocationsInfo> getInfoForTimeRangeNs(long rangeMinNs, long rangeMaxNs) {
        MemoryProfiler.MemoryRequest.Builder dataRequestBuilder = MemoryProfiler.MemoryRequest.newBuilder().setSession(this.mySession).setStartTime(rangeMinNs).setEndTime(rangeMaxNs);
        MemoryProfiler.MemoryData response = this.myClient.getData(dataRequestBuilder.build());
        List list = response.getAllocationsInfoList();
        if (list == null) {
            AllocationInfosDataSeries.$$$reportNull$$$0(3);
        }
        return list;
    }

    public List<SeriesData<CaptureDurationData<CaptureObject>>> getDataForXRange(Range xRange) {
        long bufferNs = TimeUnit.SECONDS.toNanos(1L);
        long rangeMin = TimeUnit.MICROSECONDS.toNanos((long)xRange.getMin()) - bufferNs;
        long rangeMax = TimeUnit.MICROSECONDS.toNanos((long)xRange.getMax()) + bufferNs;
        List<MemoryProfiler.AllocationsInfo> infos = this.getInfoForTimeRangeNs(rangeMin, rangeMax);
        ArrayList<SeriesData<CaptureDurationData<CaptureObject>>> seriesData = new ArrayList<SeriesData<CaptureDurationData<CaptureObject>>>();
        for (MemoryProfiler.AllocationsInfo info : infos) {
            long startTimeNs = info.getStartTime();
            long durationUs = AllocationInfosDataSeries.getDurationUs(startTimeNs, info.getEndTime());
            seriesData.add((SeriesData<CaptureDurationData<CaptureObject>>)new SeriesData(AllocationInfosDataSeries.getHostTime(startTimeNs), new CaptureDurationData<CaptureObject>(durationUs, !info.getLegacy(), !info.getLegacy(), new CaptureEntry<CaptureObject>(info, () -> {
                if (info.getLegacy()) {
                    return new LegacyAllocationCaptureObject(this.myClient, this.mySession, info, this.myFeatureTracker);
                }
                return new LiveAllocationCaptureObject(this.myClient, this.mySession, startTimeNs, null, this.myStage);
            }))));
        }
        return seriesData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureTracker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/AllocationInfosDataSeries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/AllocationInfosDataSeries";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoForTimeRangeNs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

