/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.EaseOutModel;
import com.android.tools.adtui.model.Interpolatable;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SelectionListener;
import com.android.tools.adtui.model.SelectionModel;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ResizingAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.EnergyAxisFormatter;
import com.android.tools.adtui.model.formatter.SingleUnitAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profiler.proto.EnergyProfiler;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profiler.protobuf3jarjar.ByteString;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.analytics.energy.EnergyEventMetadata;
import com.android.tools.profilers.analytics.energy.EnergyRangeMetadata;
import com.android.tools.profilers.energy.DetailedEnergyEventsCount;
import com.android.tools.profilers.energy.DetailedEnergyUsage;
import com.android.tools.profilers.energy.EnergyDuration;
import com.android.tools.profilers.energy.EnergyEventOrigin;
import com.android.tools.profilers.energy.EnergyEventsDataSeries;
import com.android.tools.profilers.energy.EnergyEventsFetcher;
import com.android.tools.profilers.energy.EnergyMonitor;
import com.android.tools.profilers.energy.EnergyProfilerAspect;
import com.android.tools.profilers.energy.EnergyTraceCache;
import com.android.tools.profilers.energy.MergedEnergyEventsDataSeries;
import com.android.tools.profilers.event.EventMonitor;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyProfilerStage
extends Stage
implements CodeNavigator.Listener {
    private static final String HAS_USED_ENERGY_SELECTION = "energy.used.selection";
    private static final String ENERGY_EVENT_ORIGIN_INDEX = "energy.event.origin";
    @NotNull
    private final DetailedEnergyUsage myDetailedUsage;
    @NotNull
    private final ResizingAxisComponentModel myAxis;
    @NotNull
    private final EventMonitor myEventMonitor;
    @NotNull
    private final EnergyUsageLegends myLegends;
    @NotNull
    private final EnergyUsageLegends myUsageTooltipLegends;
    @NotNull
    private final EnergyEventLegends myEventTooltipLegends;
    @NotNull
    private final SelectionModel mySelectionModel;
    @NotNull
    private final EnergyEventsFetcher myFetcher;
    @NotNull
    private final StateChartModel<EnergyProfiler.EnergyEvent> myEventModel;
    @NotNull
    private final EaseOutModel myInstructionsEaseOutModel;
    @NotNull
    private final Updatable myUpdatable;
    private AspectObserver myAspectObserver;
    private AspectModel<EnergyProfilerAspect> myAspect;
    @NotNull
    private final EnergyTraceCache myTraceCache;
    @Nullable
    private EnergyDuration mySelectedDuration;

    public EnergyProfilerStage(final @NotNull StudioProfilers profilers) {
        if (profilers == null) {
            EnergyProfilerStage.$$$reportNull$$$0(0);
        }
        super(profilers);
        this.myAspectObserver = new AspectObserver();
        this.myAspect = new AspectModel();
        this.myTraceCache = new EnergyTraceCache(this);
        this.myDetailedUsage = new DetailedEnergyUsage(profilers);
        this.myAxis = (ResizingAxisComponentModel)new ResizingAxisComponentModel.Builder(this.myDetailedUsage.getUsageRange(), (BaseAxisFormatter)EnergyAxisFormatter.DEFAULT).setMarkerRange(EnergyMonitor.AXIS_MARKER_RANGE).build();
        this.myEventMonitor = new EventMonitor(profilers);
        this.myLegends = new EnergyUsageLegends(this.myDetailedUsage, profilers.getTimeline().getDataRange());
        this.myUsageTooltipLegends = new EnergyUsageLegends(this.myDetailedUsage, profilers.getTimeline().getTooltipRange());
        this.myEventTooltipLegends = new EnergyEventLegends(new DetailedEnergyEventsCount(profilers), profilers.getTimeline().getTooltipRange());
        final EnergyEventsDataSeries eventsDataSeries = new EnergyEventsDataSeries(profilers.getClient(), profilers.getSession());
        this.mySelectionModel = new SelectionModel(profilers.getTimeline().getSelectionRange());
        this.mySelectionModel.setSelectionEnabled(profilers.isAgentAttached());
        profilers.addDependency(this.myAspectObserver).onChange((Enum)ProfilerAspect.AGENT, () -> this.mySelectionModel.setSelectionEnabled(profilers.isAgentAttached()));
        this.mySelectionModel.addListener(new SelectionListener(){

            public void selectionCreated() {
                EnergyProfilerStage.this.setProfilerMode(ProfilerMode.EXPANDED);
                profilers.getIdeServices().getFeatureTracker().trackSelectRange();
                List<EnergyProfiler.EnergyEvent> energyEvents = eventsDataSeries.getDataForXRange(EnergyProfilerStage.this.mySelectionModel.getSelectionRange()).stream().map(seriesData -> (EnergyProfiler.EnergyEvent)seriesData.value).collect(Collectors.toList());
                if (!energyEvents.isEmpty()) {
                    List<EnergyDuration> energyDurations = EnergyDuration.groupById(energyEvents);
                    profilers.getIdeServices().getFeatureTracker().trackSelectEnergyRange(new EnergyRangeMetadata(energyDurations));
                }
                profilers.getIdeServices().getTemporaryProfilerPreferences().setBoolean(EnergyProfilerStage.HAS_USED_ENERGY_SELECTION, true);
                EnergyProfilerStage.this.myInstructionsEaseOutModel.setCurrentPercentage(1.0f);
            }

            public void selectionCleared() {
                EnergyProfilerStage.this.setProfilerMode(ProfilerMode.NORMAL);
            }
        });
        this.myFetcher = new EnergyEventsFetcher(profilers.getClient().getEnergyClient(), profilers.getSession(), profilers.getTimeline().getSelectionRange());
        this.myEventModel = new StateChartModel();
        Range range = profilers.getTimeline().getViewRange();
        this.myEventModel.addSeries(new RangedSeries(range, (DataSeries)new MergedEnergyEventsDataSeries(eventsDataSeries, EnergyDuration.Kind.ALARM, EnergyDuration.Kind.JOB)));
        this.myEventModel.addSeries(new RangedSeries(range, (DataSeries)new MergedEnergyEventsDataSeries(eventsDataSeries, EnergyDuration.Kind.WAKE_LOCK)));
        this.myEventModel.addSeries(new RangedSeries(range, (DataSeries)new MergedEnergyEventsDataSeries(eventsDataSeries, EnergyDuration.Kind.LOCATION)));
        this.myInstructionsEaseOutModel = new EaseOutModel(profilers.getUpdater(), PROFILING_INSTRUCTIONS_EASE_OUT_NS);
        this.myUpdatable = elapsedNs -> this.getStudioProfilers().getTimeline().getTooltipRange().changed((Enum)Range.Aspect.RANGE);
    }

    @Override
    public void enter() {
        this.myEventMonitor.enter();
        this.getStudioProfilers().getUpdater().register((Updatable)this.myDetailedUsage);
        this.getStudioProfilers().getUpdater().register(this.myUpdatable);
        this.getStudioProfilers().getIdeServices().getCodeNavigator().addListener(this);
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackEnterStage(this.getClass());
    }

    @Override
    public void exit() {
        this.myEventMonitor.exit();
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myDetailedUsage);
        this.getStudioProfilers().getUpdater().unregister(this.myUpdatable);
        this.getStudioProfilers().getIdeServices().getCodeNavigator().removeListener(this);
    }

    @NotNull
    public EnergyEventsFetcher getEnergyEventsFetcher() {
        EnergyEventsFetcher energyEventsFetcher = this.myFetcher;
        if (energyEventsFetcher == null) {
            EnergyProfilerStage.$$$reportNull$$$0(1);
        }
        return energyEventsFetcher;
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        SelectionModel selectionModel = this.mySelectionModel;
        if (selectionModel == null) {
            EnergyProfilerStage.$$$reportNull$$$0(2);
        }
        return selectionModel;
    }

    @NotNull
    public DetailedEnergyUsage getDetailedUsage() {
        DetailedEnergyUsage detailedEnergyUsage = this.myDetailedUsage;
        if (detailedEnergyUsage == null) {
            EnergyProfilerStage.$$$reportNull$$$0(3);
        }
        return detailedEnergyUsage;
    }

    @NotNull
    StateChartModel<EnergyProfiler.EnergyEvent> getEventModel() {
        StateChartModel<EnergyProfiler.EnergyEvent> stateChartModel = this.myEventModel;
        if (stateChartModel == null) {
            EnergyProfilerStage.$$$reportNull$$$0(4);
        }
        return stateChartModel;
    }

    @NotNull
    public AxisComponentModel getAxis() {
        ResizingAxisComponentModel resizingAxisComponentModel = this.myAxis;
        if (resizingAxisComponentModel == null) {
            EnergyProfilerStage.$$$reportNull$$$0(5);
        }
        return resizingAxisComponentModel;
    }

    @NotNull
    public EventMonitor getEventMonitor() {
        EventMonitor eventMonitor = this.myEventMonitor;
        if (eventMonitor == null) {
            EnergyProfilerStage.$$$reportNull$$$0(6);
        }
        return eventMonitor;
    }

    @NotNull
    public EnergyUsageLegends getLegends() {
        EnergyUsageLegends energyUsageLegends = this.myLegends;
        if (energyUsageLegends == null) {
            EnergyProfilerStage.$$$reportNull$$$0(7);
        }
        return energyUsageLegends;
    }

    @NotNull
    public EnergyUsageLegends getUsageTooltipLegends() {
        EnergyUsageLegends energyUsageLegends = this.myUsageTooltipLegends;
        if (energyUsageLegends == null) {
            EnergyProfilerStage.$$$reportNull$$$0(8);
        }
        return energyUsageLegends;
    }

    @NotNull
    public EnergyEventLegends getEventTooltipLegends() {
        EnergyEventLegends energyEventLegends = this.myEventTooltipLegends;
        if (energyEventLegends == null) {
            EnergyProfilerStage.$$$reportNull$$$0(9);
        }
        return energyEventLegends;
    }

    @NotNull
    public String getName() {
        if ("ENERGY" == null) {
            EnergyProfilerStage.$$$reportNull$$$0(10);
        }
        return "ENERGY";
    }

    @NotNull
    public AspectModel<EnergyProfilerAspect> getAspect() {
        AspectModel<EnergyProfilerAspect> aspectModel = this.myAspect;
        if (aspectModel == null) {
            EnergyProfilerStage.$$$reportNull$$$0(11);
        }
        return aspectModel;
    }

    @Nullable
    public EnergyDuration getSelectedDuration() {
        return this.mySelectedDuration;
    }

    public void setSelectedDuration(@Nullable EnergyDuration duration) {
        if (Objects.equals(this.mySelectedDuration, duration) || !this.canSelectDuration(duration)) {
            return;
        }
        this.mySelectedDuration = duration;
        this.myAspect.changed((Enum)EnergyProfilerAspect.SELECTED_EVENT_DURATION);
        if (this.mySelectedDuration != null) {
            this.getStudioProfilers().getIdeServices().getFeatureTracker().trackSelectEnergyEvent(new EnergyEventMetadata((Collection<EnergyProfiler.EnergyEvent>)this.mySelectedDuration.getEventList()));
        }
    }

    @NotNull
    public EnergyTraceCache getEventsTraceCache() {
        EnergyTraceCache energyTraceCache = this.myTraceCache;
        if (energyTraceCache == null) {
            EnergyProfilerStage.$$$reportNull$$$0(12);
        }
        return energyTraceCache;
    }

    @NotNull
    public EaseOutModel getInstructionsEaseOutModel() {
        EaseOutModel easeOutModel = this.myInstructionsEaseOutModel;
        if (easeOutModel == null) {
            EnergyProfilerStage.$$$reportNull$$$0(13);
        }
        return easeOutModel;
    }

    public boolean hasUserUsedEnergySelection() {
        return this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().getBoolean(HAS_USED_ENERGY_SELECTION, false);
    }

    @NotNull
    public ByteString requestBytes(@NotNull String id) {
        if (id == null) {
            EnergyProfilerStage.$$$reportNull$$$0(14);
        }
        if (StringUtil.isEmpty((String)id)) {
            ByteString byteString = ByteString.EMPTY;
            if (byteString == null) {
                EnergyProfilerStage.$$$reportNull$$$0(15);
            }
            return byteString;
        }
        Profiler.BytesRequest request = Profiler.BytesRequest.newBuilder().setId(id).setSession(this.getStudioProfilers().getSession()).build();
        Profiler.BytesResponse response = this.getStudioProfilers().getClient().getProfilerClient().getBytes(request);
        ByteString byteString = response.getContents();
        if (byteString == null) {
            EnergyProfilerStage.$$$reportNull$$$0(16);
        }
        return byteString;
    }

    @NotNull
    public EnergyDuration updateDuration(@NotNull EnergyDuration duration) {
        if (duration == null) {
            EnergyProfilerStage.$$$reportNull$$$0(17);
        }
        if (((EnergyProfiler.EnergyEvent)duration.getEventList().get(duration.getEventList().size() - 1)).getIsTerminal()) {
            EnergyDuration energyDuration = duration;
            if (energyDuration == null) {
                EnergyProfilerStage.$$$reportNull$$$0(18);
            }
            return energyDuration;
        }
        EnergyProfiler.EnergyEventGroupRequest request = EnergyProfiler.EnergyEventGroupRequest.newBuilder().setSession(this.getStudioProfilers().getSession()).setEventId(((EnergyProfiler.EnergyEvent)duration.getEventList().get(0)).getEventId()).build();
        EnergyDuration energyDuration = new EnergyDuration(this.getStudioProfilers().getClient().getEnergyClient().getEventGroup(request).getEventsList());
        if (energyDuration == null) {
            EnergyProfilerStage.$$$reportNull$$$0(19);
        }
        return energyDuration;
    }

    @NotNull
    public EnergyEventOrigin getEventOrigin() {
        int savedOriginOrdinal = this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().getInt(ENERGY_EVENT_ORIGIN_INDEX, EnergyEventOrigin.ALL.ordinal());
        EnergyEventOrigin energyEventOrigin = EnergyEventOrigin.values()[savedOriginOrdinal];
        if (energyEventOrigin == null) {
            EnergyProfilerStage.$$$reportNull$$$0(20);
        }
        return energyEventOrigin;
    }

    public void setEventOrigin(@NotNull EnergyEventOrigin origin) {
        if (origin == null) {
            EnergyProfilerStage.$$$reportNull$$$0(21);
        }
        if (this.getEventOrigin() != origin) {
            this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().setInt(ENERGY_EVENT_ORIGIN_INDEX, origin.ordinal());
            if (!this.canSelectDuration(this.getSelectedDuration())) {
                this.setSelectedDuration(null);
            }
            this.myAspect.changed((Enum)EnergyProfilerAspect.SELECTED_ORIGIN_FILTER);
        }
    }

    private boolean canSelectDuration(@Nullable EnergyDuration duration) {
        return duration == null || !this.filterByOrigin((List<EnergyDuration>)ImmutableList.of((Object)duration)).isEmpty();
    }

    @NotNull
    public List<EnergyDuration> filterByOrigin(@NotNull List<EnergyDuration> list) {
        if (list == null) {
            EnergyProfilerStage.$$$reportNull$$$0(22);
        }
        String appName = this.getStudioProfilers().getSelectedAppName();
        List<EnergyDuration> list2 = list.stream().filter(duration -> this.getEventOrigin().isValid(appName, this.myTraceCache.getTraceData(duration.getCalledByTraceId()))).collect(Collectors.toList());
        if (list2 == null) {
            EnergyProfilerStage.$$$reportNull$$$0(23);
        }
        return list2;
    }

    @Override
    public void onNavigated(@NotNull CodeLocation location) {
        if (location == null) {
            EnergyProfilerStage.$$$reportNull$$$0(24);
        }
        this.setProfilerMode(ProfilerMode.NORMAL);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/energy/EnergyProfilerStage";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duration";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/energy/EnergyProfilerStage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnergyEventsFetcher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetailedUsage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAxis";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventMonitor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLegends";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsageTooltipLegends";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventTooltipLegends";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAspect";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventsTraceCache";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstructionsEaseOutModel";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "requestBytes";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "updateDuration";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventOrigin";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "filterByOrigin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "requestBytes";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateDuration";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setEventOrigin";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "filterByOrigin";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "onNavigated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class EnergyEventLegends
    extends LegendComponentModel {
        @NotNull
        private final SeriesLegend myLocationLegend;
        @NotNull
        private final SeriesLegend myWakeLockLegend;
        @NotNull
        private final SeriesLegend myAlarmAndJobLegend;
        @NotNull
        private final Range myRange;
        @NotNull
        private final SingleUnitAxisFormatter myFormatter;

        EnergyEventLegends(@NotNull DetailedEnergyEventsCount eventCount, @NotNull Range range) {
            if (eventCount == null) {
                EnergyEventLegends.$$$reportNull$$$0(0);
            }
            if (range == null) {
                EnergyEventLegends.$$$reportNull$$$0(1);
            }
            super(range);
            this.myFormatter = new SingleUnitAxisFormatter(1, 5, 5, "");
            this.myRange = range;
            this.myLocationLegend = this.createSeriesLegend(eventCount.getLocationCountSeries());
            this.myWakeLockLegend = this.createSeriesLegend(eventCount.getWakeLockCountSeries());
            this.myAlarmAndJobLegend = this.createSeriesLegend(eventCount.getAlarmAndJobCountSeries());
            this.add((Legend)this.myLocationLegend);
            this.add((Legend)this.myWakeLockLegend);
            this.add((Legend)this.myAlarmAndJobLegend);
        }

        private SeriesLegend createSeriesLegend(RangedContinuousSeries series) {
            return new SeriesLegend(series, (BaseAxisFormatter)this.myFormatter, this.myRange, Interpolatable.SegmentInterpolator);
        }

        @NotNull
        public Legend getWakeLockLegend() {
            SeriesLegend seriesLegend = this.myWakeLockLegend;
            if (seriesLegend == null) {
                EnergyEventLegends.$$$reportNull$$$0(2);
            }
            return seriesLegend;
        }

        @NotNull
        public Legend getLocationLegend() {
            SeriesLegend seriesLegend = this.myLocationLegend;
            if (seriesLegend == null) {
                EnergyEventLegends.$$$reportNull$$$0(3);
            }
            return seriesLegend;
        }

        @NotNull
        public Legend getAlarmAndJobLegend() {
            SeriesLegend seriesLegend = this.myAlarmAndJobLegend;
            if (seriesLegend == null) {
                EnergyEventLegends.$$$reportNull$$$0(4);
            }
            return seriesLegend;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eventCount";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/energy/EnergyProfilerStage$EnergyEventLegends";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/energy/EnergyProfilerStage$EnergyEventLegends";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWakeLockLegend";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLocationLegend";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAlarmAndJobLegend";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class EnergyUsageLegends
    extends LegendComponentModel {
        @NotNull
        private final SeriesLegend myCpuLegend;
        @NotNull
        private final SeriesLegend myNetworkLegend;
        @NotNull
        private final SeriesLegend myLocationLegend;

        EnergyUsageLegends(DetailedEnergyUsage detailedUsage, Range range) {
            super(range);
            this.myCpuLegend = new SeriesLegend(detailedUsage.getCpuUsageSeries(), (BaseAxisFormatter)EnergyAxisFormatter.LEGEND_FORMATTER, range, "CPU", Interpolatable.SegmentInterpolator);
            this.myNetworkLegend = new SeriesLegend(detailedUsage.getNetworkUsageSeries(), (BaseAxisFormatter)EnergyAxisFormatter.LEGEND_FORMATTER, range, "Network", Interpolatable.SegmentInterpolator);
            this.myLocationLegend = new SeriesLegend(detailedUsage.getLocationUsageSeries(), (BaseAxisFormatter)EnergyAxisFormatter.LEGEND_FORMATTER, range, "Location", Interpolatable.SegmentInterpolator);
            this.add((Legend)this.myCpuLegend);
            this.add((Legend)this.myNetworkLegend);
            this.add((Legend)this.myLocationLegend);
        }

        @NotNull
        public Legend getCpuLegend() {
            SeriesLegend seriesLegend = this.myCpuLegend;
            if (seriesLegend == null) {
                EnergyUsageLegends.$$$reportNull$$$0(0);
            }
            return seriesLegend;
        }

        @NotNull
        public Legend getNetworkLegend() {
            SeriesLegend seriesLegend = this.myNetworkLegend;
            if (seriesLegend == null) {
                EnergyUsageLegends.$$$reportNull$$$0(1);
            }
            return seriesLegend;
        }

        @NotNull
        public SeriesLegend getLocationLegend() {
            SeriesLegend seriesLegend = this.myLocationLegend;
            if (seriesLegend == null) {
                EnergyUsageLegends.$$$reportNull$$$0(2);
            }
            return seriesLegend;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/android/tools/profilers/energy/EnergyProfilerStage$EnergyUsageLegends";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCpuLegend";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNetworkLegend";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLocationLegend";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

