/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.EnergyProfiler;
import com.android.tools.profilers.energy.EnergyDuration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class EnergyEventsCountDataSeries
implements DataSeries<Long> {
    @NotNull
    private final RangedSeries<EnergyProfiler.EnergyEvent> myDelegateSeries;
    private final List<EnergyDuration.Kind> myKindsFilter;

    public EnergyEventsCountDataSeries(@NotNull RangedSeries<EnergyProfiler.EnergyEvent> delegateSeries, EnergyDuration.Kind ... kindsFilter) {
        if (delegateSeries == null) {
            EnergyEventsCountDataSeries.$$$reportNull$$$0(0);
        }
        if (kindsFilter == null) {
            EnergyEventsCountDataSeries.$$$reportNull$$$0(1);
        }
        this.myDelegateSeries = delegateSeries;
        this.myKindsFilter = Arrays.asList(kindsFilter);
    }

    public List<SeriesData<Long>> getDataForXRange(Range xRange) {
        List sourceData = this.myDelegateSeries.getSeries();
        long position = (long)xRange.getMax();
        HashSet<Integer> activeEventGroups = new HashSet<Integer>();
        for (SeriesData eventData : sourceData) {
            if (!this.myKindsFilter.contains((Object)EnergyDuration.Kind.from((EnergyProfiler.EnergyEvent)eventData.value))) continue;
            if (eventData.x > position) break;
            if (!((EnergyProfiler.EnergyEvent)eventData.value).getIsTerminal()) {
                activeEventGroups.add(((EnergyProfiler.EnergyEvent)eventData.value).getEventId());
                continue;
            }
            activeEventGroups.remove(((EnergyProfiler.EnergyEvent)eventData.value).getEventId());
        }
        return Collections.singletonList(new SeriesData(position, (Object)activeEventGroups.size()));
    }

    public List<EnergyDuration.Kind> getKindsFilter() {
        return this.myKindsFilter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "delegateSeries";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "kindsFilter";
                break;
            }
        }
        objectArray[1] = "com/android/tools/profilers/energy/EnergyEventsCountDataSeries";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

