/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.model.Range;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CpuTreeNode<T extends CpuTreeNode> {
    protected final List<CaptureNode> myNodes = new ArrayList<CaptureNode>();
    private final List<T> myChildren = new ArrayList<T>();
    private final String myId;
    protected double myGlobalTotal = 0.0;
    protected double myGlobalChildrenTotal = 0.0;
    protected double myThreadTotal = 0.0;
    protected double myThreadChildrenTotal = 0.0;

    public CpuTreeNode(String id) {
        this.myId = id;
    }

    public String getId() {
        return this.myId;
    }

    protected void addNode(@NotNull CaptureNode node) {
        if (node == null) {
            CpuTreeNode.$$$reportNull$$$0(0);
        }
        this.myNodes.add(node);
    }

    protected void addNodes(@NotNull List<CaptureNode> nodes) {
        if (nodes == null) {
            CpuTreeNode.$$$reportNull$$$0(1);
        }
        nodes.forEach(this::addNode);
    }

    @NotNull
    public List<CaptureNode> getNodes() {
        List<CaptureNode> list = this.myNodes;
        if (list == null) {
            CpuTreeNode.$$$reportNull$$$0(2);
        }
        return list;
    }

    protected void addChild(@NotNull T child) {
        if (child == null) {
            CpuTreeNode.$$$reportNull$$$0(3);
        }
        this.myChildren.add(child);
    }

    public List<T> getChildren() {
        return this.myChildren;
    }

    public double getGlobalTotal() {
        return this.myGlobalTotal;
    }

    public double getThreadTotal() {
        return this.myThreadTotal;
    }

    public double getGlobalChildrenTotal() {
        return this.myGlobalChildrenTotal;
    }

    public double getSelf() {
        return this.getGlobalTotal() - this.getGlobalChildrenTotal();
    }

    public void update(@NotNull Range range) {
        if (range == null) {
            CpuTreeNode.$$$reportNull$$$0(4);
        }
        this.myGlobalTotal = 0.0;
        this.myGlobalChildrenTotal = 0.0;
        this.myThreadTotal = 0.0;
        this.myThreadChildrenTotal = 0.0;
        for (CaptureNode node : this.myNodes) {
            this.myGlobalTotal += CpuTreeNode.getIntersection(range, node, ClockType.GLOBAL);
            this.myThreadTotal += CpuTreeNode.getIntersection(range, node, ClockType.THREAD);
            for (CaptureNode child : node.getChildren()) {
                this.myGlobalChildrenTotal += CpuTreeNode.getIntersection(range, child, ClockType.GLOBAL);
                this.myThreadChildrenTotal += CpuTreeNode.getIntersection(range, child, ClockType.THREAD);
            }
        }
    }

    protected static double getIntersection(@NotNull Range range, @NotNull CaptureNode node, @NotNull ClockType type) {
        if (range == null) {
            CpuTreeNode.$$$reportNull$$$0(5);
        }
        if (node == null) {
            CpuTreeNode.$$$reportNull$$$0(6);
        }
        if (type == null) {
            CpuTreeNode.$$$reportNull$$$0(7);
        }
        Range intersection = type == ClockType.GLOBAL ? range.getIntersection(new Range((double)node.getStartGlobal(), (double)node.getEndGlobal())) : range.getIntersection(new Range((double)node.getStartThread(), (double)node.getEndThread()));
        return intersection.isEmpty() ? 0.0 : intersection.getLength();
    }

    public boolean inRange(Range range) {
        return this.myNodes.stream().anyMatch(node -> (double)node.getStart() < range.getMax() && range.getMin() < (double)node.getEnd());
    }

    public void reset() {
        this.myGlobalTotal = 0.0;
        this.myGlobalChildrenTotal = 0.0;
        this.myThreadTotal = 0.0;
        this.myThreadChildrenTotal = 0.0;
    }

    @NotNull
    public abstract CaptureNodeModel getMethodModel();

    public abstract CaptureNode.FilterType getFilterType();

    public boolean isUnmatched() {
        return this.getFilterType() == CaptureNode.FilterType.UNMATCH;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/capturedetails/CpuTreeNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/CpuTreeNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addNode";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addNodes";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIntersection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

