/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuProfilerStageView;
import com.android.tools.profilers.cpu.capturedetails.CapturePane;
import com.android.tools.profilers.cpu.capturedetails.DetailsCapturePane;
import com.android.tools.profilers.cpu.capturedetails.RecordingInitiatorPane;
import com.android.tools.profilers.cpu.capturedetails.StatusPane;
import com.google.common.annotations.VisibleForTesting;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CpuCaptureView {
    @NotNull
    private final CpuProfilerStageView myStageView;
    @NotNull
    private final CpuProfilerStage myStage;
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private CapturePane myCapturePane;
    @NotNull
    private final AspectObserver myObserver;

    public CpuCaptureView(@NotNull CpuProfilerStageView stageView) {
        if (stageView == null) {
            CpuCaptureView.$$$reportNull$$$0(0);
        }
        this.myStageView = stageView;
        this.myStage = (CpuProfilerStage)stageView.getStage();
        this.myPanel = new JPanel(new BorderLayout());
        this.myObserver = new AspectObserver();
        this.myCapturePane = this.createCapturePane();
        this.myStage.getAspect().addDependency(this.myObserver).onChange((Enum)CpuProfilerAspect.CAPTURE_DETAILS, this::updateCaptureDetails).onChange((Enum)CpuProfilerAspect.CAPTURE_STATE, this::onCaptureStateChanged).onChange((Enum)CpuProfilerAspect.CAPTURE_SELECTION, this::updateCapturePane);
        this.myStage.getCaptureParser().getAspect().addDependency(this.myObserver).onChange((Enum)CpuProfilerAspect.CAPTURE_PARSING, this::updateCapturePane);
        this.updateCapturePane();
    }

    private void updateCaptureDetails() {
        this.myCapturePane.updateView();
    }

    private void onCaptureStateChanged() {
        if (this.myStage.getCaptureState() == CpuProfilerStage.CaptureState.STARTING || this.myStage.getCaptureState() == CpuProfilerStage.CaptureState.STOPPING) {
            return;
        }
        this.updateCapturePane();
    }

    private void updateCapturePane() {
        this.myPanel.removeAll();
        this.myCapturePane = this.createCapturePane();
        this.myPanel.add((Component)this.myCapturePane, "Center");
        this.myPanel.revalidate();
    }

    @NotNull
    private CapturePane createCapturePane() {
        if (this.myStage.getCaptureParser().isParsing()) {
            ParsingPane parsingPane = new ParsingPane(this.myStageView);
            if (parsingPane == null) {
                CpuCaptureView.$$$reportNull$$$0(1);
            }
            return parsingPane;
        }
        if (this.myStage.getCaptureState() == CpuProfilerStage.CaptureState.CAPTURING) {
            RecordingPane recordingPane = new RecordingPane(this.myStageView);
            if (recordingPane == null) {
                CpuCaptureView.$$$reportNull$$$0(2);
            }
            return recordingPane;
        }
        if (this.myStage.getCapture() == null) {
            RecordingInitiatorPane recordingInitiatorPane = new RecordingInitiatorPane(this.myStageView);
            if (recordingInitiatorPane == null) {
                CpuCaptureView.$$$reportNull$$$0(3);
            }
            return recordingInitiatorPane;
        }
        DetailsCapturePane detailsCapturePane = new DetailsCapturePane(this.myStageView);
        if (detailsCapturePane == null) {
            CpuCaptureView.$$$reportNull$$$0(4);
        }
        return detailsCapturePane;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            CpuCaptureView.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stageView";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/capturedetails/CpuCaptureView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/CpuCaptureView";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCapturePane";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class ParsingPane
    extends StatusPane {
        static final String ABORT_BUTTON_TEXT = "Abort";

        public ParsingPane(@NotNull CpuProfilerStageView stageView) {
            if (stageView == null) {
                ParsingPane.$$$reportNull$$$0(0);
            }
            super(stageView, "Parsing");
        }

        @Override
        @NotNull
        protected String getDurationText() {
            String string = TimeFormatter.getMultiUnitDurationString((long)TimeUnit.MILLISECONDS.toMicros(this.myStage.getCaptureParser().getParsingElapsedTimeMs()));
            if (string == null) {
                ParsingPane.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected JButton createAbortButton() {
            JButton abortButton = new JButton(ABORT_BUTTON_TEXT);
            abortButton.addActionListener(event -> {
                this.myStage.getCaptureParser().abortParsing();
                this.myStage.setCaptureState(CpuProfilerStage.CaptureState.IDLE);
                abortButton.setEnabled(false);
            });
            return abortButton;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stageView";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/capturedetails/CpuCaptureView$ParsingPane";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/CpuCaptureView$ParsingPane";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDurationText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @VisibleForTesting
    static class RecordingPane
    extends StatusPane {
        private JButton myStopRecordingButton;

        public RecordingPane(@NotNull CpuProfilerStageView stageView) {
            if (stageView == null) {
                RecordingPane.$$$reportNull$$$0(0);
            }
            super(stageView, "Recording");
            this.myStage.getAspect().addDependency(this.myObserver).onChange((Enum)CpuProfilerAspect.CAPTURE_STATE, () -> this.myStopRecordingButton.setEnabled(false));
        }

        @Override
        protected JButton createAbortButton() {
            this.myStopRecordingButton = new JButton("Stop");
            this.myStopRecordingButton.addActionListener(event -> this.myStage.toggleCapturing());
            this.myStopRecordingButton.setEnabled(true);
            return this.myStopRecordingButton;
        }

        @Override
        @NotNull
        protected String getDurationText() {
            String string = TimeFormatter.getMultiUnitDurationString((long)this.myStage.getCaptureElapsedTimeUs());
            if (string == null) {
                RecordingPane.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stageView";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/capturedetails/CpuCaptureView$RecordingPane";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/CpuCaptureView$RecordingPane";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDurationText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

