/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.filter.Filter;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaptureModel {
    private static final double EPSILON = 1.0E-5;
    public static final int NO_THREAD = -1;
    private static final Map<CaptureDetails.Type, Consumer<FeatureTracker>> DETAILS_TRACKERS = ImmutableMap.of((Object)((Object)CaptureDetails.Type.TOP_DOWN), FeatureTracker::trackSelectCaptureTopDown, (Object)((Object)CaptureDetails.Type.BOTTOM_UP), FeatureTracker::trackSelectCaptureBottomUp, (Object)((Object)CaptureDetails.Type.CALL_CHART), FeatureTracker::trackSelectCaptureCallChart, (Object)((Object)CaptureDetails.Type.FLAME_CHART), FeatureTracker::trackSelectCaptureFlameChart);
    @NotNull
    private final CpuProfilerStage myStage;
    @Nullable
    private CpuCapture myCapture;
    private int myThread;
    @NotNull
    private ClockType myClockType;
    @NotNull
    private Filter myFilter;
    @Nullable
    private CaptureDetails myDetails;
    private int myTotalNodeCount;
    private int myFilterNodeCount;
    private final Range myCaptureConvertedRange;

    public CaptureModel(@NotNull CpuProfilerStage stage) {
        if (stage == null) {
            CaptureModel.$$$reportNull$$$0(0);
        }
        this.myClockType = ClockType.GLOBAL;
        this.myFilter = Filter.EMPTY_FILTER;
        this.myStage = stage;
        this.myCaptureConvertedRange = new Range();
        this.myThread = -1;
        Range selection = this.myStage.getStudioProfilers().getTimeline().getSelectionRange();
        selection.addDependency(this.myStage.getAspect()).onChange((Enum)Range.Aspect.RANGE, this::updateCaptureConvertedRange);
        this.myCaptureConvertedRange.addDependency(this.myStage.getAspect()).onChange((Enum)Range.Aspect.RANGE, this::updateSelectionRange);
    }

    public boolean setCapture(@Nullable CpuCapture capture) {
        if (this.myCapture == capture) {
            return false;
        }
        this.myCapture = capture;
        if (this.myCapture != null) {
            this.setThread(this.myThread != -1 ? this.myThread : capture.getMainThreadId());
            if (this.myCapture.isDualClock()) {
                this.setClockType(this.myClockType);
            } else {
                this.setClockType(ClockType.GLOBAL);
            }
        } else {
            this.setThread(-1);
        }
        this.rebuildDetails();
        this.myStage.getAspect().changed((Enum)CpuProfilerAspect.CAPTURE_SELECTION);
        return true;
    }

    @Nullable
    public CpuCapture getCapture() {
        return this.myCapture;
    }

    public void setThread(int thread2) {
        if (this.myThread == thread2) {
            return;
        }
        this.myThread = thread2;
        this.rebuildDetails();
        this.myStage.getAspect().changed((Enum)CpuProfilerAspect.SELECTED_THREADS);
    }

    public int getThread() {
        return this.myThread;
    }

    public void setClockType(@NotNull ClockType type) {
        if (type == null) {
            CaptureModel.$$$reportNull$$$0(1);
        }
        if (this.myClockType == type || this.myCapture != null && !this.myCapture.isDualClock() && type == ClockType.THREAD) {
            return;
        }
        this.myClockType = type;
        if (this.myCapture != null) {
            this.myCapture.updateClockType(this.myClockType);
        }
        this.rebuildDetails();
        this.updateCaptureConvertedRange();
        this.myStage.getAspect().changed((Enum)CpuProfilerAspect.CLOCK_TYPE);
    }

    @NotNull
    public ClockType getClockType() {
        ClockType clockType = this.myClockType;
        if (clockType == null) {
            CaptureModel.$$$reportNull$$$0(2);
        }
        return clockType;
    }

    public void setFilter(@NotNull Filter filter) {
        if (filter == null) {
            CaptureModel.$$$reportNull$$$0(3);
        }
        if (Objects.equals(filter, this.myFilter)) {
            return;
        }
        this.myFilter = filter;
        this.rebuildDetails();
    }

    @NotNull
    public Filter getFilter() {
        Filter filter = this.myFilter;
        if (filter == null) {
            CaptureModel.$$$reportNull$$$0(4);
        }
        return filter;
    }

    public void setDetails(@Nullable CaptureDetails.Type type) {
        if (type != null && this.myDetails != null && type == this.myDetails.getType()) {
            return;
        }
        FeatureTracker tracker = this.myStage.getStudioProfilers().getIdeServices().getFeatureTracker();
        if (type != null) {
            DETAILS_TRACKERS.get((Object)type).accept(tracker);
        }
        this.buildDetails(type);
    }

    @Nullable
    public CaptureDetails getDetails() {
        return this.myDetails;
    }

    private void rebuildDetails() {
        if (this.myCapture == null) {
            this.buildDetails(null);
        } else {
            this.buildDetails(this.myDetails == null ? CaptureDetails.Type.CALL_CHART : this.myDetails.getType());
        }
    }

    private void buildDetails(@Nullable CaptureDetails.Type type) {
        this.updateCaptureConvertedRange();
        this.myTotalNodeCount = 0;
        this.myFilterNodeCount = 0;
        if (type != null) {
            CaptureNode node = this.getNode();
            if (node != null) {
                this.applyFilter(node, false);
            }
            this.myDetails = type.build(this.myCaptureConvertedRange, node);
        } else {
            this.myFilter = Filter.EMPTY_FILTER;
            this.myDetails = null;
        }
        this.myStage.getAspect().changed((Enum)CpuProfilerAspect.CAPTURE_DETAILS);
    }

    @Nullable
    private CaptureNode getNode() {
        return this.myCapture != null ? this.myCapture.getCaptureNode(this.myThread) : null;
    }

    public int getNodeCount() {
        return this.myTotalNodeCount;
    }

    public int getFilterNodeCount() {
        return this.myFilterNodeCount;
    }

    private void applyFilter(@NotNull CaptureNode node, boolean matches) {
        if (node == null) {
            CaptureModel.$$$reportNull$$$0(5);
        }
        boolean nodeExactMatch = node.matchesToFilter(this.myFilter);
        matches = matches || nodeExactMatch;
        boolean allChildrenUnmatch = true;
        ++this.myTotalNodeCount;
        if (nodeExactMatch) {
            ++this.myFilterNodeCount;
        }
        for (CaptureNode child : node.getChildren()) {
            this.applyFilter(child, matches);
            if (child.isUnmatched()) continue;
            allChildrenUnmatch = false;
        }
        if (!matches && allChildrenUnmatch) {
            node.setFilterType(CaptureNode.FilterType.UNMATCH);
        } else if (nodeExactMatch && !this.myFilter.isEmpty()) {
            node.setFilterType(CaptureNode.FilterType.EXACT_MATCH);
        } else {
            node.setFilterType(CaptureNode.FilterType.MATCH);
        }
    }

    private void updateCaptureConvertedRange() {
        CaptureNode node;
        Range selection = this.myStage.getStudioProfilers().getTimeline().getSelectionRange();
        ClockType clockType = this.getClockType();
        CpuCapture capture = this.getCapture();
        if (clockType == ClockType.GLOBAL || capture == null || (node = capture.getCaptureNode(this.getThread())) == null) {
            this.setConvertedRange(selection.getMin(), selection.getMax());
            return;
        }
        double convertedMin = (double)node.getStartThread() + node.threadGlobalRatio() * (selection.getMin() - (double)node.getStartGlobal());
        double convertedMax = convertedMin + node.threadGlobalRatio() * selection.getLength();
        this.setConvertedRange(convertedMin, convertedMax);
    }

    private void updateSelectionRange() {
        CaptureNode node;
        ClockType clockType = this.getClockType();
        CpuCapture capture = this.getCapture();
        if (clockType == ClockType.GLOBAL || capture == null || (node = capture.getCaptureNode(this.getThread())) == null) {
            this.setSelectionRange(this.myCaptureConvertedRange.getMin(), this.myCaptureConvertedRange.getMax());
            return;
        }
        double threadToGlobal = 1.0 / node.threadGlobalRatio();
        double convertedMin = (double)node.getStartGlobal() + threadToGlobal * (this.myCaptureConvertedRange.getMin() - (double)node.getStartThread());
        double convertedMax = convertedMin + threadToGlobal * this.myCaptureConvertedRange.getLength();
        this.setSelectionRange(convertedMin, convertedMax);
    }

    private void setSelectionRange(double min, double max) {
        Range selection = this.myStage.getStudioProfilers().getTimeline().getSelectionRange();
        if (Math.abs(selection.getMin() - min) > 1.0E-5 || Math.abs(selection.getMax() - max) > 1.0E-5) {
            selection.set(min, max);
        }
    }

    private void setConvertedRange(double min, double max) {
        if (Math.abs(this.myCaptureConvertedRange.getMin() - min) > 1.0E-5 || Math.abs(this.myCaptureConvertedRange.getMax() - max) > 1.0E-5) {
            this.myCaptureConvertedRange.set(min, max);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/capturedetails/CaptureModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/CaptureModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClockType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setClockType";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setFilter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFilter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

