/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.common.EnumColors;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.android.tools.profilers.cpu.capturedetails.CaptureNodeHRenderer;
import com.android.tools.profilers.cpu.nodemodel.AtraceNodeModel;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

class AtraceNodeModelHChartColors {
    private static EnumColors<CpuProfilerStage.ThreadState> threadColors = ProfilerColors.THREAD_STATES.build();

    AtraceNodeModelHChartColors() {
    }

    private static void validateModel(@NotNull CaptureNodeModel model) {
        if (model == null) {
            AtraceNodeModelHChartColors.$$$reportNull$$$0(0);
        }
        if (!(model instanceof AtraceNodeModel)) {
            throw new IllegalStateException("Model must be an instance of AtraceNodeModel.");
        }
    }

    static Color getIdleCpuColor(@NotNull CaptureNodeModel model, CaptureDetails.Type chartType, boolean isUnmatched, boolean isFocused) {
        Color color;
        if (model == null) {
            AtraceNodeModelHChartColors.$$$reportNull$$$0(1);
        }
        if (chartType == CaptureDetails.Type.CALL_CHART) {
            threadColors.setColorIndex(isFocused ? 1 : 0);
            color = threadColors.getColor((Enum)CpuProfilerStage.ThreadState.RUNNABLE_CAPTURED);
        } else {
            color = isFocused ? ProfilerColors.CPU_FLAMECHART_APP_HOVER_IDLE : ProfilerColors.CPU_FLAMECHART_APP_IDLE;
        }
        return isUnmatched ? CaptureNodeHRenderer.toUnmatchColor(color) : color;
    }

    static Color getFillColor(@NotNull CaptureNodeModel model, CaptureDetails.Type chartType, boolean isUnmatched, boolean isFocused) {
        Color color;
        if (model == null) {
            AtraceNodeModelHChartColors.$$$reportNull$$$0(2);
        }
        AtraceNodeModelHChartColors.validateModel(model);
        if (chartType == CaptureDetails.Type.CALL_CHART) {
            threadColors.setColorIndex(isFocused ? 1 : 0);
            color = threadColors.getColor((Enum)CpuProfilerStage.ThreadState.RUNNING_CAPTURED);
        } else {
            color = isFocused ? ProfilerColors.CPU_FLAMECHART_APP_HOVER : ProfilerColors.CPU_FLAMECHART_APP;
        }
        return isUnmatched ? CaptureNodeHRenderer.toUnmatchColor(color) : color;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "model";
        objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/AtraceNodeModelHChartColors";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "validateModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getIdleCpuColor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getFillColor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

