/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.atrace;

import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.cpu.CpuFramesModel;
import com.android.tools.profilers.cpu.atrace.AtraceFrame;
import com.android.tools.profilers.cpu.atrace.AtraceFrameFilterConfig;
import com.android.tools.profilers.cpu.atrace.SliceStream;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import trebuchet.model.ProcessModel;
import trebuchet.model.ThreadModel;
import trebuchet.model.base.SliceGroup;

public class AtraceFrameManager {
    @NotNull
    private final Function<Double, Long> myBootClockSecondsToMonoUs;
    @NotNull
    private final ProcessModel myProcessModel;
    private final int myRenderThreadId;
    private final List<AtraceFrame> myMainThreadFrames;
    private final List<AtraceFrame> myRenderThreadFrames;

    public AtraceFrameManager(@NotNull ProcessModel process, @NotNull Function<Double, Long> bootClockSecondsToMonoUs, int renderThreadId) {
        if (process == null) {
            AtraceFrameManager.$$$reportNull$$$0(0);
        }
        if (bootClockSecondsToMonoUs == null) {
            AtraceFrameManager.$$$reportNull$$$0(1);
        }
        this.myBootClockSecondsToMonoUs = bootClockSecondsToMonoUs;
        this.myProcessModel = process;
        this.myRenderThreadId = renderThreadId;
        this.myMainThreadFrames = this.getFramesList("Choreographer#doFrame", this.myProcessModel.getId(), CpuFramesModel.SLOW_FRAME_RATE_US, AtraceFrame.FrameThread.MAIN);
        this.myRenderThreadFrames = this.getFramesList("(DrawFrame|doFrame|queueBuffer)", this.myRenderThreadId, CpuFramesModel.SLOW_FRAME_RATE_US, AtraceFrame.FrameThread.RENDER);
        this.findAssociatedFrames();
    }

    private void findAssociatedFrames() {
        int mainFramesIterator = 0;
        int renderFramesIterator = 0;
        while (mainFramesIterator < this.myMainThreadFrames.size() && renderFramesIterator < this.myRenderThreadFrames.size()) {
            AtraceFrame mainThreadFrame = this.myMainThreadFrames.get(mainFramesIterator);
            AtraceFrame renderThreadFrame = this.myRenderThreadFrames.get(renderFramesIterator);
            if (renderThreadFrame == AtraceFrame.EMPTY || renderThreadFrame.getEndUs() < mainThreadFrame.getEndUs()) {
                ++renderFramesIterator;
                continue;
            }
            if (mainThreadFrame == AtraceFrame.EMPTY || renderThreadFrame.getStartUs() > mainThreadFrame.getEndUs() || renderThreadFrame.getStartUs() < mainThreadFrame.getStartUs()) {
                ++mainFramesIterator;
                continue;
            }
            mainThreadFrame.setAssociatedFrame(renderThreadFrame);
            renderThreadFrame.setAssociatedFrame(mainThreadFrame);
            ++mainFramesIterator;
            ++renderFramesIterator;
        }
    }

    @NotNull
    private List<AtraceFrame> getFramesList(String identifierRegEx, int threadId, long longFrameTimingUs, AtraceFrame.FrameThread frameThread) {
        ArrayList<AtraceFrame> frames = new ArrayList<AtraceFrame>();
        Optional<ThreadModel> activeThread = this.myProcessModel.getThreads().stream().filter(thread2 -> thread2.getId() == threadId).findFirst();
        if (!activeThread.isPresent()) {
            ArrayList<AtraceFrame> arrayList = frames;
            if (arrayList == null) {
                AtraceFrameManager.$$$reportNull$$$0(2);
            }
            return arrayList;
        }
        new SliceStream(activeThread.get().getSlices()).matchPattern(Pattern.compile(identifierRegEx)).enumerate(sliceGroup -> {
            AtraceFrame frame = new AtraceFrame(((ThreadModel)activeThread.get()).getId(), this.myBootClockSecondsToMonoUs, longFrameTimingUs, frameThread);
            double startTime = sliceGroup.getStartTime();
            double endTime = sliceGroup.getEndTime();
            frame.addSlice((SliceGroup)sliceGroup, new Range(startTime, endTime));
            frames.add(frame);
            return SliceStream.EnumerationResult.SKIP_CHILDREN;
        });
        ArrayList<AtraceFrame> arrayList = frames;
        if (arrayList == null) {
            AtraceFrameManager.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public List<AtraceFrame> buildFramesList(@NotNull AtraceFrameFilterConfig filter) {
        if (filter == null) {
            AtraceFrameManager.$$$reportNull$$$0(4);
        }
        if (filter.getThreadId() == this.myProcessModel.getId() && filter.getIdentifierRegEx() == "Choreographer#doFrame" && filter.getLongFrameTimingUs() == CpuFramesModel.SLOW_FRAME_RATE_US) {
            List<AtraceFrame> list = this.myMainThreadFrames;
            if (list == null) {
                AtraceFrameManager.$$$reportNull$$$0(5);
            }
            return list;
        }
        if (filter.getThreadId() == this.myRenderThreadId && filter.getIdentifierRegEx() == "(DrawFrame|doFrame|queueBuffer)" && filter.getLongFrameTimingUs() == CpuFramesModel.SLOW_FRAME_RATE_US) {
            List<AtraceFrame> list = this.myRenderThreadFrames;
            if (list == null) {
                AtraceFrameManager.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<AtraceFrame> list = this.getFramesList(filter.getIdentifierRegEx(), filter.getThreadId(), filter.getLongFrameTimingUs(), filter.getThreadId() == this.myProcessModel.getId() ? AtraceFrame.FrameThread.MAIN : (filter.getThreadId() == this.myRenderThreadId ? AtraceFrame.FrameThread.RENDER : AtraceFrame.FrameThread.OTHER));
        if (list == null) {
            AtraceFrameManager.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bootClockSecondsToMonoUs";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/atrace/AtraceFrameManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/atrace/AtraceFrameManager";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFramesList";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFramesList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildFramesList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

