/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

class TraceIdsIterator {
    static final int INVALID_TRACE_ID = -1;
    private final CpuProfilerStage myStage;
    private final List<Integer> myTraceIds;

    public TraceIdsIterator(CpuProfilerStage stage, List<CpuProfiler.TraceInfo> initialTraceInfo) {
        this.myStage = stage;
        this.myTraceIds = TraceIdsIterator.getOrderedInitialTraceIds(initialTraceInfo);
    }

    private static List<Integer> getOrderedInitialTraceIds(List<CpuProfiler.TraceInfo> initialTraceInfo) {
        ArrayList<CpuProfiler.TraceInfo> allTraceInfo = new ArrayList<CpuProfiler.TraceInfo>(initialTraceInfo);
        allTraceInfo.sort(Comparator.comparingLong(CpuProfiler.TraceInfo::getFromTimestamp));
        ArrayList<Integer> traceIds = new ArrayList<Integer>();
        allTraceInfo.forEach(traceInfo -> traceIds.add(traceInfo.getTraceId()));
        return traceIds;
    }

    public boolean hasNext() {
        return this.findNextTraceId() != -1;
    }

    public Integer next() {
        return this.findNextTraceId();
    }

    private int findNextTraceId() {
        if (this.myTraceIds.isEmpty()) {
            return -1;
        }
        if (this.myStage.getCapture() == null) {
            return this.myTraceIds.get(0);
        }
        int currentTraceIdIndex = this.myTraceIds.indexOf(this.myStage.getCapture().getTraceId());
        assert (currentTraceIdIndex >= 0);
        if (currentTraceIdIndex == this.myTraceIds.size() - 1) {
            return -1;
        }
        return this.myTraceIds.get(currentTraceIdIndex + 1);
    }

    public boolean hasPrevious() {
        return this.findPreviousTraceId() != -1;
    }

    public Integer previous() {
        return this.findPreviousTraceId();
    }

    private int findPreviousTraceId() {
        if (this.myTraceIds.isEmpty()) {
            return -1;
        }
        if (this.myStage.getCapture() == null) {
            return this.myTraceIds.get(this.myTraceIds.size() - 1);
        }
        int currentTraceIdIndex = this.myTraceIds.indexOf(this.myStage.getCapture().getTraceId());
        assert (currentTraceIdIndex >= 0);
        if (currentTraceIdIndex == 0) {
            return -1;
        }
        return this.myTraceIds.get(currentTraceIdIndex - 1);
    }

    public void addTrace(int traceId) {
        this.myTraceIds.add(traceId);
    }

    public boolean contains(int traceId) {
        return this.myTraceIds.contains(traceId);
    }
}

