/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import java.util.ArrayList;
import java.util.List;

abstract class InMemoryDataSeries<T>
implements DataSeries<T> {
    InMemoryDataSeries() {
    }

    public List<SeriesData<T>> getDataForXRange(Range xRange) {
        long min = (long)xRange.getMin();
        long max = (long)xRange.getMax();
        ArrayList<SeriesData<T>> series = new ArrayList<SeriesData<T>>();
        List<SeriesData<T>> seriesDataList = this.inMemoryDataList();
        if (seriesDataList.isEmpty()) {
            return series;
        }
        for (int i = 0; i < seriesDataList.size() - 1; ++i) {
            SeriesData<T> data = seriesDataList.get(i);
            SeriesData<T> nextData = seriesDataList.get(i + 1);
            if (data.x >= max) break;
            if (nextData.x <= min) continue;
            series.add(data);
        }
        SeriesData<T> lastElement = seriesDataList.get(seriesDataList.size() - 1);
        if (lastElement.x < max) {
            series.add(lastElement);
        }
        return series;
    }

    protected abstract List<SeriesData<T>> inMemoryDataList();
}

