/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DefaultDataSeries;
import com.android.tools.adtui.model.DefaultDurationData;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.EaseOutModel;
import com.android.tools.adtui.model.Interpolatable;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SelectionListener;
import com.android.tools.adtui.model.SelectionModel;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ClampedAxisComponentModel;
import com.android.tools.adtui.model.axis.ResizingAxisComponentModel;
import com.android.tools.adtui.model.filter.Filter;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.SingleUnitAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.UpdatableManager;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.android.tools.profiler.protobuf3jarjar.ByteString;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.analytics.FilterMetadata;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuCaptureMetadata;
import com.android.tools.profilers.cpu.CpuCaptureParser;
import com.android.tools.profilers.cpu.CpuFramesModel;
import com.android.tools.profilers.cpu.CpuKernelModel;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerConfigModel;
import com.android.tools.profilers.cpu.CpuProfilerNotifications;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.CpuThreadsModel;
import com.android.tools.profilers.cpu.CpuTraceInfo;
import com.android.tools.profilers.cpu.DetailedCpuUsage;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import com.android.tools.profilers.cpu.TraceIdsIterator;
import com.android.tools.profilers.cpu.atrace.AtraceCpuCapture;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.android.tools.profilers.cpu.capturedetails.CaptureModel;
import com.android.tools.profilers.event.EventMonitor;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuProfilerStage
extends Stage
implements CodeNavigator.Listener {
    private static final String HAS_USED_CPU_CAPTURE = "cpu.used.capture";
    private static final SingleUnitAxisFormatter CPU_USAGE_FORMATTER = new SingleUnitAxisFormatter(1, 5, 10, "%");
    private static final SingleUnitAxisFormatter NUM_THREADS_AXIS = new SingleUnitAxisFormatter(1, 5, 1, "");
    public static final int CPU_ART_STOP_TIMEOUT_SEC = Math.max(5, Math.min(Integer.getInteger("profiler.cpu.art.stop.timeout.sec", 5), 300));
    static final double IMPORTED_TRACE_VIEW_EXPAND_PERCENTAGE = 0.1;
    private static final CaptureDetails.Type DEFAULT_CAPTURE_DETAILS = CaptureDetails.Type.CALL_CHART;
    private final CpuThreadsModel myThreadsStates;
    private final CpuKernelModel myCpuKernelModel;
    private final ClampedAxisComponentModel myCpuUsageAxis;
    private final ClampedAxisComponentModel myThreadCountAxis;
    private final ResizingAxisComponentModel myTimeAxisGuide;
    private final DetailedCpuUsage myCpuUsage;
    private final CpuStageLegends myLegends;
    private final DurationDataModel<CpuTraceInfo> myTraceDurations;
    private final EventMonitor myEventMonitor;
    private final SelectionModel mySelectionModel;
    private final EaseOutModel myInstructionsEaseOutModel;
    private final CpuProfilerConfigModel myProfilerConfigModel;
    private final CpuFramesModel myFramesModel;
    private final DurationDataModel<CpuTraceInfo> myRecentTraceDurations;
    @NotNull
    private final DurationDataModel<DefaultDurationData> myInProgressTraceDuration;
    @NotNull
    private final DefaultDataSeries<DefaultDurationData> myInProgressTraceSeries;
    private CpuProfiler.TraceInitiationType myInProgressTraceInitiationType;
    @NotNull
    private final CpuTraceDataSeries myCpuTraceDataSeries;
    private final AspectModel<CpuProfilerAspect> myAspect;
    @NotNull
    private final CaptureModel myCaptureModel;
    @NotNull
    private CaptureState myCaptureState;
    private long myCaptureStartTimeNs;
    private CaptureElapsedTimeUpdatable myCaptureElapsedTimeUpdatable;
    private final CpuCaptureStateUpdatable myCaptureStateUpdatable;
    @NotNull
    private final UpdatableManager myUpdatableManager;
    private final CpuCaptureParser myCaptureParser;
    @NotNull
    private final TraceIdsIterator myTraceIdsIterator;
    private final boolean myIsImportTraceMode;
    @Nullable
    private File myImportedTrace;
    private Common.Session mySession;

    public CpuProfilerStage(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            CpuProfilerStage.$$$reportNull$$$0(0);
        }
        this(profilers, null);
    }

    public CpuProfilerStage(@NotNull StudioProfilers profilers, @Nullable File importedTrace) {
        if (profilers == null) {
            CpuProfilerStage.$$$reportNull$$$0(1);
        }
        this(profilers, importedTrace, new CpuCaptureParser(profilers.getIdeServices()));
    }

    @VisibleForTesting
    CpuProfilerStage(@NotNull StudioProfilers profilers, @Nullable File importedTrace, @NotNull CpuCaptureParser captureParser) {
        if (profilers == null) {
            CpuProfilerStage.$$$reportNull$$$0(2);
        }
        if (captureParser == null) {
            CpuProfilerStage.$$$reportNull$$$0(3);
        }
        super(profilers);
        this.myAspect = new AspectModel();
        this.myImportedTrace = importedTrace;
        this.mySession = profilers.getSession();
        this.myIsImportTraceMode = this.getStudioProfilers().getIdeServices().getFeatureConfig().isImportCpuTraceEnabled() && this.getStudioProfilers().getIdeServices().getFeatureConfig().isSessionsEnabled() && importedTrace != null;
        this.myCpuTraceDataSeries = new CpuTraceDataSeries();
        this.myProfilerConfigModel = new CpuProfilerConfigModel(profilers, this);
        Range viewRange = this.getStudioProfilers().getTimeline().getViewRange();
        Range dataRange = this.getStudioProfilers().getTimeline().getDataRange();
        Range selectionRange = this.getStudioProfilers().getTimeline().getSelectionRange();
        this.myCpuUsage = new DetailedCpuUsage(profilers);
        this.myCpuUsageAxis = new ClampedAxisComponentModel.Builder(this.myCpuUsage.getCpuRange(), (BaseAxisFormatter)CPU_USAGE_FORMATTER).build();
        this.myThreadCountAxis = new ClampedAxisComponentModel.Builder(this.myCpuUsage.getThreadRange(), (BaseAxisFormatter)NUM_THREADS_AXIS).build();
        this.myTimeAxisGuide = new ResizingAxisComponentModel.Builder(viewRange, (BaseAxisFormatter)TimeAxisFormatter.DEFAULT_WITHOUT_MINOR_TICKS).setGlobalRange(dataRange).build();
        this.myLegends = new CpuStageLegends(this.myCpuUsage, dataRange);
        this.myTraceDurations = new DurationDataModel(new RangedSeries(viewRange, (DataSeries)this.getCpuTraceDataSeries()));
        this.myThreadsStates = new CpuThreadsModel(viewRange, this, this.mySession);
        this.myCpuKernelModel = new CpuKernelModel(viewRange, this);
        this.myFramesModel = new CpuFramesModel(viewRange, this);
        this.myInProgressTraceSeries = new DefaultDataSeries();
        this.myInProgressTraceDuration = new DurationDataModel(new RangedSeries(viewRange, this.myInProgressTraceSeries));
        this.myInProgressTraceInitiationType = CpuProfiler.TraceInitiationType.UNSPECIFIED_INITIATION;
        this.myEventMonitor = new EventMonitor(profilers);
        this.mySelectionModel = this.buildSelectionModel(selectionRange);
        this.myInstructionsEaseOutModel = new EaseOutModel(profilers.getUpdater(), PROFILING_INSTRUCTIONS_EASE_OUT_NS);
        this.myCaptureState = CaptureState.IDLE;
        this.myCaptureElapsedTimeUpdatable = new CaptureElapsedTimeUpdatable();
        this.myCaptureStateUpdatable = new CpuCaptureStateUpdatable(() -> this.updateProfilingState(true));
        this.myCaptureModel = new CaptureModel(this);
        this.myUpdatableManager = new UpdatableManager(this.getStudioProfilers().getUpdater());
        this.myCaptureParser = captureParser;
        this.myTraceIdsIterator = new TraceIdsIterator(this, this.getTraceInfoFromRange(new Range(-1.7976931348623157E308, Double.MAX_VALUE)));
        this.myRecentTraceDurations = new DurationDataModel(new RangedSeries(new Range(-1.7976931348623157E308, Double.MAX_VALUE), (DataSeries)this.getCpuTraceDataSeries()));
        this.myRecentTraceDurations.addDependency((AspectObserver)this).onChange((Enum)DurationDataModel.Aspect.DURATION_DATA, () -> {
            Range xRange = this.myRecentTraceDurations.getSeries().getXRange();
            CpuTraceInfo candidateToSelect = null;
            List recentTraceInfo = this.myRecentTraceDurations.getSeries().getDataSeries().getDataForXRange(xRange);
            for (SeriesData series : recentTraceInfo) {
                CpuTraceInfo trace = (CpuTraceInfo)series.value;
                if (trace.getInitiationType().equals((Object)CpuProfiler.TraceInitiationType.INITIATED_BY_API) && !this.myTraceIdsIterator.contains(trace.getTraceId())) {
                    this.myTraceIdsIterator.addTrace(trace.getTraceId());
                    if (candidateToSelect == null || trace.getRange().getMax() > candidateToSelect.getRange().getMax()) {
                        candidateToSelect = trace;
                    }
                    this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCpuApiTracing(false, !trace.getTraceFilePath().isEmpty(), -1, -1, -1);
                }
                if (!(trace.getRange().getMax() > xRange.getMin())) continue;
                xRange.setMin(trace.getRange().getMax());
            }
            if (candidateToSelect != null) {
                this.setAndSelectCapture(candidateToSelect.getTraceId());
            }
        });
    }

    private static Logger getLogger() {
        return Logger.getInstance(CpuProfilerStage.class);
    }

    private SelectionModel buildSelectionModel(Range selectionRange) {
        SelectionModel selectionModel = new SelectionModel(selectionRange);
        selectionModel.addConstraint(this.myTraceDurations);
        if (this.myIsImportTraceMode) {
            selectionModel.addListener(new SelectionListener(){

                public void selectionCreated() {
                    CpuProfilerStage.this.getStudioProfilers().getIdeServices().getFeatureTracker().trackSelectRange();
                }

                public void selectionCleared() {
                    if (CpuProfilerStage.this.myCaptureModel.getCapture() != null) {
                        CpuProfilerStage.this.setAndSelectCapture(CpuProfilerStage.this.myCaptureModel.getCapture());
                    }
                }

                public void selectionCreationFailure() {
                    if (CpuProfilerStage.this.myCaptureModel.getCapture() != null) {
                        CpuProfilerStage.this.setAndSelectCapture(CpuProfilerStage.this.myCaptureModel.getCapture());
                    }
                }
            });
        } else {
            selectionModel.addListener(new SelectionListener(){

                public void selectionCreated() {
                    CpuProfilerStage.this.getStudioProfilers().getIdeServices().getFeatureTracker().trackSelectRange();
                    CpuProfilerStage.this.selectionChanged();
                }

                public void selectionCleared() {
                    CpuProfilerStage.this.selectionChanged();
                }

                public void selectionCreationFailure() {
                    CpuProfilerStage.this.selectionChanged();
                }
            });
        }
        return selectionModel;
    }

    public boolean isImportTraceMode() {
        return this.myIsImportTraceMode;
    }

    public boolean hasUserUsedCpuCapture() {
        return this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().getBoolean(HAS_USED_CPU_CAPTURE, false);
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        SelectionModel selectionModel = this.mySelectionModel;
        if (selectionModel == null) {
            CpuProfilerStage.$$$reportNull$$$0(4);
        }
        return selectionModel;
    }

    @NotNull
    public EaseOutModel getInstructionsEaseOutModel() {
        EaseOutModel easeOutModel = this.myInstructionsEaseOutModel;
        if (easeOutModel == null) {
            CpuProfilerStage.$$$reportNull$$$0(5);
        }
        return easeOutModel;
    }

    public AxisComponentModel getCpuUsageAxis() {
        return this.myCpuUsageAxis;
    }

    public AxisComponentModel getThreadCountAxis() {
        return this.myThreadCountAxis;
    }

    public AxisComponentModel getTimeAxisGuide() {
        return this.myTimeAxisGuide;
    }

    public DetailedCpuUsage getCpuUsage() {
        return this.myCpuUsage;
    }

    public CpuStageLegends getLegends() {
        return this.myLegends;
    }

    public DurationDataModel<CpuTraceInfo> getTraceDurations() {
        return this.myTraceDurations;
    }

    @NotNull
    public DurationDataModel<DefaultDurationData> getInProgressTraceDuration() {
        DurationDataModel<DefaultDurationData> durationDataModel = this.myInProgressTraceDuration;
        if (durationDataModel == null) {
            CpuProfilerStage.$$$reportNull$$$0(6);
        }
        return durationDataModel;
    }

    public String getName() {
        return "CPU";
    }

    public EventMonitor getEventMonitor() {
        return this.myEventMonitor;
    }

    @NotNull
    public CpuProfilerConfigModel getProfilerConfigModel() {
        CpuProfilerConfigModel cpuProfilerConfigModel = this.myProfilerConfigModel;
        if (cpuProfilerConfigModel == null) {
            CpuProfilerStage.$$$reportNull$$$0(7);
        }
        return cpuProfilerConfigModel;
    }

    @Override
    public void enter() {
        this.myEventMonitor.enter();
        this.getStudioProfilers().getUpdater().register((Updatable)this.myCpuUsage);
        this.getStudioProfilers().getUpdater().register(this.myInProgressTraceDuration);
        this.getStudioProfilers().getUpdater().register(this.myTraceDurations);
        this.getStudioProfilers().getUpdater().register(this.myRecentTraceDurations);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myCpuUsageAxis);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myThreadCountAxis);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myCaptureElapsedTimeUpdatable);
        if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isCpuApiTracingEnabled()) {
            this.getStudioProfilers().getUpdater().register((Updatable)this.myCaptureStateUpdatable);
        }
        this.getStudioProfilers().getIdeServices().getCodeNavigator().addListener(this);
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackEnterStage(this.getClass());
        this.getStudioProfilers().addDependency(this).onChange((Enum)ProfilerAspect.DEVICES, this.myProfilerConfigModel::updateProfilingConfigurations);
        this.updateProfilingState(false);
        this.myProfilerConfigModel.updateProfilingConfigurations();
        if (this.myIsImportTraceMode) {
            assert (this.myImportedTrace != null);
            this.parseAndSelectImportedTrace(this.myImportedTrace);
            this.setProfilerMode(ProfilerMode.EXPANDED);
        }
        if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isCpuNewRecordingWorkflowEnabled()) {
            this.setProfilerMode(ProfilerMode.EXPANDED);
        }
    }

    @Override
    public void exit() {
        this.myEventMonitor.exit();
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCpuUsage);
        this.getStudioProfilers().getUpdater().unregister(this.myTraceDurations);
        this.getStudioProfilers().getUpdater().unregister(this.myRecentTraceDurations);
        this.getStudioProfilers().getUpdater().unregister(this.myInProgressTraceDuration);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCpuUsageAxis);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myThreadCountAxis);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCaptureElapsedTimeUpdatable);
        if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isCpuApiTracingEnabled()) {
            this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCaptureStateUpdatable);
        }
        this.getStudioProfilers().getIdeServices().getCodeNavigator().removeListener(this);
        this.getStudioProfilers().removeDependencies(this);
        this.myCaptureParser.abortParsing();
        this.mySelectionModel.clearListeners();
        this.myUpdatableManager.releaseAll();
    }

    @NotNull
    public UpdatableManager getUpdatableManager() {
        UpdatableManager updatableManager = this.myUpdatableManager;
        if (updatableManager == null) {
            CpuProfilerStage.$$$reportNull$$$0(8);
        }
        return updatableManager;
    }

    public AspectModel<CpuProfilerAspect> getAspect() {
        return this.myAspect;
    }

    public void toggleCapturing() {
        if (this.myCaptureState == CaptureState.CAPTURING) {
            this.stopCapturing();
        } else {
            this.startCapturing();
        }
    }

    public void startCapturing() {
        ProfilingConfiguration config = this.myProfilerConfigModel.getProfilingConfiguration();
        CpuServiceGrpc.CpuServiceBlockingStub cpuService = this.getCpuClient();
        assert (this.getStudioProfilers().getProcess() != null);
        CpuProfiler.CpuProfilingAppStartRequest request = CpuProfiler.CpuProfilingAppStartRequest.newBuilder().setSession(this.mySession).setConfiguration(config.toProto()).setAbiCpuArch(this.getStudioProfilers().getProcess().getAbiCpuArch()).build();
        this.myInProgressTraceInitiationType = CpuProfiler.TraceInitiationType.INITIATED_BY_UI;
        if (config.isDisableLiveAllocation()) {
            this.getStudioProfilers().setMemoryLiveAllocationEnabled(false);
        }
        this.setCaptureState(CaptureState.STARTING);
        CompletableFuture.supplyAsync(() -> cpuService.startProfilingApp(request), this.getStudioProfilers().getIdeServices().getPoolExecutor()).thenAcceptAsync(response -> this.startCapturingCallback((CpuProfiler.CpuProfilingAppStartResponse)response, config), this.getStudioProfilers().getIdeServices().getMainExecutor());
        this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().setBoolean(HAS_USED_CPU_CAPTURE, true);
        this.myInstructionsEaseOutModel.setCurrentPercentage(1.0f);
    }

    private void startCapturingCallback(CpuProfiler.CpuProfilingAppStartResponse response, ProfilingConfiguration profilingConfiguration) {
        if (response.getStatus().equals((Object)CpuProfiler.CpuProfilingAppStartResponse.Status.SUCCESS)) {
            this.myProfilerConfigModel.setProfilingConfiguration(profilingConfiguration);
            this.setCaptureState(CaptureState.CAPTURING);
            this.myCaptureStartTimeNs = this.currentTimeNs();
            this.myInProgressTraceSeries.clear();
            this.myInProgressTraceSeries.add(TimeUnit.NANOSECONDS.toMicros(this.myCaptureStartTimeNs), (Object)new DefaultDurationData(Long.MAX_VALUE));
            this.getStudioProfilers().getTimeline().setStreaming(true);
        } else {
            CpuProfilerStage.getLogger().warn("Unable to start tracing: " + response.getStatus());
            CpuProfilerStage.getLogger().warn(response.getErrorMessage());
            this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.CAPTURE_START_FAILURE);
            this.setCaptureState(CaptureState.IDLE);
            this.setCapture(null);
        }
    }

    public void stopCapturing() {
        CpuServiceGrpc.CpuServiceBlockingStub cpuService = this.getCpuClient();
        CpuProfiler.CpuProfilingAppStopRequest request = CpuProfiler.CpuProfilingAppStopRequest.newBuilder().setProfilerType(this.myProfilerConfigModel.getProfilingConfiguration().getProfilerType()).setProfilerMode(this.myProfilerConfigModel.getProfilingConfiguration().getMode()).setSession(this.mySession).build();
        this.myInProgressTraceSeries.clear();
        long captureStartTimeUs = TimeUnit.NANOSECONDS.toMicros(this.myCaptureStartTimeNs);
        long currentTimeUs = TimeUnit.NANOSECONDS.toMicros(this.currentTimeNs());
        this.myInProgressTraceSeries.add(captureStartTimeUs, (Object)new DefaultDurationData(currentTimeUs - captureStartTimeUs));
        this.setCaptureState(CaptureState.STOPPING);
        CompletableFuture.supplyAsync(() -> cpuService.stopProfilingApp(request), this.getStudioProfilers().getIdeServices().getPoolExecutor()).thenAcceptAsync(this::stopCapturingCallback, this.getStudioProfilers().getIdeServices().getMainExecutor());
    }

    public long getCaptureElapsedTimeUs() {
        return TimeUnit.NANOSECONDS.toMicros(this.currentTimeNs() - this.myCaptureStartTimeNs);
    }

    private List<CpuProfiler.TraceInfo> getTraceInfoFromRange(Range rangeUs) {
        long rangeMinNs = TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMin());
        long rangeMaxNs = TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMax());
        CpuProfiler.GetTraceInfoResponse response = this.getCpuClient().getTraceInfo(CpuProfiler.GetTraceInfoRequest.newBuilder().setSession(this.mySession).setFromTimestamp(rangeMinNs).setToTimestamp(rangeMaxNs).build());
        return response.getTraceInfoList();
    }

    @NotNull
    public TraceIdsIterator getTraceIdsIterator() {
        TraceIdsIterator traceIdsIterator = this.myTraceIdsIterator;
        if (traceIdsIterator == null) {
            CpuProfilerStage.$$$reportNull$$$0(9);
        }
        return traceIdsIterator;
    }

    void navigateNext() {
        this.handleCaptureNavigation(this.myTraceIdsIterator.next());
    }

    void navigatePrevious() {
        this.handleCaptureNavigation(this.myTraceIdsIterator.previous());
    }

    private void handleCaptureNavigation(int traceId) {
        if (traceId == -1) {
            return;
        }
        this.setAndSelectCapture(traceId);
    }

    private void stopCapturingCallback(CpuProfiler.CpuProfilingAppStopResponse response) {
        CpuCaptureMetadata captureMetadata = new CpuCaptureMetadata(this.myProfilerConfigModel.getProfilingConfiguration());
        long estimateDurationMs = TimeUnit.NANOSECONDS.toMicros(this.currentTimeNs() - this.myCaptureStartTimeNs);
        captureMetadata.setCaptureDurationMs(estimateDurationMs);
        if (!response.getStatus().equals((Object)CpuProfiler.CpuProfilingAppStopResponse.Status.SUCCESS)) {
            CpuProfilerStage.getLogger().warn("Unable to stop tracing: " + response.getStatus());
            CpuProfilerStage.getLogger().warn(response.getErrorMessage());
            this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.CAPTURE_STOP_FAILURE);
            this.setCaptureState(CaptureState.IDLE);
            this.setCapture(null);
            captureMetadata.setStatus(CpuCaptureMetadata.CaptureStatus.STOP_CAPTURING_FAILURE);
            this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCaptureTrace(captureMetadata);
        } else {
            ByteString traceBytes = response.getTrace();
            captureMetadata.setTraceFileSizeBytes(traceBytes.size());
            this.handleCaptureParsing(response.getTraceId(), traceBytes, captureMetadata);
        }
        if (this.myProfilerConfigModel.getProfilingConfiguration().isDisableLiveAllocation()) {
            this.getStudioProfilers().setMemoryLiveAllocationEnabled(true);
        }
    }

    @NotNull
    public CpuCaptureParser getCaptureParser() {
        CpuCaptureParser cpuCaptureParser = this.myCaptureParser;
        if (cpuCaptureParser == null) {
            CpuProfilerStage.$$$reportNull$$$0(10);
        }
        return cpuCaptureParser;
    }

    private void parseAndSelectImportedTrace(@NotNull File traceFile) {
        if (traceFile == null) {
            CpuProfilerStage.$$$reportNull$$$0(11);
        }
        assert (this.myIsImportTraceMode);
        this.myCaptureParser.updateParsingStateWhenStarting();
        CompletableFuture<CpuCapture> capture = this.myCaptureParser.parse(traceFile);
        if (capture == null) {
            CpuProfilerStage.getLogger().info("Imported trace file was not parsed.");
            return;
        }
        Consumer<CpuCapture> parsingCallback = parsedCapture -> {
            if (parsedCapture != null) {
                ProfilerTimeline timeline = this.getStudioProfilers().getTimeline();
                Range captureRangeNs = new Range((double)TimeUnit.MICROSECONDS.toNanos((long)parsedCapture.getRange().getMin()), (double)TimeUnit.MICROSECONDS.toNanos((long)parsedCapture.getRange().getMax()));
                double expandAmountNs = 0.1 * captureRangeNs.getLength();
                timeline.reset((long)captureRangeNs.getMin(), (long)(captureRangeNs.getMax() + expandAmountNs));
                timeline.setIsPaused(true);
                this.myThreadsStates.buildImportedTraceThreads((CpuCapture)parsedCapture);
                this.setCaptureState(CaptureState.IDLE);
                this.setAndSelectCapture((CpuCapture)parsedCapture);
                double expandAmountUs = TimeUnit.NANOSECONDS.toMicros((long)expandAmountNs);
                timeline.getViewRange().set(parsedCapture.getRange().getMin() - expandAmountUs, parsedCapture.getRange().getMax() + expandAmountUs);
                this.setCaptureDetails(DEFAULT_CAPTURE_DETAILS);
                if (!this.myTraceIdsIterator.contains(42)) {
                    this.saveTraceInfo(42, (CpuCapture)parsedCapture, CpuProfiler.CpuProfilerMode.UNSPECIFIED_MODE);
                    this.myTraceIdsIterator.addTrace(42);
                }
                this.getStudioProfilers().getIdeServices().getFeatureTracker().trackImportTrace(parsedCapture.getType(), true);
            } else if (capture.isCancelled()) {
                this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.IMPORT_TRACE_PARSING_ABORTED);
            } else {
                this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.IMPORT_TRACE_PARSING_FAILURE);
                this.setCaptureState(CaptureState.IDLE);
                this.getStudioProfilers().getIdeServices().getFeatureTracker().trackImportTrace(CpuProfiler.CpuProfilerType.UNSPECIFIED_PROFILER, false);
            }
        };
        capture.handleAsync((parsedCapture, exception) -> {
            parsingCallback.accept((CpuCapture)parsedCapture);
            return parsedCapture;
        }, this.getStudioProfilers().getIdeServices().getMainExecutor());
    }

    private void handleCaptureParsing(int traceId, ByteString traceBytes, CpuCaptureMetadata captureMetadata) {
        long beforeParsingTime = System.currentTimeMillis();
        this.myCaptureParser.updateParsingStateWhenStarting();
        CompletableFuture<CpuCapture> capture = this.myCaptureParser.parse(this.mySession, traceId, traceBytes, this.myProfilerConfigModel.getProfilingConfiguration().getProfilerType());
        if (capture == null) {
            this.setCaptureState(CaptureState.IDLE);
            captureMetadata.setStatus(CpuCaptureMetadata.CaptureStatus.USER_ABORTED_PARSING);
            this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCaptureTrace(captureMetadata);
            return;
        }
        Consumer<CpuCapture> parsingCallback = parsedCapture -> {
            this.myInProgressTraceSeries.clear();
            if (parsedCapture != null) {
                this.setCaptureState(CaptureState.IDLE);
                this.setAndSelectCapture((CpuCapture)parsedCapture);
                this.setCaptureDetails(DEFAULT_CAPTURE_DETAILS);
                this.saveTraceInfo(traceId, (CpuCapture)parsedCapture, this.myProfilerConfigModel.getProfilingConfiguration().getMode());
                captureMetadata.setStatus(CpuCaptureMetadata.CaptureStatus.SUCCESS);
                captureMetadata.setParsingTimeMs(System.currentTimeMillis() - beforeParsingTime);
                captureMetadata.setCaptureDurationMs(TimeUnit.MICROSECONDS.toMillis(parsedCapture.getDurationUs()));
                captureMetadata.setRecordDurationMs(CpuProfilerStage.calculateRecordDurationMs(parsedCapture));
            } else if (capture.isCancelled()) {
                this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.PARSING_ABORTED);
            } else {
                captureMetadata.setStatus(CpuCaptureMetadata.CaptureStatus.PARSING_FAILURE);
                this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.PARSING_FAILURE);
                this.setCaptureState(CaptureState.IDLE);
                this.setCapture(null);
            }
            this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCaptureTrace(captureMetadata);
        };
        capture.handleAsync((parsedCapture, exception) -> {
            if (parsedCapture == null) {
                assert (exception != null);
                CpuProfilerStage.getLogger().warn("Unable to parse capture: " + exception.getMessage(), exception);
            }
            parsingCallback.accept((CpuCapture)parsedCapture);
            this.myTraceIdsIterator.addTrace(traceId);
            return parsedCapture;
        }, this.getStudioProfilers().getIdeServices().getMainExecutor());
    }

    private static long calculateRecordDurationMs(CpuCapture capture) {
        Range maxDataRange = new Range();
        for (CpuThreadInfo thread2 : capture.getThreads()) {
            CaptureNode threadMainNode = capture.getCaptureNode(thread2.getId());
            assert (threadMainNode != null);
            maxDataRange.expand((double)threadMainNode.getStartGlobal(), (double)threadMainNode.getEndGlobal());
        }
        return TimeUnit.MICROSECONDS.toMillis((long)maxDataRange.getLength());
    }

    private void saveTraceInfo(int traceId, @NotNull CpuCapture capture, CpuProfiler.CpuProfilerMode mode) {
        if (capture == null) {
            CpuProfilerStage.$$$reportNull$$$0(12);
        }
        long captureFrom = TimeUnit.MICROSECONDS.toNanos((long)capture.getRange().getMin());
        long captureTo = TimeUnit.MICROSECONDS.toNanos((long)capture.getRange().getMax());
        ArrayList<CpuProfiler.Thread> threads = new ArrayList<CpuProfiler.Thread>();
        for (CpuThreadInfo thread2 : capture.getThreads()) {
            threads.add(CpuProfiler.Thread.newBuilder().setTid(thread2.getId()).setName(thread2.getName()).build());
        }
        CpuProfiler.TraceInfo traceInfo = CpuProfiler.TraceInfo.newBuilder().setTraceId(traceId).setFromTimestamp(captureFrom).setToTimestamp(captureTo).setProfilerType(capture.getType()).setProfilerMode(mode).setTraceFilePath(Strings.nullToEmpty((String)this.myCaptureParser.getTraceFilePath(traceId))).addAllThreads(threads).build();
        CpuProfiler.SaveTraceInfoRequest request = CpuProfiler.SaveTraceInfoRequest.newBuilder().setSession(this.mySession).setTraceInfo(traceInfo).build();
        this.getCpuClient().saveTraceInfo(request);
    }

    private CpuProfiler.ProfilingStateResponse checkProfilingState() {
        CpuProfiler.ProfilingStateRequest request = CpuProfiler.ProfilingStateRequest.newBuilder().setSession(this.mySession).build();
        return this.getCpuClient().checkAppProfilingState(request);
    }

    @NotNull
    private CpuServiceGrpc.CpuServiceBlockingStub getCpuClient() {
        CpuServiceGrpc.CpuServiceBlockingStub cpuServiceBlockingStub = this.getStudioProfilers().getClient().getCpuClient();
        if (cpuServiceBlockingStub == null) {
            CpuProfilerStage.$$$reportNull$$$0(13);
        }
        return cpuServiceBlockingStub;
    }

    @VisibleForTesting
    void updateProfilingState(boolean calledFromUpdatable) {
        CpuProfiler.ProfilingStateResponse response = this.checkProfilingState();
        if (response.getBeingProfiled()) {
            if (response.getInitiationType() != CpuProfiler.TraceInitiationType.INITIATED_BY_API && calledFromUpdatable) {
                return;
            }
            ProfilingConfiguration configuration = ProfilingConfiguration.fromProto(response.getConfiguration());
            if (this.myCaptureState == CaptureState.IDLE) {
                if (response.getInitiationType() == CpuProfiler.TraceInitiationType.INITIATED_BY_STARTUP) {
                    this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCpuStartupProfiling(configuration);
                }
                this.myInProgressTraceInitiationType = response.getInitiationType();
                this.setCaptureState(CaptureState.CAPTURING);
                this.myCaptureStartTimeNs = response.getStartTimestamp();
                this.myInProgressTraceSeries.clear();
                this.myInProgressTraceSeries.add(TimeUnit.NANOSECONDS.toMicros(this.myCaptureStartTimeNs), (Object)new DefaultDurationData(Long.MAX_VALUE));
                this.getStudioProfilers().getTimeline().setStreaming(true);
                if (this.myInProgressTraceInitiationType == CpuProfiler.TraceInitiationType.INITIATED_BY_API) {
                    this.myAspect.changed((Enum)CpuProfilerAspect.PROFILING_CONFIGURATION);
                } else {
                    this.myProfilerConfigModel.setProfilingConfiguration(configuration);
                }
            }
        } else if (this.isApiInitiatedTracingInProgress()) {
            this.setCaptureState(CaptureState.IDLE);
            this.myInProgressTraceSeries.clear();
            this.myAspect.changed((Enum)CpuProfilerAspect.PROFILING_CONFIGURATION);
        }
    }

    private void selectionChanged() {
        CpuTraceInfo intersectingTraceInfo = this.getIntersectingTraceInfo(this.getStudioProfilers().getTimeline().getSelectionRange());
        if (intersectingTraceInfo == null) {
            this.setCapture(null);
        } else {
            this.setCapture(intersectingTraceInfo.getTraceId());
        }
    }

    @Nullable
    CpuTraceInfo getIntersectingTraceInfo(Range range) {
        List infoList = this.getTraceDurations().getSeries().getDataSeries().getDataForXRange(range);
        for (SeriesData info : infoList) {
            Range captureRange = ((CpuTraceInfo)info.value).getRange();
            if (captureRange.getIntersection(range).isEmpty()) continue;
            return (CpuTraceInfo)info.value;
        }
        return null;
    }

    private long currentTimeNs() {
        return TimeUnit.MICROSECONDS.toNanos((long)this.getStudioProfilers().getTimeline().getDataRange().getMax());
    }

    @VisibleForTesting
    public void setCapture(@Nullable CpuCapture capture) {
        if (!this.myCaptureModel.setCapture(capture)) {
            return;
        }
        if (capture != null) {
            this.setProfilerMode(ProfilerMode.EXPANDED);
            this.onCaptureSelection();
        }
    }

    private void onCaptureSelection() {
        CpuCapture capture = this.getCapture();
        if (capture == null) {
            return;
        }
        if (this.getCaptureState() == CaptureState.IDLE || this.getCaptureState() == CaptureState.CAPTURING) {
            this.ensureCaptureInViewRange();
            if (capture.getType() == CpuProfiler.CpuProfilerType.ATRACE && !this.isImportTraceMode() && ((AtraceCpuCapture)capture).isMissingData()) {
                this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.ATRACE_BUFFER_OVERFLOW);
            }
        }
    }

    private void ensureCaptureInViewRange() {
        CpuCapture capture = this.getCapture();
        assert (capture != null);
        ProfilerTimeline timeline = this.getStudioProfilers().getTimeline();
        double padding = timeline.getViewRange().getLength() * 0.05;
        timeline.adjustRangeCloseToMiddleView(new Range(capture.getRange().getMin() - padding, capture.getRange().getMax() + padding));
    }

    private void setCapture(int traceId) {
        CompletableFuture<CpuCapture> future = this.getCaptureFuture(traceId);
        if (future != null) {
            future.handleAsync((capture, exception) -> {
                this.setCaptureState(this.checkProfilingState().getBeingProfiled() ? CaptureState.CAPTURING : CaptureState.IDLE);
                this.setCapture((CpuCapture)capture);
                return capture;
            }, this.getStudioProfilers().getIdeServices().getMainExecutor());
        }
    }

    public void setAndSelectCapture(int traceId) {
        CompletableFuture<CpuCapture> future = this.getCaptureFuture(traceId);
        if (future != null) {
            future.handleAsync((capture, exception) -> {
                this.setCaptureState(this.checkProfilingState().getBeingProfiled() ? CaptureState.CAPTURING : CaptureState.IDLE);
                this.setAndSelectCapture((CpuCapture)capture);
                return capture;
            }, this.getStudioProfilers().getIdeServices().getMainExecutor());
        }
    }

    public void setAndSelectCapture(@NotNull CpuCapture capture) {
        if (capture == null) {
            CpuProfilerStage.$$$reportNull$$$0(14);
        }
        ProfilerTimeline timeline = this.getStudioProfilers().getTimeline();
        timeline.getSelectionRange().set(capture.getRange());
        this.setCapture(capture);
    }

    public int getSelectedThread() {
        return this.myCaptureModel.getThread();
    }

    public void setSelectedThread(int id) {
        this.myCaptureModel.setThread(id);
        Range range = this.getStudioProfilers().getTimeline().getSelectionRange();
        if (range.isEmpty()) {
            this.myAspect.changed((Enum)CpuProfilerAspect.SELECTED_THREADS);
            this.setProfilerMode(ProfilerMode.EXPANDED);
        }
    }

    @NotNull
    public List<ClockType> getClockTypes() {
        ImmutableList immutableList = ImmutableList.of((Object)ClockType.GLOBAL, (Object)ClockType.THREAD);
        if (immutableList == null) {
            CpuProfilerStage.$$$reportNull$$$0(15);
        }
        return immutableList;
    }

    @NotNull
    public ClockType getClockType() {
        ClockType clockType = this.myCaptureModel.getClockType();
        if (clockType == null) {
            CpuProfilerStage.$$$reportNull$$$0(16);
        }
        return clockType;
    }

    public void setClockType(@NotNull ClockType clockType) {
        if (clockType == null) {
            CpuProfilerStage.$$$reportNull$$$0(17);
        }
        this.myCaptureModel.setClockType(clockType);
    }

    @Nullable
    public CpuCapture getCapture() {
        return this.myCaptureModel.getCapture();
    }

    @NotNull
    public CaptureState getCaptureState() {
        CaptureState captureState = this.myCaptureState;
        if (captureState == null) {
            CpuProfilerStage.$$$reportNull$$$0(18);
        }
        return captureState;
    }

    @NotNull
    public CpuProfiler.TraceInitiationType getCaptureInitiationType() {
        CpuProfiler.TraceInitiationType traceInitiationType = this.myInProgressTraceInitiationType;
        if (traceInitiationType == null) {
            CpuProfilerStage.$$$reportNull$$$0(19);
        }
        return traceInitiationType;
    }

    public void setCaptureState(@NotNull CaptureState captureState) {
        if (captureState == null) {
            CpuProfilerStage.$$$reportNull$$$0(20);
        }
        if (!this.myCaptureState.equals((Object)captureState)) {
            this.myCaptureState = captureState;
            this.myAspect.changed((Enum)CpuProfilerAspect.CAPTURE_STATE);
            if (captureState == CaptureState.CAPTURING) {
                this.setProfilerMode(ProfilerMode.EXPANDED);
            }
        }
    }

    public void setCaptureFilter(@NotNull Filter filter) {
        if (filter == null) {
            CpuProfilerStage.$$$reportNull$$$0(21);
        }
        this.myCaptureModel.setFilter(filter);
        this.trackFilterUsage(filter);
    }

    @NotNull
    public Filter getCaptureFilter() {
        Filter filter = this.myCaptureModel.getFilter();
        if (filter == null) {
            CpuProfilerStage.$$$reportNull$$$0(22);
        }
        return filter;
    }

    public int getCaptureFilterNodeCount() {
        return this.myCaptureModel.getFilterNodeCount();
    }

    private void trackFilterUsage(@NotNull Filter filter) {
        CaptureDetails details;
        if (filter == null) {
            CpuProfilerStage.$$$reportNull$$$0(23);
        }
        if ((details = this.getCaptureDetails()) == null) {
            return;
        }
        FilterMetadata filterMetadata = new FilterMetadata();
        FeatureTracker featureTracker = this.getStudioProfilers().getIdeServices().getFeatureTracker();
        switch (details.getType()) {
            case TOP_DOWN: {
                filterMetadata.setView(FilterMetadata.View.CPU_TOP_DOWN);
                break;
            }
            case BOTTOM_UP: {
                filterMetadata.setView(FilterMetadata.View.CPU_BOTTOM_UP);
                break;
            }
            case CALL_CHART: {
                filterMetadata.setView(FilterMetadata.View.CPU_CALL_CHART);
                break;
            }
            case FLAME_CHART: {
                filterMetadata.setView(FilterMetadata.View.CPU_FLAME_CHART);
            }
        }
        filterMetadata.setFeaturesUsed(filter.isMatchCase(), filter.isRegex());
        filterMetadata.setMatchedElementCount(this.myCaptureModel.getFilterNodeCount());
        filterMetadata.setTotalElementCount(this.myCaptureModel.getNodeCount());
        filterMetadata.setFilterTextLength(filter.isEmpty() ? 0 : filter.getFilterString().length());
        featureTracker.trackFilterMetadata(filterMetadata);
    }

    public boolean isApiInitiatedTracingInProgress() {
        return this.myCaptureState == CaptureState.CAPTURING && this.getCaptureInitiationType().equals((Object)CpuProfiler.TraceInitiationType.INITIATED_BY_API);
    }

    @NotNull
    public CpuTraceDataSeries getCpuTraceDataSeries() {
        CpuTraceDataSeries cpuTraceDataSeries = this.myCpuTraceDataSeries;
        if (cpuTraceDataSeries == null) {
            CpuProfilerStage.$$$reportNull$$$0(24);
        }
        return cpuTraceDataSeries;
    }

    @NotNull
    public CpuThreadsModel getThreadStates() {
        CpuThreadsModel cpuThreadsModel = this.myThreadsStates;
        if (cpuThreadsModel == null) {
            CpuProfilerStage.$$$reportNull$$$0(25);
        }
        return cpuThreadsModel;
    }

    @NotNull
    public CpuKernelModel getCpuKernelModel() {
        CpuKernelModel cpuKernelModel = this.myCpuKernelModel;
        if (cpuKernelModel == null) {
            CpuProfilerStage.$$$reportNull$$$0(26);
        }
        return cpuKernelModel;
    }

    @NotNull
    public CpuFramesModel getFramesModel() {
        CpuFramesModel cpuFramesModel = this.myFramesModel;
        if (cpuFramesModel == null) {
            CpuProfilerStage.$$$reportNull$$$0(27);
        }
        return cpuFramesModel;
    }

    @VisibleForTesting
    @Nullable
    CompletableFuture<CpuCapture> getCaptureFuture(int traceId) {
        CompletableFuture<CpuCapture> capture = this.myCaptureParser.getCapture(traceId);
        if (capture == null) {
            this.myCaptureParser.updateParsingStateWhenStarting();
            this.setProfilerMode(ProfilerMode.EXPANDED);
            CpuProfiler.GetTraceRequest request = CpuProfiler.GetTraceRequest.newBuilder().setSession(this.mySession).setTraceId(traceId).build();
            CpuProfiler.GetTraceResponse trace = this.getCpuClient().getTrace(request);
            if (trace.getStatus() == CpuProfiler.GetTraceResponse.Status.SUCCESS) {
                capture = this.myCaptureParser.parse(this.mySession, traceId, trace.getData(), trace.getProfilerType());
            }
        }
        return capture;
    }

    public void setCaptureDetails(@Nullable CaptureDetails.Type type) {
        this.myCaptureModel.setDetails(type);
    }

    @Nullable
    public CaptureDetails getCaptureDetails() {
        return this.myCaptureModel.getDetails();
    }

    @Override
    public void onNavigated(@NotNull CodeLocation location) {
        if (location == null) {
            CpuProfilerStage.$$$reportNull$$$0(28);
        }
        this.setProfilerMode(ProfilerMode.NORMAL);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureParser";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuProfilerStage";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traceFile";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capture";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clockType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureState";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuProfilerStage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstructionsEaseOutModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInProgressTraceDuration";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilerConfigModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdatableManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraceIdsIterator";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaptureParser";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCpuClient";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getClockTypes";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getClockType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaptureState";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaptureInitiationType";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaptureFilter";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getCpuTraceDataSeries";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadStates";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getCpuKernelModel";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getFramesModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseAndSelectImportedTrace";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "saveTraceInfo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setAndSelectCapture";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setClockType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setCaptureState";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setCaptureFilter";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "trackFilterUsage";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "onNavigated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CpuStageLegends
    extends LegendComponentModel {
        @NotNull
        private final SeriesLegend myCpuLegend;
        @NotNull
        private final SeriesLegend myOthersLegend;
        @NotNull
        private final SeriesLegend myThreadsLegend;

        public CpuStageLegends(@NotNull DetailedCpuUsage cpuUsage, @NotNull Range dataRange) {
            if (cpuUsage == null) {
                CpuStageLegends.$$$reportNull$$$0(0);
            }
            if (dataRange == null) {
                CpuStageLegends.$$$reportNull$$$0(1);
            }
            super(dataRange);
            this.myCpuLegend = new SeriesLegend(cpuUsage.getCpuSeries(), (BaseAxisFormatter)CPU_USAGE_FORMATTER, dataRange);
            this.myOthersLegend = new SeriesLegend(cpuUsage.getOtherCpuSeries(), (BaseAxisFormatter)CPU_USAGE_FORMATTER, dataRange);
            this.myThreadsLegend = new SeriesLegend(cpuUsage.getThreadsCountSeries(), (BaseAxisFormatter)NUM_THREADS_AXIS, dataRange, Interpolatable.SteppedLineInterpolator);
            this.add((Legend)this.myCpuLegend);
            this.add((Legend)this.myOthersLegend);
            this.add((Legend)this.myThreadsLegend);
        }

        @NotNull
        public SeriesLegend getCpuLegend() {
            SeriesLegend seriesLegend = this.myCpuLegend;
            if (seriesLegend == null) {
                CpuStageLegends.$$$reportNull$$$0(2);
            }
            return seriesLegend;
        }

        @NotNull
        public SeriesLegend getOthersLegend() {
            SeriesLegend seriesLegend = this.myOthersLegend;
            if (seriesLegend == null) {
                CpuStageLegends.$$$reportNull$$$0(3);
            }
            return seriesLegend;
        }

        @NotNull
        public SeriesLegend getThreadsLegend() {
            SeriesLegend seriesLegend = this.myThreadsLegend;
            if (seriesLegend == null) {
                CpuStageLegends.$$$reportNull$$$0(4);
            }
            return seriesLegend;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cpuUsage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataRange";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/CpuProfilerStage$CpuStageLegends";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/CpuProfilerStage$CpuStageLegends";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCpuLegend";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOthersLegend";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getThreadsLegend";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @VisibleForTesting
    class CpuTraceDataSeries
    implements DataSeries<CpuTraceInfo> {
        CpuTraceDataSeries() {
        }

        public List<SeriesData<CpuTraceInfo>> getDataForXRange(Range xRange) {
            List traceInfo = CpuProfilerStage.this.getTraceInfoFromRange(xRange);
            ArrayList<SeriesData<CpuTraceInfo>> seriesData = new ArrayList<SeriesData<CpuTraceInfo>>();
            for (CpuProfiler.TraceInfo protoTraceInfo : traceInfo) {
                CpuTraceInfo info = new CpuTraceInfo(protoTraceInfo);
                seriesData.add((SeriesData<CpuTraceInfo>)new SeriesData((long)info.getRange().getMin(), (Object)info));
            }
            return seriesData;
        }
    }

    @VisibleForTesting
    static class CpuCaptureStateUpdatable
    implements Updatable {
        @NotNull
        private final Runnable myCallback;
        @VisibleForTesting
        static final int UPDATE_COUNT_TO_CALL_CALLBACK = 6;
        private int myUpdateCount;

        public CpuCaptureStateUpdatable(@NotNull Runnable callback) {
            if (callback == null) {
                CpuCaptureStateUpdatable.$$$reportNull$$$0(0);
            }
            this.myUpdateCount = 0;
            this.myCallback = callback;
        }

        public void update(long elapsedNs) {
            if (this.myUpdateCount++ >= 6) {
                this.myCallback.run();
                this.myUpdateCount = 0;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/android/tools/profilers/cpu/CpuProfilerStage$CpuCaptureStateUpdatable", "<init>"));
        }
    }

    private class CaptureElapsedTimeUpdatable
    implements Updatable {
        private CaptureElapsedTimeUpdatable() {
        }

        public void update(long elapsedNs) {
            if (CpuProfilerStage.this.myCaptureState == CaptureState.CAPTURING || CpuProfilerStage.this.myCaptureParser.isParsing()) {
                CpuProfilerStage.this.myAspect.changed((Enum)CpuProfilerAspect.CAPTURE_ELAPSED_TIME);
            }
        }
    }

    public static enum CaptureState {
        IDLE,
        CAPTURING,
        STARTING,
        STOPPING;

    }

    public static enum ThreadState {
        RUNNING,
        RUNNING_CAPTURED,
        SLEEPING,
        SLEEPING_CAPTURED,
        DEAD,
        DEAD_CAPTURED,
        WAITING,
        WAITING_CAPTURED,
        HAS_ACTIVITY,
        NO_ACTIVITY,
        RUNNABLE_CAPTURED,
        WAITING_IO_CAPTURED,
        UNKNOWN;

    }
}

