/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class CpuProfilerConfigModel {
    private static final String LAST_SELECTED_CONFIGURATION_NAME = "last.selected.configuration.name";
    private ProfilingConfiguration myProfilingConfiguration;
    @NotNull
    private List<ProfilingConfiguration> myCustomProfilingConfigurations;
    @NotNull
    private List<ProfilingConfiguration> myCustomProfilingConfigurationsDeviceFiltered;
    @NotNull
    private List<ProfilingConfiguration> myDefaultProfilingConfigurations;
    @NotNull
    private final StudioProfilers myProfilers;
    @NotNull
    private CpuProfilerStage myProfilerStage;
    private AspectObserver myAspectObserver;

    public CpuProfilerConfigModel(@NotNull StudioProfilers profilers, @NotNull CpuProfilerStage profilerStage) {
        if (profilers == null) {
            CpuProfilerConfigModel.$$$reportNull$$$0(0);
        }
        if (profilerStage == null) {
            CpuProfilerConfigModel.$$$reportNull$$$0(1);
        }
        this.myProfilers = profilers;
        this.myProfilerStage = profilerStage;
        this.myCustomProfilingConfigurations = new ArrayList<ProfilingConfiguration>();
        this.myCustomProfilingConfigurationsDeviceFiltered = new ArrayList<ProfilingConfiguration>();
        this.myDefaultProfilingConfigurations = new ArrayList<ProfilingConfiguration>();
        this.myAspectObserver = new AspectObserver();
        this.myProfilerStage.getAspect().addDependency(this.myAspectObserver).onChange((Enum)CpuProfilerAspect.PROFILING_CONFIGURATION, this::updateProfilingConfigurations);
    }

    @NotNull
    public ProfilingConfiguration getProfilingConfiguration() {
        ProfilingConfiguration profilingConfiguration = this.myProfilingConfiguration;
        if (profilingConfiguration == null) {
            CpuProfilerConfigModel.$$$reportNull$$$0(2);
        }
        return profilingConfiguration;
    }

    public void setProfilingConfiguration(@NotNull ProfilingConfiguration configuration) {
        if (configuration == null) {
            CpuProfilerConfigModel.$$$reportNull$$$0(3);
        }
        this.myProfilingConfiguration = configuration;
        this.myProfilerStage.getAspect().changed((Enum)CpuProfilerAspect.PROFILING_CONFIGURATION);
        this.myProfilers.getIdeServices().getTemporaryProfilerPreferences().setValue(LAST_SELECTED_CONFIGURATION_NAME, configuration.getName());
    }

    @NotNull
    public List<ProfilingConfiguration> getCustomProfilingConfigurations() {
        List<ProfilingConfiguration> list = this.myCustomProfilingConfigurations;
        if (list == null) {
            CpuProfilerConfigModel.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<ProfilingConfiguration> getCustomProfilingConfigurationsDeviceFiltered() {
        List<ProfilingConfiguration> list = this.myCustomProfilingConfigurationsDeviceFiltered;
        if (list == null) {
            CpuProfilerConfigModel.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<ProfilingConfiguration> getDefaultProfilingConfigurations() {
        List<ProfilingConfiguration> list = this.myDefaultProfilingConfigurations;
        if (list == null) {
            CpuProfilerConfigModel.$$$reportNull$$$0(6);
        }
        return list;
    }

    public void updateProfilingConfigurations() {
        boolean isSimpleperfEnabled;
        List<ProfilingConfiguration> savedConfigs = this.myProfilers.getIdeServices().getUserCpuProfilerConfigs();
        this.myCustomProfilingConfigurations = this.filterConfigurations(savedConfigs, false);
        this.myCustomProfilingConfigurationsDeviceFiltered = this.filterConfigurations(savedConfigs, true);
        List<ProfilingConfiguration> defaultConfigs = this.myProfilers.getIdeServices().getDefaultCpuProfilerConfigs();
        this.myDefaultProfilingConfigurations = this.filterConfigurations(defaultConfigs, true);
        Common.Device selectedDevice = this.myProfilers.getDevice();
        boolean bl = isSimpleperfEnabled = selectedDevice != null && selectedDevice.getFeatureLevel() >= 26;
        if (this.myProfilingConfiguration == null) {
            String selectedConfigName = this.myProfilers.getIdeServices().getTemporaryProfilerPreferences().getValue(LAST_SELECTED_CONFIGURATION_NAME, "");
            ProfilingConfiguration selectedConfig = Stream.concat(defaultConfigs.stream(), savedConfigs.stream()).filter(c -> c.getName().equals(selectedConfigName)).findFirst().orElse(null);
            this.myProfilingConfiguration = selectedConfig != null ? selectedConfig : (this.myProfilers.getIdeServices().isNativeProfilingConfigurationPreferred() && isSimpleperfEnabled ? (ProfilingConfiguration)Iterables.find(defaultConfigs, pref -> pref != null && pref.getProfilerType() == CpuProfiler.CpuProfilerType.SIMPLEPERF) : (ProfilingConfiguration)Iterables.find(defaultConfigs, pref -> pref != null && pref.getProfilerType() == CpuProfiler.CpuProfilerType.ART && pref.getMode() == CpuProfiler.CpuProfilerMode.SAMPLED));
        }
    }

    private List<ProfilingConfiguration> filterConfigurations(List<ProfilingConfiguration> configurations, boolean filterOnDevice) {
        Common.Device selectedDevice = this.myProfilers.getDevice();
        Predicate<ProfilingConfiguration> filter = pref -> {
            if (selectedDevice != null && pref.getRequiredDeviceLevel() > selectedDevice.getFeatureLevel() && filterOnDevice) {
                return false;
            }
            if (pref.getProfilerType() == CpuProfiler.CpuProfilerType.ATRACE) {
                return this.myProfilers.getIdeServices().getFeatureConfig().isAtraceEnabled();
            }
            return true;
        };
        return configurations.stream().filter(filter).collect(Collectors.toList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilerStage";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuProfilerConfigModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuProfilerConfigModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilingConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomProfilingConfigurations";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomProfilingConfigurationsDeviceFiltered";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProfilingConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setProfilingConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

