/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.ProfilerTooltipView;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuProfilerStageView;
import com.android.tools.profilers.cpu.atrace.CpuKernelTooltip;
import com.android.tools.profilers.cpu.atrace.CpuThreadSliceInfo;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jetbrains.annotations.NotNull;

public class CpuKernelTooltipView
extends ProfilerTooltipView {
    @NotNull
    private final CpuKernelTooltip myTooltip;
    @NotNull
    private final ProfilerTimeline myTimeline;
    private final int myProcessId;
    @NotNull
    private final JPanel myContent;
    @NotNull
    private final JLabel myThread;
    @NotNull
    private final JLabel myProcess;
    @NotNull
    private final JLabel myDuration;
    @NotNull
    private final JLabel myCpu;
    @NotNull
    private final JPanel myUnavailableDetails;

    protected CpuKernelTooltipView(@NotNull CpuProfilerStageView view, @NotNull CpuKernelTooltip tooltip) {
        if (view == null) {
            CpuKernelTooltipView.$$$reportNull$$$0(0);
        }
        if (tooltip == null) {
            CpuKernelTooltipView.$$$reportNull$$$0(1);
        }
        super(view.getTimeline());
        this.myProcessId = ((CpuProfilerStage)view.getStage()).getStudioProfilers().getSession().getPid();
        this.myTimeline = view.getTimeline();
        this.myTooltip = tooltip;
        this.myContent = new JPanel((LayoutManager)new TabularLayout("*").setVGap(JBUIScale.scale((int)8)));
        this.myThread = CpuKernelTooltipView.createTooltipLabel();
        this.myProcess = CpuKernelTooltipView.createTooltipLabel();
        this.myDuration = CpuKernelTooltipView.createTooltipLabel();
        this.myCpu = CpuKernelTooltipView.createTooltipLabel();
        this.myUnavailableDetails = new JPanel((LayoutManager)new TabularLayout("*").setVGap(JBUIScale.scale((int)1)));
        tooltip.addDependency(this).onChange((Enum)CpuKernelTooltip.Aspect.CPU_KERNEL_THREAD_SLICE_INFO, this::threadSliceInfoChanged);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myTooltip.removeDependencies(this);
    }

    private void addRow(JPanel parent, JComponent c) {
        int nextRow = parent.getComponentCount();
        parent.add((Component)c, new TabularLayout.Constraint(nextRow, 0));
    }

    private void threadSliceInfoChanged() {
        Range range = this.myTimeline.getTooltipRange();
        CpuThreadSliceInfo threadSlice = this.myTooltip.getCpuThreadSliceInfo();
        this.myContent.removeAll();
        if (range.isEmpty() || threadSlice == null) {
            return;
        }
        this.myThread.setText(String.format("Thread: %s", threadSlice.getName()));
        this.addRow(this.myContent, this.myThread);
        this.myProcess.setText(String.format("Process: %s", threadSlice.getProcessName()));
        this.addRow(this.myContent, this.myProcess);
        this.myDuration.setText(String.format("Duration: %s", TimeFormatter.getSingleUnitDurationString((long)threadSlice.getDurationUs())));
        this.addRow(this.myContent, this.myDuration);
        this.myCpu.setText(String.format("CPU: %d", this.myTooltip.getCpuId()));
        this.addRow(this.myContent, this.myCpu);
        if (this.myProcessId != threadSlice.getProcessId()) {
            this.addRow(this.myContent, this.myUnavailableDetails);
        }
    }

    @Override
    @NotNull
    protected JComponent createTooltip() {
        JSeparator separator = new JSeparator(0);
        separator.setMinimumSize(separator.getPreferredSize());
        this.addRow(this.myUnavailableDetails, separator);
        JLabel unavailableLabel = new JLabel("Other (not selectable)");
        unavailableLabel.setFont(ProfilerFonts.TOOLTIP_BODY_FONT);
        unavailableLabel.setForeground(ProfilerColors.TOOLTIP_LOW_CONTRAST);
        this.addRow(this.myUnavailableDetails, unavailableLabel);
        this.addRow(this.myContent, this.myUnavailableDetails);
        JPanel jPanel = this.myContent;
        if (jPanel == null) {
            CpuKernelTooltipView.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuKernelTooltipView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuKernelTooltipView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

