/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.HoverRowTable;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ResizingAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerTimeline;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public final class TimelineTable {
    private static final int HEADER_HEIGHT = 20;
    private static final int TIMELINE_HEIGHT = 14;

    @NotNull
    public static JBTable create(@NotNull TableModel model, @NotNull ProfilerTimeline timeline, int column) {
        if (model == null) {
            TimelineTable.$$$reportNull$$$0(0);
        }
        if (timeline == null) {
            TimelineTable.$$$reportNull$$$0(1);
        }
        HoverRowTable table = new HoverRowTable(model);
        table.getTableHeader().setDefaultRenderer(new HeaderRenderer((JTable)table, timeline, column));
        boolean[] lastIsEmpty = new boolean[]{true};
        table.getModel().addTableModelListener(new TableModelListener((JBTable)table, lastIsEmpty){
            final /* synthetic */ JBTable val$table;
            final /* synthetic */ boolean[] val$lastIsEmpty;
            {
                this.val$table = jBTable;
                this.val$lastIsEmpty = blArray;
            }

            @Override
            public void tableChanged(TableModelEvent e) {
                boolean isEmpty;
                boolean bl = isEmpty = this.val$table.getRowCount() == 0;
                if (this.val$lastIsEmpty[0] != isEmpty) {
                    this.val$lastIsEmpty[0] = isEmpty;
                    this.val$table.getTableHeader().resizeAndRepaint();
                }
            }
        });
        HoverRowTable hoverRowTable = table;
        if (hoverRowTable == null) {
            TimelineTable.$$$reportNull$$$0(2);
        }
        return hoverRowTable;
    }

    @NotNull
    private static AxisComponent createAxis(@NotNull ProfilerTimeline timeline) {
        if (timeline == null) {
            TimelineTable.$$$reportNull$$$0(3);
        }
        ResizingAxisComponentModel model = new ResizingAxisComponentModel.Builder(timeline.getSelectionRange(), (BaseAxisFormatter)new TimeAxisFormatter(1, 5, 1)).setGlobalRange(timeline.getDataRange()).build();
        AxisComponent axis = new AxisComponent((AxisComponentModel)model, AxisComponent.AxisOrientation.BOTTOM);
        axis.setShowAxisLine(false);
        axis.setMarkerColor(ProfilerColors.AXIS_MARKER_COLOR);
        AxisComponent axisComponent = axis;
        if (axisComponent == null) {
            TimelineTable.$$$reportNull$$$0(4);
        }
        return axisComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeline";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/TimelineTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/TimelineTable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createAxis";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createAxis";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class GridBorder
    implements Border {
        private final Color myColor;

        public GridBorder(@NotNull JTable table) {
            if (table == null) {
                GridBorder.$$$reportNull$$$0(0);
            }
            this.myColor = table.getGridColor();
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(this.myColor);
            int xRight = x + width - 1;
            g.drawLine(xRight, y, xRight, y + height);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return JBUI.emptyInsets();
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/android/tools/profilers/TimelineTable$GridBorder", "<init>"));
        }
    }

    public static abstract class CellRenderer
    implements TableCellRenderer {
        private ProfilerTimeline myTimeline;

        public CellRenderer(@NotNull ProfilerTimeline timeline) {
            if (timeline == null) {
                CellRenderer.$$$reportNull$$$0(0);
            }
            this.myTimeline = timeline;
        }

        @Override
        public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JPanel panel = new JPanel((LayoutManager)new TabularLayout("*", "*"));
            panel.add(this.getTableCellRendererComponent(isSelected, row), new TabularLayout.Constraint(0, 0));
            AxisComponent axisTicks = TimelineTable.createAxis(this.myTimeline);
            axisTicks.setShowLabels(false);
            axisTicks.setMarkerLengths(table.getRowHeight(), 0);
            panel.add((Component)axisTicks, new TabularLayout.Constraint(0, 0));
            return panel;
        }

        @NotNull
        protected final ProfilerTimeline getTimeline() {
            ProfilerTimeline profilerTimeline = this.myTimeline;
            if (profilerTimeline == null) {
                CellRenderer.$$$reportNull$$$0(1);
            }
            return profilerTimeline;
        }

        @NotNull
        protected abstract Component getTableCellRendererComponent(boolean var1, int var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "timeline";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/TimelineTable$CellRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/TimelineTable$CellRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTimeline";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class HeaderRenderer
    implements TableCellRenderer {
        @NotNull
        private final TableCellRenderer myDelegateRenderer;
        @NotNull
        private final ProfilerTimeline myTimeline;
        private int myTimelineColumn;

        private HeaderRenderer(@NotNull JTable table, @NotNull ProfilerTimeline timeline, int timelineColumn) {
            if (table == null) {
                HeaderRenderer.$$$reportNull$$$0(0);
            }
            if (timeline == null) {
                HeaderRenderer.$$$reportNull$$$0(1);
            }
            this.myDelegateRenderer = table.getTableHeader().getDefaultRenderer();
            this.myTimeline = timeline;
            this.myTimelineColumn = timelineColumn;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent headerComponent = (JComponent)this.myDelegateRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (headerComponent instanceof JLabel) {
                headerComponent.setBorder(ProfilerLayout.TABLE_COLUMN_HEADER_BORDER);
                ((JLabel)headerComponent).setHorizontalAlignment(2);
            }
            if (table.getRowCount() == 0) {
                return headerComponent;
            }
            JPanel rendererPanel = new JPanel((LayoutManager)new TabularLayout("*", String.format("%dpx,%dpx", 20, 14)));
            rendererPanel.setOpaque(false);
            headerComponent.setOpaque(false);
            JPanel axisPanel = new JPanel(new BorderLayout());
            axisPanel.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
            if (column == this.myTimelineColumn) {
                AxisComponent header = TimelineTable.createAxis(this.myTimeline);
                header.setShowAxisLine(false);
                header.setMarkerLengths(14, 0);
                axisPanel.add((Component)header);
            } else {
                JComponent separator = AdtUiUtils.createHorizontalSeparator();
                separator.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
                axisPanel.add(separator);
            }
            axisPanel.setBorder(new GridBorder(table));
            rendererPanel.add((Component)headerComponent, new TabularLayout.Constraint(0, 0));
            rendererPanel.add((Component)axisPanel, new TabularLayout.Constraint(1, 0));
            return rendererPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "table";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "timeline";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/profilers/TimelineTable$HeaderRenderer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

