/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.flat.FlatComboBox;
import com.android.tools.adtui.flat.FlatSeparator;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.stdui.CommonButton;
import com.android.tools.adtui.stdui.CommonToggleButton;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profilers.ContextMenuInstaller;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.JComboBoxView;
import com.android.tools.profilers.NullMonitorStage;
import com.android.tools.profilers.NullMonitorStageView;
import com.android.tools.profilers.ProfilerAction;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerContextMenu;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerLayeredPane;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.StudioMonitorStage;
import com.android.tools.profilers.StudioMonitorStageView;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.ViewBinder;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuProfilerStageView;
import com.android.tools.profilers.energy.EnergyProfilerStage;
import com.android.tools.profilers.energy.EnergyProfilerStageView;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.MemoryProfilerStageView;
import com.android.tools.profilers.network.NetworkProfilerStage;
import com.android.tools.profilers.network.NetworkProfilerStageView;
import com.android.tools.profilers.sessions.SessionAspect;
import com.android.tools.profilers.sessions.SessionsView;
import com.android.tools.profilers.stacktrace.ContextMenuItem;
import com.android.tools.profilers.stacktrace.LoadingPanel;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.function.BiFunction;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class StudioProfilersView
extends AspectObserver
implements Disposable {
    private static final String LOADING_VIEW_CARD = "LoadingViewCard";
    private static final String STAGE_VIEW_CARD = "StageViewCard";
    private static final int SHORTCUT_MODIFIER_MASK_NUMBER = SystemInfo.isMac ? 256 : 128;
    @NotNull
    public static final String ATTACH_LIVE = "Attach to live";
    @NotNull
    public static final String DETACH_LIVE = "Detach live";
    @NotNull
    public static final String ZOOM_IN = "Zoom in";
    @NotNull
    public static final String ZOOM_OUT = "Zoom out";
    private final StudioProfilers myProfiler;
    private final ViewBinder<StudioProfilersView, Stage, StageView> myBinder;
    private StageView myStageView;
    @NotNull
    private final ProfilerLayeredPane myLayeredPane;
    @NotNull
    private final ThreeComponentsSplitter mySplitter;
    @NotNull
    private final LoadingPanel myStageLoadingPanel;
    private final JPanel myStageComponent;
    private final JPanel myStageCenterComponent;
    private final CardLayout myStageCenterCardLayout;
    private SessionsView mySessionsView;
    private JPanel myToolbar;
    private JPanel myStageToolbar;
    private JPanel myMonitoringToolbar;
    private JPanel myCommonToolbar;
    private JPanel myGoLiveToolbar;
    private JToggleButton myGoLive;
    private CommonButton myZoomOut;
    private CommonButton myZoomIn;
    private CommonButton myResetZoom;
    private CommonButton myFrameSelection;
    private ProfilerAction myFrameSelectionAction;
    @NotNull
    private final IdeProfilerComponents myIdeProfilerComponents;

    public StudioProfilersView(@NotNull StudioProfilers profiler, @NotNull IdeProfilerComponents ideProfilerComponents) {
        if (profiler == null) {
            StudioProfilersView.$$$reportNull$$$0(0);
        }
        if (ideProfilerComponents == null) {
            StudioProfilersView.$$$reportNull$$$0(1);
        }
        this.myProfiler = profiler;
        this.myIdeProfilerComponents = ideProfilerComponents;
        this.myStageView = null;
        this.myStageComponent = new JPanel(new BorderLayout());
        this.myStageCenterCardLayout = new CardLayout();
        this.myStageCenterComponent = new JPanel(this.myStageCenterCardLayout);
        this.myStageLoadingPanel = this.myIdeProfilerComponents.createLoadingPanel(0);
        this.myStageLoadingPanel.setLoadingText("");
        this.myStageLoadingPanel.getComponent().setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        this.mySplitter = new ThreeComponentsSplitter();
        this.mySplitter.setFocusTraversalPolicy((FocusTraversalPolicy)new LayoutFocusTraversalPolicy());
        this.mySplitter.setDividerWidth(0);
        this.mySplitter.setDividerMouseZoneSize(-1);
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.mySplitter.setLastComponent((JComponent)this.myStageComponent);
        Disposer.register((Disposable)this, (Disposable)this.mySplitter);
        this.myLayeredPane = new ProfilerLayeredPane((JComponent)this.mySplitter);
        if (this.myProfiler.getIdeServices().getFeatureConfig().isSessionsEnabled()) {
            this.mySessionsView = new SessionsView(this.myProfiler, ideProfilerComponents);
            final JComponent sessionsComponent = this.mySessionsView.getComponent();
            this.mySplitter.setFirstComponent(sessionsComponent);
            this.mySessionsView.addExpandListener(e -> {
                this.toggleSessionsPanel(false);
                this.myProfiler.getIdeServices().getFeatureTracker().trackSessionsPanelStateChanged(true);
            });
            this.mySessionsView.addCollapseListener(e -> {
                this.toggleSessionsPanel(true);
                this.myProfiler.getIdeServices().getFeatureTracker().trackSessionsPanelStateChanged(false);
            });
            boolean initiallyCollapsed = this.myProfiler.getIdeServices().getPersistentProfilerPreferences().getBoolean("SESSION_IS_COLLAPSED", false);
            this.toggleSessionsPanel(initiallyCollapsed);
            new UiNotifyConnector.Once((Component)this.mySplitter, (Activatable)new Activatable.Adapter(){

                public void showNotify() {
                    IdeGlassPane glassPane = IdeGlassPaneUtil.find((Component)StudioProfilersView.this.mySplitter);
                    glassPane.addMousePreprocessor((MouseListener)new MouseAdapter(){
                        private int mySessionsUiWidth;

                        @Override
                        public void mousePressed(MouseEvent e) {
                            this.mySessionsUiWidth = sessionsComponent.getWidth();
                        }

                        @Override
                        public void mouseReleased(MouseEvent e) {
                            int width = sessionsComponent.getWidth();
                            if (this.mySessionsUiWidth != width) {
                                StudioProfilersView.this.myProfiler.getIdeServices().getPersistentProfilerPreferences().setInt("SESSION_EXPANDED_WIDTH", width);
                                StudioProfilersView.this.myProfiler.getIdeServices().getFeatureTracker().trackSessionsPanelResized();
                            }
                        }
                    }, (Disposable)StudioProfilersView.this.mySplitter);
                }
            });
        }
        this.initializeStageUi();
        this.myBinder = new ViewBinder();
        this.myBinder.bind(StudioMonitorStage.class, StudioMonitorStageView::new);
        this.myBinder.bind(CpuProfilerStage.class, CpuProfilerStageView::new);
        this.myBinder.bind(MemoryProfilerStage.class, MemoryProfilerStageView::new);
        this.myBinder.bind(NetworkProfilerStage.class, NetworkProfilerStageView::new);
        this.myBinder.bind(NullMonitorStage.class, NullMonitorStageView::new);
        this.myBinder.bind(EnergyProfilerStage.class, EnergyProfilerStageView::new);
        this.myProfiler.addDependency(this).onChange((Enum)ProfilerAspect.STAGE, this::updateStageView).onChange((Enum)ProfilerAspect.AGENT, this::toggleStageLayout).onChange((Enum)ProfilerAspect.PREFERRED_PROCESS, this::toggleStageLayout);
        this.updateStageView();
        this.toggleStageLayout();
    }

    public void dispose() {
    }

    @VisibleForTesting
    public <S extends Stage, T extends StageView> void bind(@NotNull Class<S> clazz, @NotNull BiFunction<StudioProfilersView, S, T> constructor) {
        if (clazz == null) {
            StudioProfilersView.$$$reportNull$$$0(2);
        }
        if (constructor == null) {
            StudioProfilersView.$$$reportNull$$$0(3);
        }
        this.myBinder.bind(clazz, constructor);
    }

    @VisibleForTesting
    @NotNull
    CommonButton getZoomInButton() {
        CommonButton commonButton = this.myZoomIn;
        if (commonButton == null) {
            StudioProfilersView.$$$reportNull$$$0(4);
        }
        return commonButton;
    }

    @VisibleForTesting
    @NotNull
    CommonButton getZoomOutButton() {
        CommonButton commonButton = this.myZoomOut;
        if (commonButton == null) {
            StudioProfilersView.$$$reportNull$$$0(5);
        }
        return commonButton;
    }

    @VisibleForTesting
    @NotNull
    CommonButton getResetZoomButton() {
        CommonButton commonButton = this.myResetZoom;
        if (commonButton == null) {
            StudioProfilersView.$$$reportNull$$$0(6);
        }
        return commonButton;
    }

    @VisibleForTesting
    @NotNull
    CommonButton getFrameSelectionButton() {
        CommonButton commonButton = this.myFrameSelection;
        if (commonButton == null) {
            StudioProfilersView.$$$reportNull$$$0(7);
        }
        return commonButton;
    }

    @VisibleForTesting
    @NotNull
    JToggleButton getGoLiveButton() {
        JToggleButton jToggleButton = this.myGoLive;
        if (jToggleButton == null) {
            StudioProfilersView.$$$reportNull$$$0(8);
        }
        return jToggleButton;
    }

    @VisibleForTesting
    public StageView getStageView() {
        return this.myStageView;
    }

    @VisibleForTesting
    @NotNull
    SessionsView getSessionsView() {
        SessionsView sessionsView = this.mySessionsView;
        if (sessionsView == null) {
            StudioProfilersView.$$$reportNull$$$0(9);
        }
        return sessionsView;
    }

    private void initializeStageUi() {
        this.myToolbar = new JPanel(new BorderLayout());
        JPanel leftToolbar = new JPanel(ProfilerLayout.createToolbarLayout());
        this.myToolbar.setBorder(AdtUiUtils.DEFAULT_BOTTOM_BORDER);
        this.myToolbar.setPreferredSize(new Dimension(0, ProfilerLayout.TOOLBAR_HEIGHT));
        this.myCommonToolbar = new JPanel(ProfilerLayout.createToolbarLayout());
        CommonButton button = new CommonButton(StudioIcons.Common.BACK_ARROW);
        button.addActionListener(action -> {
            this.myProfiler.setMonitoringStage();
            this.myProfiler.getIdeServices().getFeatureTracker().trackGoBack();
        });
        this.myCommonToolbar.add((Component)button);
        this.myCommonToolbar.add((Component)new FlatSeparator());
        FlatComboBox stageCombo = new FlatComboBox();
        JComboBoxView<Class, ProfilerAspect> stages = new JComboBoxView<Class, ProfilerAspect>((JComboBox<Class>)stageCombo, this.myProfiler, ProfilerAspect.STAGE, this.myProfiler::getDirectStages, this.myProfiler::getStageClass, stage -> {
            this.myProfiler.getIdeServices().getFeatureTracker().trackSelectMonitor();
            this.myProfiler.setNewStage((Class<? extends Stage>)stage);
        });
        stageCombo.setRenderer(new StageComboBoxRenderer());
        stages.bind();
        this.myCommonToolbar.add((Component)stageCombo);
        this.myCommonToolbar.add((Component)new FlatSeparator());
        this.myMonitoringToolbar = new JPanel(ProfilerLayout.createToolbarLayout());
        if (!this.myProfiler.getIdeServices().getFeatureConfig().isSessionsEnabled()) {
            FlatComboBox deviceCombo = new FlatComboBox();
            JComboBoxView<Common.Device, ProfilerAspect> devices = new JComboBoxView<Common.Device, ProfilerAspect>((JComboBox<Common.Device>)deviceCombo, this.myProfiler, ProfilerAspect.DEVICES, this.myProfiler::getDevices, this.myProfiler::getDevice, this.myProfiler::setDevice);
            devices.bind();
            deviceCombo.setRenderer(new DeviceComboBoxRenderer());
            FlatComboBox processCombo = new FlatComboBox();
            JComboBoxView<Common.Process, ProfilerAspect> processes = new JComboBoxView<Common.Process, ProfilerAspect>((JComboBox<Common.Process>)processCombo, this.myProfiler, ProfilerAspect.PROCESSES, this.myProfiler::getProcesses, this.myProfiler::getProcess, this.myProfiler::setProcess);
            processes.bind();
            processCombo.setRenderer(new ProcessComboBoxRenderer());
            this.myMonitoringToolbar.add((Component)deviceCombo);
            this.myMonitoringToolbar.add((Component)processCombo);
            leftToolbar.add(this.myMonitoringToolbar);
        }
        leftToolbar.add(this.myCommonToolbar);
        this.myToolbar.add((Component)leftToolbar, "West");
        JPanel rightToolbar = new JPanel(ProfilerLayout.createToolbarLayout());
        this.myToolbar.add((Component)rightToolbar, "East");
        rightToolbar.setBorder((Border)new JBEmptyBorder(0, 0, 0, 2));
        if (!this.myProfiler.getIdeServices().getFeatureConfig().isSessionsEnabled()) {
            CommonButton endSession = new CommonButton("End Session");
            endSession.setFont(ProfilerFonts.STANDARD_FONT);
            endSession.setBorder((Border)new JBEmptyBorder(4, 7, 4, 7));
            endSession.addActionListener(event -> this.myProfiler.stop());
            endSession.setToolTipText("Stop profiling and close tab");
            rightToolbar.add((Component)endSession);
            rightToolbar.add((Component)new FlatSeparator());
        }
        ProfilerTimeline timeline = this.myProfiler.getTimeline();
        this.myZoomOut = new CommonButton(StudioIcons.Common.ZOOM_OUT);
        this.myZoomOut.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Common.ZOOM_OUT));
        this.myZoomOut.addActionListener(event -> {
            timeline.zoomOut();
            this.myProfiler.getIdeServices().getFeatureTracker().trackZoomOut();
        });
        ProfilerAction zoomOutAction = new ProfilerAction.Builder(ZOOM_OUT).setContainerComponent(this.myStageComponent).setActionRunnable(() -> this.myZoomOut.doClick(0)).setKeyStrokes(KeyStroke.getKeyStroke(45, SHORTCUT_MODIFIER_MASK_NUMBER), KeyStroke.getKeyStroke(109, SHORTCUT_MODIFIER_MASK_NUMBER)).build();
        this.myZoomOut.setToolTipText(zoomOutAction.getDefaultToolTipText());
        rightToolbar.add((Component)this.myZoomOut);
        this.myZoomIn = new CommonButton(StudioIcons.Common.ZOOM_IN);
        this.myZoomIn.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Common.ZOOM_IN));
        this.myZoomIn.addActionListener(event -> {
            timeline.zoomIn();
            this.myProfiler.getIdeServices().getFeatureTracker().trackZoomIn();
        });
        ProfilerAction zoomInAction = new ProfilerAction.Builder(ZOOM_IN).setContainerComponent(this.myStageComponent).setActionRunnable(() -> this.myZoomIn.doClick(0)).setKeyStrokes(KeyStroke.getKeyStroke(521, SHORTCUT_MODIFIER_MASK_NUMBER), KeyStroke.getKeyStroke(61, SHORTCUT_MODIFIER_MASK_NUMBER), KeyStroke.getKeyStroke(107, SHORTCUT_MODIFIER_MASK_NUMBER)).build();
        this.myZoomIn.setToolTipText(zoomInAction.getDefaultToolTipText());
        rightToolbar.add((Component)this.myZoomIn);
        this.myResetZoom = new CommonButton(StudioIcons.Common.RESET_ZOOM);
        this.myResetZoom.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Common.RESET_ZOOM));
        this.myResetZoom.addActionListener(event -> {
            timeline.resetZoom();
            this.myProfiler.getIdeServices().getFeatureTracker().trackResetZoom();
        });
        ProfilerAction resetZoomAction = new ProfilerAction.Builder("Reset zoom").setContainerComponent(this.myStageComponent).setActionRunnable(() -> this.myResetZoom.doClick(0)).setKeyStrokes(KeyStroke.getKeyStroke(96, 0), KeyStroke.getKeyStroke(48, 0)).build();
        this.myResetZoom.setToolTipText(resetZoomAction.getDefaultToolTipText());
        rightToolbar.add((Component)this.myResetZoom);
        this.myFrameSelection = new CommonButton(StudioIcons.Common.ZOOM_SELECT);
        this.myFrameSelection.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Common.ZOOM_SELECT));
        this.myFrameSelection.addActionListener(event -> timeline.frameViewToRange(timeline.getSelectionRange()));
        this.myFrameSelectionAction = new ProfilerAction.Builder("Zoom to Selection").setContainerComponent(this.myStageComponent).setActionRunnable(() -> this.myFrameSelection.doClick(0)).setEnableBooleanSupplier(() -> !timeline.getSelectionRange().isEmpty()).build();
        this.myFrameSelection.setToolTipText(this.myFrameSelectionAction.getDefaultToolTipText());
        rightToolbar.add((Component)this.myFrameSelection);
        timeline.getSelectionRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, () -> this.myFrameSelection.setEnabled(this.myFrameSelectionAction.isEnabled()));
        this.myGoLiveToolbar = new JPanel(ProfilerLayout.createToolbarLayout());
        this.myGoLiveToolbar.add((Component)new FlatSeparator());
        this.myGoLive = new CommonToggleButton("", StudioIcons.Profiler.Toolbar.GOTO_LIVE);
        this.myGoLive.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Profiler.Toolbar.GOTO_LIVE));
        this.myGoLive.setFont(ProfilerFonts.H4_FONT);
        this.myGoLive.setHorizontalTextPosition(2);
        this.myGoLive.setHorizontalAlignment(2);
        this.myGoLive.setBorder((Border)new JBEmptyBorder(3, 7, 3, 7));
        ProfilerAction attachAction = new ProfilerAction.Builder(ATTACH_LIVE).setContainerComponent(this.myStageComponent).setActionRunnable(() -> this.myGoLive.doClick(0)).setEnableBooleanSupplier(() -> this.myGoLive.isEnabled() && !this.myGoLive.isSelected() && this.myStageView.navigationControllersEnabled()).setKeyStrokes(KeyStroke.getKeyStroke(39, SHORTCUT_MODIFIER_MASK_NUMBER)).build();
        ProfilerAction detachAction = new ProfilerAction.Builder(DETACH_LIVE).setContainerComponent(this.myStageComponent).setActionRunnable(() -> this.myGoLive.doClick(0)).setEnableBooleanSupplier(() -> this.myGoLive.isEnabled() && this.myGoLive.isSelected() && this.myStageView.navigationControllersEnabled()).setKeyStrokes(KeyStroke.getKeyStroke(32, 0)).build();
        this.myGoLive.setToolTipText(detachAction.getDefaultToolTipText());
        this.myGoLive.addActionListener(event -> {
            timeline.toggleStreaming();
            this.myProfiler.getIdeServices().getFeatureTracker().trackToggleStreaming();
        });
        this.myGoLive.addChangeListener(e -> {
            boolean isSelected = this.myGoLive.isSelected();
            this.myGoLive.setIcon(isSelected ? StudioIcons.Profiler.Toolbar.PAUSE_LIVE : StudioIcons.Profiler.Toolbar.GOTO_LIVE);
            this.myGoLive.setToolTipText(isSelected ? detachAction.getDefaultToolTipText() : attachAction.getDefaultToolTipText());
        });
        timeline.addDependency(this).onChange((Enum)ProfilerTimeline.Aspect.STREAMING, this::updateStreaming);
        this.myGoLiveToolbar.add(this.myGoLive);
        rightToolbar.add(this.myGoLiveToolbar);
        ProfilerContextMenu.createIfAbsent(this.myStageComponent).add(attachAction, detachAction, ContextMenuItem.SEPARATOR, zoomInAction, zoomOutAction);
        this.myProfiler.getSessionsManager().addDependency(this).onChange((Enum)SessionAspect.SELECTED_SESSION, this::toggleTimelineButtons);
        this.toggleTimelineButtons();
        this.myStageToolbar = new JPanel(new BorderLayout());
        this.myToolbar.add((Component)this.myStageToolbar, "Center");
        this.myStageComponent.add((Component)this.myToolbar, "North");
        this.myStageComponent.add((Component)this.myStageCenterComponent, "Center");
        this.updateStreaming();
    }

    private void toggleTimelineButtons() {
        boolean isAlive = this.myProfiler.getSessionsManager().isSessionAlive();
        if (isAlive) {
            boolean waitForAgent;
            Profiler.AgentStatusResponse agentStatus = this.myProfiler.getAgentStatus();
            boolean bl = waitForAgent = agentStatus.getStatus() != Profiler.AgentStatusResponse.Status.ATTACHED && agentStatus.getIsAgentAttachable();
            if (waitForAgent) {
                this.myZoomOut.setEnabled(false);
                this.myZoomIn.setEnabled(false);
                this.myResetZoom.setEnabled(false);
                this.myFrameSelection.setEnabled(false);
                this.myGoLive.setEnabled(false);
                this.myGoLive.setSelected(false);
            } else {
                this.myZoomOut.setEnabled(true);
                this.myZoomIn.setEnabled(true);
                this.myResetZoom.setEnabled(true);
                this.myFrameSelection.setEnabled(this.myFrameSelectionAction.isEnabled());
                this.myGoLive.setEnabled(true);
                this.myGoLive.setSelected(true);
            }
        } else {
            boolean isValidSession = !Common.Session.getDefaultInstance().equals((Object)this.myProfiler.getSessionsManager().getSelectedSession());
            this.myZoomOut.setEnabled(isValidSession);
            this.myZoomIn.setEnabled(isValidSession);
            this.myResetZoom.setEnabled(isValidSession);
            this.myFrameSelection.setEnabled(isValidSession && this.myFrameSelectionAction.isEnabled());
            this.myGoLive.setEnabled(false);
            this.myGoLive.setSelected(false);
        }
    }

    private void toggleSessionsPanel(boolean isCollapsed) {
        if (isCollapsed) {
            this.mySplitter.setDividerMouseZoneSize(-1);
            this.mySessionsView.getComponent().setMinimumSize(SessionsView.getComponentMinimizeSize(false));
            this.mySplitter.setFirstSize(0);
        } else {
            this.mySplitter.setDividerMouseZoneSize(JBUIScale.scale((int)10));
            this.mySessionsView.getComponent().setMinimumSize(SessionsView.getComponentMinimizeSize(true));
            this.mySplitter.setFirstSize(this.myProfiler.getIdeServices().getPersistentProfilerPreferences().getInt("SESSION_EXPANDED_WIDTH", 0));
        }
        this.mySplitter.revalidate();
        this.mySplitter.repaint();
    }

    private void updateStreaming() {
        this.myGoLive.setSelected(this.myProfiler.getTimeline().isStreaming());
    }

    private void updateStageView() {
        Stage stage = this.myProfiler.getStage();
        if (this.myStageView != null && this.myStageView.getStage() == stage) {
            return;
        }
        this.myStageView = this.myBinder.build(this, stage);
        SwingUtilities.invokeLater(() -> this.myStageView.getComponent().requestFocusInWindow());
        this.myStageCenterComponent.removeAll();
        this.myStageCenterComponent.add((Component)this.myStageView.getComponent(), STAGE_VIEW_CARD);
        this.myStageCenterComponent.add((Component)this.myStageLoadingPanel.getComponent(), LOADING_VIEW_CARD);
        this.myStageCenterComponent.revalidate();
        this.myStageToolbar.removeAll();
        this.myStageToolbar.add((Component)this.myStageView.getToolbar(), "Center");
        this.myStageToolbar.revalidate();
        this.myToolbar.setVisible(this.myStageView.isToolbarVisible());
        this.myGoLiveToolbar.setVisible(this.myStageView.navigationControllersEnabled());
        boolean topLevel = this.myStageView == null || this.myStageView.needsProcessSelection();
        this.myMonitoringToolbar.setVisible(topLevel);
        this.myCommonToolbar.setVisible(!topLevel && this.myStageView.navigationControllersEnabled());
    }

    private void toggleStageLayout() {
        boolean loading = this.myProfiler.getAutoProfilingEnabled() && this.myProfiler.getPreferredProcessName() != null && !this.myProfiler.getSessionsManager().isSessionAlive();
        Profiler.AgentStatusResponse agentStatus = this.myProfiler.getAgentStatus();
        if (loading |= agentStatus.getStatus() != Profiler.AgentStatusResponse.Status.ATTACHED && agentStatus.getIsAgentAttachable()) {
            this.myStageLoadingPanel.startLoading();
            this.myStageCenterCardLayout.show(this.myStageCenterComponent, LOADING_VIEW_CARD);
        } else {
            this.myStageLoadingPanel.stopLoading();
            this.myStageCenterCardLayout.show(this.myStageCenterComponent, STAGE_VIEW_CARD);
        }
        this.toggleTimelineButtons();
    }

    @NotNull
    public JLayeredPane getComponent() {
        ProfilerLayeredPane profilerLayeredPane = this.myLayeredPane;
        if (profilerLayeredPane == null) {
            StudioProfilersView.$$$reportNull$$$0(10);
        }
        return profilerLayeredPane;
    }

    public void installCommonMenuItems(@NotNull JComponent component) {
        if (component == null) {
            StudioProfilersView.$$$reportNull$$$0(11);
        }
        ContextMenuInstaller contextMenuInstaller = this.getIdeProfilerComponents().createContextMenuInstaller();
        ProfilerContextMenu.createIfAbsent(this.myStageComponent).getContextMenuItems().forEach(item -> contextMenuInstaller.installGenericContextMenu(component, (ContextMenuItem)item));
    }

    @VisibleForTesting
    final JPanel getStageComponent() {
        return this.myStageComponent;
    }

    @VisibleForTesting
    final JComponent getStageLoadingComponent() {
        return this.myStageLoadingPanel.getComponent();
    }

    @VisibleForTesting
    final JComponent getStageViewComponent() {
        return this.myStageView.getComponent();
    }

    @NotNull
    public IdeProfilerComponents getIdeProfilerComponents() {
        IdeProfilerComponents ideProfilerComponents = this.myIdeProfilerComponents;
        if (ideProfilerComponents == null) {
            StudioProfilersView.$$$reportNull$$$0(12);
        }
        return ideProfilerComponents;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profiler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProfilerComponents";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/StudioProfilersView";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/StudioProfilersView";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getZoomInButton";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getZoomOutButton";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResetZoomButton";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameSelectionButton";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGoLiveButton";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionsView";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeProfilerComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "bind";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "installCommonMenuItems";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    public static class StageComboBoxRenderer
    extends ColoredListCellRenderer<Class> {
        private static ImmutableMap<Class<? extends Stage>, String> CLASS_TO_NAME = ImmutableMap.of(CpuProfilerStage.class, (Object)"CPU", MemoryProfilerStage.class, (Object)"MEMORY", NetworkProfilerStage.class, (Object)"NETWORK", EnergyProfilerStage.class, (Object)"ENERGY");

        protected void customizeCellRenderer(@NotNull JList list, Class value, int index, boolean selected, boolean hasFocus) {
            String name;
            if (list == null) {
                StageComboBoxRenderer.$$$reportNull$$$0(0);
            }
            this.append((name = (String)CLASS_TO_NAME.get((Object)value)) == null ? "[UNKNOWN]" : name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/profilers/StudioProfilersView$StageComboBoxRenderer", "customizeCellRenderer"));
        }
    }

    @VisibleForTesting
    public static class ProcessComboBoxRenderer
    extends ColoredListCellRenderer<Common.Process> {
        @NotNull
        private final String myEmptyText = "No debuggable processes";

        protected void customizeCellRenderer(@NotNull JList list, Common.Process value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                ProcessComboBoxRenderer.$$$reportNull$$$0(0);
            }
            if (value != null) {
                this.renderProcessName(value);
            } else {
                this.append(this.getEmptyText(), SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        }

        private void renderProcessName(@NotNull Common.Process process) {
            if (process == null) {
                ProcessComboBoxRenderer.$$$reportNull$$$0(1);
            }
            String name = process.getName();
            int index = name.lastIndexOf(46);
            this.append(name.substring(0, index + 1), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.append(name.substring(index + 1), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            this.append(String.format(" (%1$d)", process.getPid()), SimpleTextAttributes.GRAY_ATTRIBUTES);
            if (process.getState() != Common.Process.State.ALIVE) {
                this.append(" [DEAD]", SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
            }
        }

        @NotNull
        @VisibleForTesting
        public String getEmptyText() {
            if ("No debuggable processes" == null) {
                ProcessComboBoxRenderer.$$$reportNull$$$0(2);
            }
            return "No debuggable processes";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/StudioProfilersView$ProcessComboBoxRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/StudioProfilersView$ProcessComboBoxRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEmptyText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "customizeCellRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "renderProcessName";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @VisibleForTesting
    public static class DeviceComboBoxRenderer
    extends ColoredListCellRenderer<Common.Device> {
        @NotNull
        private final String myEmptyText = "No connected devices";

        protected void customizeCellRenderer(@NotNull JList list, Common.Device value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                DeviceComboBoxRenderer.$$$reportNull$$$0(0);
            }
            if (value != null) {
                this.renderDeviceName(value);
            } else {
                this.append(this.getEmptyText(), SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        }

        public void renderDeviceName(@NotNull Common.Device d) {
            String serial;
            String suffix;
            if (d == null) {
                DeviceComboBoxRenderer.$$$reportNull$$$0(1);
            }
            String manufacturer = d.getManufacturer();
            String model = d.getModel();
            if (model.endsWith(suffix = String.format("-%s", serial = d.getSerial()))) {
                model = model.substring(0, model.length() - suffix.length());
            }
            if (!StringUtil.isEmpty((String)manufacturer)) {
                this.append(String.format("%s ", manufacturer), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            }
            this.append(model, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            this.append(String.format(" (%1$s)", serial), SimpleTextAttributes.GRAY_ATTRIBUTES);
            Common.Device.State state = d.getState();
            if (state != Common.Device.State.ONLINE && state != Common.Device.State.UNSPECIFIED) {
                this.append(String.format(" [%s]", state), SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
            }
        }

        @NotNull
        @VisibleForTesting
        public String getEmptyText() {
            if ("No connected devices" == null) {
                DeviceComboBoxRenderer.$$$reportNull$$$0(2);
            }
            return "No connected devices";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "d";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/StudioProfilersView$DeviceComboBoxRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/StudioProfilersView$DeviceComboBoxRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEmptyText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "customizeCellRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "renderDeviceName";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

