/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ContentType {
    BMP,
    CSV,
    GIF,
    HTML,
    JPEG,
    JPG,
    JSON,
    PNG,
    WEBP,
    XML,
    DEFAULT;

    private static final ImmutableSet<ContentType> IMAGE_TYPES;
    private static final Map<ContentType, FileType> FILE_TYPE_MAP;

    public boolean isImageType() {
        return IMAGE_TYPES.contains((Object)this);
    }

    @Nullable
    public FileType getFileType() {
        return FILE_TYPE_MAP.containsKey((Object)this) ? FILE_TYPE_MAP.get((Object)this) : null;
    }

    @NotNull
    public static ContentType get(@NotNull String type) {
        if (type == null) {
            ContentType.$$$reportNull$$$0(0);
        }
        for (ContentType contentType : ContentType.values()) {
            if (!type.equalsIgnoreCase(contentType.name())) continue;
            ContentType contentType2 = contentType;
            if (contentType2 == null) {
                ContentType.$$$reportNull$$$0(1);
            }
            return contentType2;
        }
        ContentType contentType = DEFAULT;
        if (contentType == null) {
            ContentType.$$$reportNull$$$0(2);
        }
        return contentType;
    }

    @NotNull
    public static ContentType fromMimeType(@NotNull String mimeType) {
        String[] typeAndSubType;
        if (mimeType == null) {
            ContentType.$$$reportNull$$$0(3);
        }
        if ((typeAndSubType = mimeType.split("/", 2)).length < 2) {
            ContentType contentType = DEFAULT;
            if (contentType == null) {
                ContentType.$$$reportNull$$$0(4);
            }
            return contentType;
        }
        String[] subTypeAndSuffix = typeAndSubType[1].split("\\+", 2);
        ContentType contentType = ContentType.get(subTypeAndSuffix[subTypeAndSuffix.length - 1]);
        if (contentType == null) {
            ContentType.$$$reportNull$$$0(5);
        }
        return contentType;
    }

    static {
        IMAGE_TYPES = ImmutableSet.of((Object)((Object)BMP), (Object)((Object)GIF), (Object)((Object)JPEG), (Object)((Object)JPG), (Object)((Object)PNG), (Object)((Object)WEBP), (Object[])new ContentType[0]);
        FILE_TYPE_MAP = new ImmutableMap.Builder().put((Object)CSV, (Object)FileTypeManager.getInstance().getStdFileType("CSV")).put((Object)HTML, (Object)StdFileTypes.HTML).put((Object)JSON, (Object)FileTypeManager.getInstance().getStdFileType("JSON")).put((Object)XML, (Object)StdFileTypes.XML).build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/ContentType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mimeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/ContentType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "fromMimeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromMimeType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

