/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.poller;

import com.android.tools.datastore.database.UnifiedEventsTable;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profiler.proto.ProfilerServiceGrpc;
import io.grpc.StatusRuntimeException;
import org.jetbrains.annotations.NotNull;

public class UnifiedEventsDataPoller
extends PollRunner {
    private long myLastPollTimestamp;
    @NotNull
    private final int myStreamId;
    @NotNull
    private final UnifiedEventsTable myTable;
    @NotNull
    private final ProfilerServiceGrpc.ProfilerServiceBlockingStub myEventPollingService;

    public UnifiedEventsDataPoller(int streamId, @NotNull UnifiedEventsTable unifiedEventsTable, @NotNull ProfilerServiceGrpc.ProfilerServiceBlockingStub pollingService) {
        if (unifiedEventsTable == null) {
            UnifiedEventsDataPoller.$$$reportNull$$$0(0);
        }
        if (pollingService == null) {
            UnifiedEventsDataPoller.$$$reportNull$$$0(1);
        }
        super(POLLING_DELAY_NS);
        this.myEventPollingService = pollingService;
        this.myStreamId = streamId;
        this.myTable = unifiedEventsTable;
    }

    @Override
    public void poll() throws StatusRuntimeException {
        Profiler.GetEventsRequest request = Profiler.GetEventsRequest.newBuilder().setFromTimestamp(this.myLastPollTimestamp).setToTimestamp(Long.MAX_VALUE).build();
        Profiler.GetEventsResponse response = this.myEventPollingService.getEvents(request);
        this.myTable.insertUnifiedEvents(this.myStreamId, response.getEventsList());
        if (response.getEventsCount() > 0) {
            this.myLastPollTimestamp = ((Profiler.Event)response.getEventsList().get(response.getEventsCount() - 1)).getTimestamp();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "unifiedEventsTable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "pollingService";
                break;
            }
        }
        objectArray[1] = "com/android/tools/datastore/poller/UnifiedEventsDataPoller";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

