/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.poller;

import com.android.tools.datastore.LogService;
import com.android.tools.datastore.database.MemoryLiveAllocationTable;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.nativeSymbolizer.NativeSymbolizer;
import com.android.tools.nativeSymbolizer.NopSymbolizer;
import com.android.tools.nativeSymbolizer.Symbol;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profiler.proto.ProfilerServiceGrpc;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeSymbolsPoller
extends PollRunner {
    private static final int MAX_SYMBOLS_PER_REQUEST = 1000;
    @NotNull
    private final MemoryLiveAllocationTable myLiveAllocationTable;
    @NotNull
    private final Common.Session mySession;
    @NotNull
    private final NativeSymbolizer mySymbolizer;
    @NotNull
    private ProfilerServiceGrpc.ProfilerServiceBlockingStub myProfilerService;
    @NotNull
    private final LogService myLogService;
    @Nullable
    private Common.Process myProcess;

    public NativeSymbolsPoller(@NotNull Common.Session session, @NotNull MemoryLiveAllocationTable liveAllocationTable, @NotNull NativeSymbolizer symbolizer, @NotNull ProfilerServiceGrpc.ProfilerServiceBlockingStub profilerService, @NotNull LogService logService) {
        if (session == null) {
            NativeSymbolsPoller.$$$reportNull$$$0(0);
        }
        if (liveAllocationTable == null) {
            NativeSymbolsPoller.$$$reportNull$$$0(1);
        }
        if (symbolizer == null) {
            NativeSymbolsPoller.$$$reportNull$$$0(2);
        }
        if (profilerService == null) {
            NativeSymbolsPoller.$$$reportNull$$$0(3);
        }
        if (logService == null) {
            NativeSymbolsPoller.$$$reportNull$$$0(4);
        }
        super(POLLING_DELAY_NS);
        this.myProcess = null;
        this.mySession = session;
        this.myLiveAllocationTable = liveAllocationTable;
        this.mySymbolizer = symbolizer;
        this.myProfilerService = profilerService;
        this.myLogService = logService;
    }

    @Override
    public void poll() {
        if (this.mySymbolizer instanceof NopSymbolizer) {
            return;
        }
        if (this.myProcess == null) {
            this.myProcess = this.findProcess();
            if (this.myProcess == null) {
                return;
            }
        }
        List<MemoryProfiler.NativeCallStack.NativeFrame> framesToSymbolize = this.myLiveAllocationTable.queryNotsymbolizedNativeFrames(this.mySession, 1000);
        ArrayList<MemoryProfiler.NativeCallStack.NativeFrame> symbolizedFrames = new ArrayList<MemoryProfiler.NativeCallStack.NativeFrame>(framesToSymbolize.size());
        for (MemoryProfiler.NativeCallStack.NativeFrame frame : framesToSymbolize) {
            MemoryProfiler.NativeCallStack.NativeFrame symbolizedFrame = this.symbolize(frame);
            symbolizedFrames.add(symbolizedFrame);
        }
        if (!symbolizedFrames.isEmpty()) {
            this.myLiveAllocationTable.updateSymbolizedNativeFrames(this.mySession, symbolizedFrames);
        }
    }

    @Nullable
    private Common.Process findProcess() {
        Profiler.GetProcessesRequest request = Profiler.GetProcessesRequest.newBuilder().setDeviceId(this.mySession.getDeviceId()).build();
        Profiler.GetProcessesResponse response = this.myProfilerService.getProcesses(request);
        for (Common.Process process : response.getProcessList()) {
            if (process.getPid() != this.mySession.getPid()) continue;
            return process;
        }
        return null;
    }

    @NotNull
    private MemoryProfiler.NativeCallStack.NativeFrame symbolize(MemoryProfiler.NativeCallStack.NativeFrame frame) {
        long offset = frame.getModuleOffset();
        Symbol symbol = null;
        try {
            long prevInstructionOffset = this.getOffsetOfPreviousInstruction(offset);
            symbol = this.mySymbolizer.symbolize(this.myProcess.getAbiCpuArch(), frame.getModuleName(), prevInstructionOffset);
        }
        catch (IOException | RuntimeException e) {
            this.getLogger().warn(e);
        }
        if (symbol == null) {
            String unfoundSymbolName = String.format("0x%x", offset);
            MemoryProfiler.NativeCallStack.NativeFrame nativeFrame = frame.toBuilder().setSymbolName(unfoundSymbolName).build();
            if (nativeFrame == null) {
                NativeSymbolsPoller.$$$reportNull$$$0(5);
            }
            return nativeFrame;
        }
        MemoryProfiler.NativeCallStack.NativeFrame nativeFrame = frame.toBuilder().setSymbolName(symbol.getName()).setModuleName(symbol.getModule()).setFileName(symbol.getSourceFile()).setLineNumber(symbol.getLineNumber()).build();
        if (nativeFrame == null) {
            NativeSymbolsPoller.$$$reportNull$$$0(6);
        }
        return nativeFrame;
    }

    private long getOffsetOfPreviousInstruction(long offset) {
        return offset - 1L;
    }

    @NotNull
    private LogService.Logger getLogger() {
        LogService.Logger logger = this.myLogService.getLogger(NativeSymbolsPoller.class.getCanonicalName());
        if (logger == null) {
            NativeSymbolsPoller.$$$reportNull$$$0(7);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "liveAllocationTable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolizer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilerService";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logService";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/poller/NativeSymbolsPoller";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/poller/NativeSymbolsPoller";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "symbolize";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

