/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profiler.protobuf3jarjar.InvalidProtocolBufferException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UnifiedEventsTable
extends DataStoreTable<Statements> {
    @Override
    public void prepareStatements() {
        try {
            for (Statements statement : Statements.values()) {
                this.createStatement(statement, statement.getStatement());
            }
        }
        catch (SQLException ex) {
            UnifiedEventsTable.onError(ex);
        }
    }

    @Override
    public void initialize(@NotNull Connection connection) {
        if (connection == null) {
            UnifiedEventsTable.$$$reportNull$$$0(0);
        }
        super.initialize(connection);
        try {
            this.createTable("UnifiedEventsTable", "StreamId INTEGER NOT NULL", "SessionId INTEGER NOT NULL", "EventId INTEGER NOT NULL", "Kind INTEGER NOT NULL", "Type INTEGER NOT NULL", "Timestamp INTEGER NOT NULL", "Data BLOB");
            this.createUniqueIndex("UnifiedEventsTable", "StreamId", "SessionId", "EventId", "Kind", "Type", "Timestamp");
        }
        catch (SQLException ex) {
            UnifiedEventsTable.onError(ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void insertUnifiedEvents(long streamId, @NotNull List<Profiler.Event> list) {
        void eventList;
        if (list == null) {
            UnifiedEventsTable.$$$reportNull$$$0(1);
        }
        this.executeBatch(Statements.INSERT, eventList, event -> new Object[]{streamId, event.getSessionId(), event.getEventId(), event.getKind().getNumber(), event.getType().getNumber(), event.getTimestamp(), event.toByteArray()});
    }

    public List<Profiler.Event> queryUnifiedEvents(@NotNull Profiler.GetEventsRequest request) {
        if (request == null) {
            UnifiedEventsTable.$$$reportNull$$$0(2);
        }
        return this.queryUnifiedEvents(Statements.QUERY_WITHIN_TIME, request.getFromTimestamp(), request.getToTimestamp());
    }

    public List<Profiler.EventGroup> queryUnifiedEventGroups(@NotNull Profiler.GetEventGroupsRequest request) {
        if (request == null) {
            UnifiedEventsTable.$$$reportNull$$$0(3);
        }
        ArrayList<Number> params = new ArrayList<Number>();
        StringBuilder sql = new StringBuilder("SELECT [Data] From [UnifiedEventsTable] WHERE Kind = ?");
        params.add(request.getKind().getNumber());
        if (request.getSessionId() != 0L) {
            sql.append(" AND SessionId = ?");
            params.add(request.getSessionId());
        }
        if (request.getFromTimestamp() != 0L) {
            sql.append(" AND Timestamp >= ?");
            params.add(request.getFromTimestamp());
        }
        if (request.getToTimestamp() != 0L) {
            sql.append(" AND Timestamp <= ?");
            params.add(request.getToTimestamp());
        }
        ArrayList<Profiler.EventGroup> groups = new ArrayList<Profiler.EventGroup>();
        try {
            ResultSet results = this.executeOneTimeQuery(sql.toString(), params.toArray());
            HashMap<Long, Profiler.EventGroup.Builder> builderGroups = new HashMap<Long, Profiler.EventGroup.Builder>();
            while (results.next()) {
                Profiler.Event event = (Profiler.Event)Profiler.Event.parser().parseFrom(results.getBytes(1));
                Profiler.EventGroup.Builder group = builderGroups.computeIfAbsent(event.getEventId(), key -> Profiler.EventGroup.newBuilder());
                group.addEvents(event);
            }
            builderGroups.values().stream().forEach(builder -> groups.add(builder.build()));
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            UnifiedEventsTable.onError(ex);
        }
        return groups;
    }

    private List<Profiler.Event> queryUnifiedEvents(Statements stmt, Object ... args) {
        ArrayList<Profiler.Event> records = new ArrayList<Profiler.Event>();
        try {
            ResultSet results = this.executeQuery(stmt, args);
            while (results.next()) {
                records.add((Profiler.Event)Profiler.Event.parser().parseFrom(results.getBytes(1)));
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            UnifiedEventsTable.onError(ex);
        }
        return records;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventList";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/datastore/database/UnifiedEventsTable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "initialize";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "insertUnifiedEvents";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "queryUnifiedEvents";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "queryUnifiedEventGroups";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Statements {
        INSERT("INSERT OR IGNORE INTO [UnifiedEventsTable] (StreamId, SessionId, EventId, Kind, Type, Timestamp, Data) VALUES (?, ?, ?, ?, ?, ?, ?)"),
        QUERY_WITHIN_TIME("SELECT Data FROM [UnifiedEventsTable] WHERE Timestamp >= ? AND Timestamp <= ?");

        @NotNull
        private final String mySqlStatement;

        private Statements(String sqlStatement) {
            if (sqlStatement == null) {
                Statements.$$$reportNull$$$0(0);
            }
            this.mySqlStatement = sqlStatement;
        }

        @NotNull
        public String getStatement() {
            String string = this.mySqlStatement;
            if (string == null) {
                Statements.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqlStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/datastore/database/UnifiedEventsTable$Statements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/datastore/database/UnifiedEventsTable$Statements";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

