/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.protobuf3jarjar.ByteString;
import com.android.tools.profiler.protobuf3jarjar.GeneratedMessageV3;
import com.android.tools.profiler.protobuf3jarjar.InvalidProtocolBufferException;
import com.android.tools.profiler.protobuf3jarjar.Message;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryStatsTable
extends DataStoreTable<MemoryStatements> {
    @Override
    public void initialize(@NotNull Connection connection) {
        if (connection == null) {
            MemoryStatsTable.$$$reportNull$$$0(0);
        }
        super.initialize(connection);
        try {
            this.createTable("Memory_Samples", "Session INTEGER NOT NULL", "Timestamp INTEGER", "Type INTEGER", "Data BLOB", "PRIMARY KEY(Session, Timestamp, Type)");
            this.createTable("Memory_AllocationInfo", "Session INTEGER NOT NULL", "StartTime INTEGER", "EndTime INTEGER", "InfoData BLOB", "LegacyEventsData BLOB", "LegacyDumpData BLOB", "PRIMARY KEY(Session, StartTime)");
            this.createTable("Memory_LegacyAllocationStack", "Session INTEGER NOT NULL", "Id INTEGER", "Data BLOB", "PRIMARY KEY(Session, Id)");
            this.createTable("Memory_LegacyAllocatedClass", "Session INTEGER NOT NULL", "Id INTEGER", "Data BLOB", "PRIMARY KEY(Session, Id)");
            this.createTable("Memory_HeapDump", "Session INTEGER NOT NULL", "StartTime INTEGER", "EndTime INTEGER", "Status INTEGER", "InfoData BLOB", "DumpData BLOB", "PRIMARY KEY(Session, StartTime)");
        }
        catch (SQLException ex) {
            MemoryStatsTable.onError(ex);
        }
    }

    @Override
    public void prepareStatements() {
        try {
            for (MemoryStatements statement : MemoryStatements.values()) {
                this.createStatement(statement, statement.getStatement());
            }
        }
        catch (SQLException ex) {
            MemoryStatsTable.onError(ex);
        }
    }

    @NotNull
    public MemoryProfiler.MemoryData getData(@NotNull MemoryProfiler.MemoryRequest request) {
        if (request == null) {
            MemoryStatsTable.$$$reportNull$$$0(1);
        }
        long sessionId = request.getSession().getSessionId();
        long startTime = request.getStartTime();
        long endTime = request.getEndTime();
        List<MemoryProfiler.MemoryData.MemorySample> memorySamples = this.getResultsInfo(MemoryStatements.QUERY_MEMORY, sessionId, startTime, endTime, MemoryProfiler.MemoryData.MemorySample.getDefaultInstance());
        List<MemoryProfiler.MemoryData.AllocStatsSample> allocStatsSamples = this.getResultsInfo(MemoryStatements.QUERY_ALLOC_STATS, sessionId, startTime, endTime, MemoryProfiler.MemoryData.AllocStatsSample.getDefaultInstance());
        List<MemoryProfiler.MemoryData.GcStatsSample> gcStatsSamples = this.getResultsInfo(MemoryStatements.QUERY_GC_STATS, sessionId, startTime, endTime, MemoryProfiler.MemoryData.GcStatsSample.getDefaultInstance());
        List<MemoryProfiler.HeapDumpInfo> heapDumpSamples = this.getResultsInfo(MemoryStatements.QUERY_HEAP_INFO_BY_TIME, sessionId, startTime, endTime, MemoryProfiler.HeapDumpInfo.getDefaultInstance());
        List<MemoryProfiler.AllocationsInfo> allocationSamples = this.getResultsInfo(MemoryStatements.QUERY_ALLOCATION_INFO_BY_TIME, sessionId, startTime, endTime, MemoryProfiler.AllocationsInfo.getDefaultInstance());
        MemoryProfiler.MemoryData memoryData = MemoryProfiler.MemoryData.newBuilder().addAllMemSamples(memorySamples).addAllAllocStatsSamples(allocStatsSamples).addAllGcStatsSamples(gcStatsSamples).addAllHeapDumpInfos(heapDumpSamples).addAllAllocationsInfo(allocationSamples).build();
        if (memoryData == null) {
            MemoryStatsTable.$$$reportNull$$$0(2);
        }
        return memoryData;
    }

    public void insertMemory(@NotNull Common.Session session, @NotNull List<MemoryProfiler.MemoryData.MemorySample> samples) {
        if (session == null) {
            MemoryStatsTable.$$$reportNull$$$0(3);
        }
        if (samples == null) {
            MemoryStatsTable.$$$reportNull$$$0(4);
        }
        for (MemoryProfiler.MemoryData.MemorySample sample : samples) {
            this.execute(MemoryStatements.INSERT_SAMPLE, session.getSessionId(), sample.getTimestamp(), MemorySamplesType.MEMORY.ordinal(), sample.toByteArray());
        }
    }

    public void insertAllocStats(@NotNull Common.Session session, @NotNull List<MemoryProfiler.MemoryData.AllocStatsSample> samples) {
        if (session == null) {
            MemoryStatsTable.$$$reportNull$$$0(5);
        }
        if (samples == null) {
            MemoryStatsTable.$$$reportNull$$$0(6);
        }
        for (MemoryProfiler.MemoryData.AllocStatsSample sample : samples) {
            this.execute(MemoryStatements.INSERT_SAMPLE, session.getSessionId(), sample.getTimestamp(), MemorySamplesType.ALLOC_STATS.ordinal(), sample.toByteArray());
        }
    }

    public void insertGcStats(@NotNull Common.Session session, @NotNull List<MemoryProfiler.MemoryData.GcStatsSample> samples) {
        if (session == null) {
            MemoryStatsTable.$$$reportNull$$$0(7);
        }
        if (samples == null) {
            MemoryStatsTable.$$$reportNull$$$0(8);
        }
        for (MemoryProfiler.MemoryData.GcStatsSample sample : samples) {
            this.execute(MemoryStatements.INSERT_SAMPLE, session.getSessionId(), sample.getStartTime(), MemorySamplesType.GC_STATS.ordinal(), sample.toByteArray());
        }
    }

    public void insertOrReplaceHeapInfo(@NotNull Common.Session session, @NotNull MemoryProfiler.HeapDumpInfo info) {
        if (session == null) {
            MemoryStatsTable.$$$reportNull$$$0(9);
        }
        if (info == null) {
            MemoryStatsTable.$$$reportNull$$$0(10);
        }
        this.execute(MemoryStatements.INSERT_OR_REPLACE_HEAP_INFO, session.getSessionId(), info.getStartTime(), info.getEndTime(), MemoryProfiler.DumpDataResponse.Status.NOT_READY.ordinal(), info.toByteArray());
    }

    public MemoryProfiler.DumpDataResponse.Status getHeapDumpStatus(@NotNull Common.Session session, long dumpTime) {
        if (session == null) {
            MemoryStatsTable.$$$reportNull$$$0(11);
        }
        try {
            ResultSet result = this.executeQuery(MemoryStatements.QUERY_HEAP_STATUS_BY_ID, session.getSessionId(), dumpTime);
            if (result.next()) {
                return MemoryProfiler.DumpDataResponse.Status.forNumber((int)result.getInt(1));
            }
        }
        catch (SQLException ex) {
            MemoryStatsTable.onError(ex);
        }
        return MemoryProfiler.DumpDataResponse.Status.NOT_FOUND;
    }

    public List<MemoryProfiler.HeapDumpInfo> getHeapDumpInfoByRequest(@NotNull Common.Session session, @NotNull MemoryProfiler.ListDumpInfosRequest request) {
        if (session == null) {
            MemoryStatsTable.$$$reportNull$$$0(12);
        }
        if (request == null) {
            MemoryStatsTable.$$$reportNull$$$0(13);
        }
        return this.getResultsInfo(MemoryStatements.QUERY_HEAP_INFO_BY_TIME, session.getSessionId(), request.getStartTime(), request.getEndTime(), MemoryProfiler.HeapDumpInfo.getDefaultInstance());
    }

    /*
     * WARNING - void declaration
     */
    public void insertHeapDumpData(@NotNull Common.Session session, long dumpTime, @NotNull MemoryProfiler.DumpDataResponse.Status status, @NotNull ByteString byteString) {
        void data;
        if (session == null) {
            MemoryStatsTable.$$$reportNull$$$0(14);
        }
        if (status == null) {
            MemoryStatsTable.$$$reportNull$$$0(15);
        }
        if (byteString == null) {
            MemoryStatsTable.$$$reportNull$$$0(16);
        }
        this.execute(MemoryStatements.UPDATE_HEAP_DUMP, data.toByteArray(), status.getNumber(), session.getSessionId(), dumpTime);
    }

    @Nullable
    public byte[] getHeapDumpData(@NotNull Common.Session session, long dumpTime) {
        if (session == null) {
            MemoryStatsTable.$$$reportNull$$$0(17);
        }
        try {
            ResultSet resultSet = this.executeQuery(MemoryStatements.QUERY_HEAP_DUMP_BY_ID, session.getSessionId(), dumpTime);
            if (resultSet.next()) {
                return resultSet.getBytes(1);
            }
        }
        catch (SQLException ex) {
            MemoryStatsTable.onError(ex);
        }
        return null;
    }

    public void insertOrReplaceAllocationsInfo(@NotNull Common.Session session, @NotNull MemoryProfiler.AllocationsInfo info) {
        if (session == null) {
            MemoryStatsTable.$$$reportNull$$$0(18);
        }
        if (info == null) {
            MemoryStatsTable.$$$reportNull$$$0(19);
        }
        this.execute(MemoryStatements.INSERT_OR_REPLACE_ALLOCATIONS_INFO, session.getSessionId(), info.getStartTime(), info.getEndTime(), info.toByteArray());
    }

    /*
     * WARNING - void declaration
     */
    public void updateLegacyAllocationEvents(@NotNull Common.Session session, long trackingStartTime, @NotNull MemoryProfiler.LegacyAllocationEventsResponse legacyAllocationEventsResponse) {
        void allocationData;
        if (session == null) {
            MemoryStatsTable.$$$reportNull$$$0(20);
        }
        if (legacyAllocationEventsResponse == null) {
            MemoryStatsTable.$$$reportNull$$$0(21);
        }
        this.execute(MemoryStatements.UPDATE_LEGACY_ALLOCATIONS_INFO_EVENTS, allocationData.toByteArray(), session.getSessionId(), trackingStartTime);
    }

    /*
     * WARNING - void declaration
     */
    public void updateLegacyAllocationDump(@NotNull Common.Session session, long trackingStartTime, byte[] byArray) {
        void data;
        if (session == null) {
            MemoryStatsTable.$$$reportNull$$$0(22);
        }
        this.execute(MemoryStatements.UPDATE_LEGACY_ALLOCATIONS_INFO_DUMP, data, session.getSessionId(), trackingStartTime);
    }

    @Nullable
    public MemoryProfiler.AllocationsInfo getAllocationsInfo(@NotNull Common.Session session, long trackingStartTime) {
        if (session == null) {
            MemoryStatsTable.$$$reportNull$$$0(23);
        }
        try {
            byte[] bytes;
            ResultSet results = this.executeQuery(MemoryStatements.QUERY_ALLOCATION_INFO_BY_ID, session.getSessionId(), trackingStartTime);
            if (results.next() && (bytes = results.getBytes(1)) != null) {
                return MemoryProfiler.AllocationsInfo.parseFrom((byte[])bytes);
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            MemoryStatsTable.onError(ex);
        }
        return null;
    }

    @Nullable
    public MemoryProfiler.LegacyAllocationEventsResponse getLegacyAllocationData(@NotNull Common.Session session, long trackingStartTime) {
        if (session == null) {
            MemoryStatsTable.$$$reportNull$$$0(24);
        }
        try {
            byte[] bytes;
            ResultSet resultSet = this.executeQuery(MemoryStatements.QUERY_LEGACY_ALLOCATION_EVENTS_BY_ID, session.getSessionId(), trackingStartTime);
            if (resultSet.next() && (bytes = resultSet.getBytes(1)) != null) {
                return MemoryProfiler.LegacyAllocationEventsResponse.parseFrom((byte[])resultSet.getBytes(1));
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            MemoryStatsTable.onError(ex);
        }
        return null;
    }

    @Nullable
    public byte[] getLegacyAllocationDumpData(@NotNull Common.Session session, long trackingStartTime) {
        if (session == null) {
            MemoryStatsTable.$$$reportNull$$$0(25);
        }
        try {
            ResultSet resultSet = this.executeQuery(MemoryStatements.QUERY_LEGACY_ALLOCATION_DUMP_BY_ID, session.getSessionId(), trackingStartTime);
            if (resultSet.next()) {
                return resultSet.getBytes(1);
            }
        }
        catch (SQLException ex) {
            MemoryStatsTable.onError(ex);
        }
        return null;
    }

    public void insertLegacyAllocationContext(@NotNull Common.Session session, @NotNull List<MemoryProfiler.AllocatedClass> classes, @NotNull List<MemoryProfiler.AllocationStack> stacks) {
        if (session == null) {
            MemoryStatsTable.$$$reportNull$$$0(26);
        }
        if (classes == null) {
            MemoryStatsTable.$$$reportNull$$$0(27);
        }
        if (stacks == null) {
            MemoryStatsTable.$$$reportNull$$$0(28);
        }
        classes.forEach(klass -> this.execute(MemoryStatements.INSERT_LEGACY_ALLOCATED_CLASS, session.getSessionId(), klass.getClassId(), klass.toByteArray()));
        stacks.forEach(stack -> this.execute(MemoryStatements.INSERT_LEGACY_ALLOCATION_STACK, session.getSessionId(), stack.getStackId(), stack.toByteArray()));
    }

    @NotNull
    public MemoryProfiler.AllocationContextsResponse getLegacyAllocationContexts(@NotNull MemoryProfiler.LegacyAllocationContextsRequest request) {
        if (request == null) {
            MemoryStatsTable.$$$reportNull$$$0(29);
        }
        MemoryProfiler.AllocationContextsResponse.Builder builder = MemoryProfiler.AllocationContextsResponse.newBuilder();
        try {
            MemoryProfiler.AllocatedClass data;
            int i;
            for (i = 0; i < request.getClassIdsCount(); ++i) {
                ResultSet classResultSet = this.executeQuery(MemoryStatements.QUERY_LEGACY_ALLOCATED_CLASS, request.getSession().getSessionId(), request.getClassIds(i));
                if (!classResultSet.next()) continue;
                data = ((MemoryProfiler.AllocatedClass.Builder)MemoryProfiler.AllocatedClass.newBuilder().mergeFrom(classResultSet.getBytes(1))).build();
                builder.addAllocatedClasses(data);
            }
            for (i = 0; i < request.getStackIdsCount(); ++i) {
                ResultSet stackResultSet = this.executeQuery(MemoryStatements.QUERY_LEGACY_ALLOCATION_STACK, request.getSession().getSessionId(), request.getStackIds(i));
                if (!stackResultSet.next()) continue;
                data = ((MemoryProfiler.AllocationStack.Builder)MemoryProfiler.AllocationStack.newBuilder().mergeFrom(stackResultSet.getBytes(1))).build();
                builder.addAllocationStacks((MemoryProfiler.AllocationStack)data);
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            MemoryStatsTable.onError(ex);
        }
        MemoryProfiler.AllocationContextsResponse allocationContextsResponse = builder.build();
        if (allocationContextsResponse == null) {
            MemoryStatsTable.$$$reportNull$$$0(30);
        }
        return allocationContextsResponse;
    }

    /*
     * WARNING - void declaration
     */
    private <T extends GeneratedMessageV3> List<T> getResultsInfo(@NotNull MemoryStatements query, long sessionId, long startTime, long l, @NotNull T t) {
        if (query == null) {
            MemoryStatsTable.$$$reportNull$$$0(31);
        }
        if (t == null) {
            MemoryStatsTable.$$$reportNull$$$0(32);
        }
        ArrayList<GeneratedMessageV3> datas = new ArrayList<GeneratedMessageV3>();
        try {
            void endTime;
            ResultSet resultSet = this.executeQuery(query, sessionId, startTime, (long)endTime);
            while (resultSet.next()) {
                void defaultInstance;
                Message data = defaultInstance.toBuilder().mergeFrom(resultSet.getBytes(1)).build();
                datas.add((GeneratedMessageV3)data);
            }
        }
        catch (InvalidProtocolBufferException | ClassCastException | SQLException ex) {
            MemoryStatsTable.onError(ex);
        }
        return datas;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: 
            case 13: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/database/MemoryStatsTable";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "samples";
                break;
            }
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allocationData";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stacks";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/database/MemoryStatsTable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getLegacyAllocationContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 2: 
            case 30: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "insertMemory";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "insertAllocStats";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "insertGcStats";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "insertOrReplaceHeapInfo";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getHeapDumpStatus";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getHeapDumpInfoByRequest";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "insertHeapDumpData";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getHeapDumpData";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "insertOrReplaceAllocationsInfo";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updateLegacyAllocationEvents";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateLegacyAllocationDump";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAllocationsInfo";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getLegacyAllocationData";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getLegacyAllocationDumpData";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "insertLegacyAllocationContext";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getLegacyAllocationContexts";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getResultsInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum MemorySamplesType {
        MEMORY,
        ALLOC_STATS,
        GC_STATS;

    }

    public static enum MemoryStatements {
        INSERT_SAMPLE("INSERT OR IGNORE INTO Memory_Samples (Session, Timestamp, Type, Data) VALUES (?, ?, ?, ?)"),
        QUERY_MEMORY(String.format("SELECT Data FROM Memory_Samples WHERE Session = ? AND Type = %d AND TimeStamp > ? AND TimeStamp <= ?", MemorySamplesType.MEMORY.ordinal())),
        QUERY_ALLOC_STATS(String.format("SELECT Data FROM Memory_Samples WHERE Session = ? AND Type = %d AND TimeStamp > ? AND TimeStamp <= ?", MemorySamplesType.ALLOC_STATS.ordinal())),
        QUERY_GC_STATS(String.format("SELECT Data FROM Memory_Samples WHERE Session = ? AND Type = %d AND TimeStamp > ? AND TimeStamp <= ?", MemorySamplesType.GC_STATS.ordinal())),
        INSERT_OR_REPLACE_HEAP_INFO("INSERT OR REPLACE INTO Memory_HeapDump (Session, StartTime, EndTime, Status, InfoData) VALUES (?, ?, ?, ?, ?)"),
        UPDATE_HEAP_DUMP("UPDATE Memory_HeapDump SET DumpData = ?, Status = ? WHERE Session = ? AND StartTime = ?"),
        QUERY_HEAP_INFO_BY_TIME("SELECT InfoData FROM Memory_HeapDump where Session = ? AND EndTime > ? AND StartTime <= ?"),
        QUERY_HEAP_DUMP_BY_ID("SELECT DumpData FROM Memory_HeapDump where Session = ? AND StartTime = ?"),
        QUERY_HEAP_STATUS_BY_ID("SELECT Status FROM Memory_HeapDump where Session = ? AND StartTime = ?"),
        INSERT_OR_REPLACE_ALLOCATIONS_INFO("INSERT OR REPLACE INTO Memory_AllocationInfo (Session, StartTime, EndTime, InfoData) VALUES (?, ?, ?, ?)"),
        UPDATE_LEGACY_ALLOCATIONS_INFO_EVENTS("UPDATE Memory_AllocationInfo SET LegacyEventsData = ? WHERE Session = ? AND StartTime = ?"),
        UPDATE_LEGACY_ALLOCATIONS_INFO_DUMP("UPDATE Memory_AllocationInfo SET LegacyDumpData = ? WHERE Session = ? AND StartTime = ?"),
        QUERY_ALLOCATION_INFO_BY_TIME("SELECT InfoData FROM Memory_AllocationInfo WHERE Session = ? AND EndTime > ? AND StartTime <= ?"),
        QUERY_ALLOCATION_INFO_BY_ID("SELECT InfoData from Memory_AllocationInfo WHERE Session = ? AND StartTime = ?"),
        QUERY_LEGACY_ALLOCATION_EVENTS_BY_ID("SELECT LegacyEventsData from Memory_AllocationInfo WHERE Session = ? AND StartTime = ?"),
        QUERY_LEGACY_ALLOCATION_DUMP_BY_ID("SELECT LegacyDumpData from Memory_AllocationInfo WHERE Session = ? AND StartTime = ?"),
        INSERT_LEGACY_ALLOCATION_STACK("INSERT OR IGNORE INTO Memory_LegacyAllocationStack (Session, Id, Data) VALUES (?, ?, ?)"),
        INSERT_LEGACY_ALLOCATED_CLASS("INSERT OR IGNORE INTO Memory_LegacyAllocatedClass (Session, Id, Data) VALUES (?, ?, ?)"),
        QUERY_LEGACY_ALLOCATION_STACK("Select Data FROM Memory_LegacyAllocationStack WHERE Session = ? AND Id = ?"),
        QUERY_LEGACY_ALLOCATED_CLASS("Select Data FROM Memory_LegacyAllocatedClass WHERE Session = ? AND Id = ?");

        @NotNull
        private final String mySqlStatement;

        private MemoryStatements(String sqlStatement) {
            if (sqlStatement == null) {
                MemoryStatements.$$$reportNull$$$0(0);
            }
            this.mySqlStatement = sqlStatement;
        }

        @NotNull
        public String getStatement() {
            String string = this.mySqlStatement;
            if (string == null) {
                MemoryStatements.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqlStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/datastore/database/MemoryStatsTable$MemoryStatements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/datastore/database/MemoryStatsTable$MemoryStatements";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

