/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.psi.PsiElement;
import java.util.EnumSet;
import org.intellij.lang.regexp.AsciiUtil;
import org.intellij.lang.regexp.psi.RegExpBoundary;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedCharacter;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.intellij.lang.regexp.psi.RegExpNumber;
import org.intellij.lang.regexp.psi.RegExpSimpleClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RegExpLanguageHost {
    public static final EnumSet<RegExpGroup.Type> EMPTY_NAMED_GROUP_TYPES = EnumSet.noneOf(RegExpGroup.Type.class);
    public static final String[][] EMPTY_COMPLETION_ITEMS_ARRAY = new String[0][];

    public boolean characterNeedsEscaping(char var1);

    public boolean supportsPerl5EmbeddedComments();

    public boolean supportsPossessiveQuantifiers();

    public boolean supportsPythonConditionalRefs();

    public boolean supportsNamedGroupSyntax(RegExpGroup var1);

    public boolean supportsNamedGroupRefSyntax(RegExpNamedGroupRef var1);

    @NotNull
    default public EnumSet<RegExpGroup.Type> getSupportedNamedGroupTypes(RegExpElement context) {
        EnumSet<RegExpGroup.Type> enumSet = EMPTY_NAMED_GROUP_TYPES;
        if (enumSet == null) {
            RegExpLanguageHost.$$$reportNull$$$0(0);
        }
        return enumSet;
    }

    public boolean supportsExtendedHexCharacter(RegExpChar var1);

    default public boolean isValidGroupName(String name, @NotNull RegExpGroup group) {
        if (group == null) {
            RegExpLanguageHost.$$$reportNull$$$0(1);
        }
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char c2 = name.charAt(i);
            if (AsciiUtil.isLetterOrDigit(c2) || c2 == '_') continue;
            return false;
        }
        return true;
    }

    default public boolean supportsSimpleClass(RegExpSimpleClass simpleClass) {
        return true;
    }

    default public boolean supportsNamedCharacters(RegExpNamedCharacter namedCharacter) {
        return false;
    }

    default public boolean isValidNamedCharacter(RegExpNamedCharacter namedCharacter) {
        return this.supportsNamedCharacters(namedCharacter);
    }

    default public boolean supportsBoundary(RegExpBoundary boundary) {
        switch (boundary.getType()) {
            case UNICODE_EXTENDED_GRAPHEME: {
                return false;
            }
        }
        return true;
    }

    default public boolean supportsLiteralBackspace(RegExpChar aChar) {
        return true;
    }

    default public boolean supportsInlineOptionFlag(char flag, PsiElement context) {
        return true;
    }

    public boolean isValidCategory(@NotNull String var1);

    default public boolean isValidPropertyValue(@NotNull String propertyName, @NotNull String value) {
        if (propertyName == null) {
            RegExpLanguageHost.$$$reportNull$$$0(2);
        }
        if (value == null) {
            RegExpLanguageHost.$$$reportNull$$$0(3);
        }
        return true;
    }

    @NotNull
    public String[][] getAllKnownProperties();

    @Nullable
    public String getPropertyDescription(@Nullable String var1);

    @NotNull
    public String[][] getKnownCharacterClasses();

    @Nullable
    default public Number getQuantifierValue(@NotNull RegExpNumber number) {
        if (number == null) {
            RegExpLanguageHost.$$$reportNull$$$0(4);
        }
        return Double.parseDouble(number.getText());
    }

    default public Lookbehind supportsLookbehind(@NotNull RegExpGroup lookbehindGroup) {
        if (lookbehindGroup == null) {
            RegExpLanguageHost.$$$reportNull$$$0(5);
        }
        return Lookbehind.FULL;
    }

    @NotNull
    default public String[][] getAllPropertyValues(@NotNull String propertyName) {
        if (propertyName == null) {
            RegExpLanguageHost.$$$reportNull$$$0(6);
        }
        if (EMPTY_COMPLETION_ITEMS_ARRAY == null) {
            RegExpLanguageHost.$$$reportNull$$$0(7);
        }
        return EMPTY_COMPLETION_ITEMS_ARRAY;
    }

    default public boolean supportsPropertySyntax(@NotNull PsiElement context) {
        if (context == null) {
            RegExpLanguageHost.$$$reportNull$$$0(8);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/regexp/RegExpLanguageHost";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookbehindGroup";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedNamedGroupTypes";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/regexp/RegExpLanguageHost";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPropertyValues";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isValidGroupName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidPropertyValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getQuantifierValue";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "supportsLookbehind";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAllPropertyValues";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "supportsPropertySyntax";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Lookbehind {
        NOT_SUPPORTED,
        FIXED_LENGTH_ALTERNATION,
        VARIABLE_LENGTH_ALTERNATION,
        FINITE_REPETITION,
        FULL;

    }
}

