/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.TreeVisitor;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public abstract class AbstractTreeWalker<N> {
    private final AtomicReference<State> state;
    private final AsyncPromise<TreePath> promise;
    private final ArrayDeque<ArrayDeque<N>> stack;
    private final Function<? super N, Object> converter;
    private final TreeVisitor visitor;
    private volatile TreePath current;

    public AbstractTreeWalker(@NotNull TreeVisitor visitor) {
        if (visitor == null) {
            AbstractTreeWalker.$$$reportNull$$$0(0);
        }
        this(visitor, node -> node);
    }

    public AbstractTreeWalker(@NotNull TreeVisitor visitor, Function<? super N, Object> converter) {
        if (visitor == null) {
            AbstractTreeWalker.$$$reportNull$$$0(1);
        }
        this.state = new AtomicReference();
        this.promise = new AsyncPromise();
        this.stack = new ArrayDeque();
        this.converter = converter;
        this.visitor = visitor;
    }

    protected abstract Collection<N> getChildren(@NotNull N var1);

    public void setChildren(Collection<? extends N> children2) {
        boolean paused = this.state.compareAndSet(State.PAUSED, State.STARTED);
        if (!paused && !this.state.compareAndSet(State.REQUESTED, State.STARTED)) {
            throw new IllegalStateException();
        }
        this.stack.push(children2 == null ? new ArrayDeque() : new ArrayDeque<N>(children2));
        if (paused) {
            this.processNextPath();
        }
    }

    @NotNull
    public Promise<TreePath> promise() {
        AsyncPromise<TreePath> asyncPromise = this.promise;
        if (asyncPromise == null) {
            AbstractTreeWalker.$$$reportNull$$$0(2);
        }
        return asyncPromise;
    }

    public void setError(@NotNull Throwable error) {
        if (error == null) {
            AbstractTreeWalker.$$$reportNull$$$0(3);
        }
        this.state.set(State.FAILED);
        this.promise.setError(error);
    }

    public void start(N node) {
        this.start(null, node);
    }

    public void start(TreePath parent, N node) {
        TreePath result2 = null;
        if (node != null) {
            try {
                TreePath path = TreePathUtil.createTreePath(parent, this.converter.apply(node));
                switch (this.visitor.visit(path)) {
                    case CONTINUE: {
                        this.update(null, State.REQUESTED);
                        if (this.processChildren(path, node)) {
                            this.processNextPath();
                        }
                        return;
                    }
                    case INTERRUPT: {
                        result2 = path;
                        break;
                    }
                    case SKIP_CHILDREN: {
                        break;
                    }
                }
            }
            catch (Exception error) {
                this.setError(error);
            }
        }
        this.update(null, State.FINISHED);
        this.promise.setResult(result2);
    }

    private boolean processChildren(@NotNull TreePath path, @NotNull N node) {
        if (path == null) {
            AbstractTreeWalker.$$$reportNull$$$0(4);
        }
        if (node == null) {
            AbstractTreeWalker.$$$reportNull$$$0(5);
        }
        this.current = path;
        Collection<N> children2 = this.getChildren(node);
        if (children2 == null) {
            return !this.state.compareAndSet(State.REQUESTED, State.PAUSED);
        }
        this.update(State.REQUESTED, State.STARTED);
        this.stack.push(new ArrayDeque<N>(children2));
        return true;
    }

    private void processNextPath() {
        try {
            while (State.STARTED == this.state.get()) {
                TreePath path;
                ArrayDeque<N> siblings2 = this.stack.peek();
                if (siblings2 == null) {
                    this.update(State.STARTED, State.FINISHED);
                    this.current = null;
                    this.promise.setResult(null);
                    return;
                }
                N node = siblings2.poll();
                if (node == null) {
                    path = this.current;
                    if (path == null) {
                        throw new IllegalStateException();
                    }
                    if (siblings2 != this.stack.poll()) {
                        throw new IllegalStateException();
                    }
                    this.current = path.getParentPath();
                    continue;
                }
                path = TreePathUtil.createTreePath(this.current, this.converter.apply(node));
                switch (this.visitor.visit(path)) {
                    case CONTINUE: {
                        this.update(State.STARTED, State.REQUESTED);
                        if (this.processChildren(path, node)) break;
                        return;
                    }
                    case INTERRUPT: {
                        this.update(State.STARTED, State.FINISHED);
                        this.current = null;
                        this.stack.clear();
                        this.promise.setResult((Object)path);
                        return;
                    }
                    case SKIP_SIBLINGS: {
                        siblings2.clear();
                        break;
                    }
                }
            }
        }
        catch (Exception error) {
            this.setError(error);
        }
    }

    private void update(State expected, @NotNull State replacement) {
        if (replacement == null) {
            AbstractTreeWalker.$$$reportNull$$$0(6);
        }
        if (!this.state.compareAndSet(expected, replacement)) {
            throw new IllegalStateException();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tree/AbstractTreeWalker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tree/AbstractTreeWalker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "promise";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setError";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processChildren";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum State {
        STARTED,
        REQUESTED,
        PAUSED,
        FINISHED,
        FAILED;

    }
}

