/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.ui.mac.TouchbarDataKeys;
import com.intellij.ui.mac.touchbar.BarContainer;
import com.intellij.ui.mac.touchbar.BarType;
import com.intellij.ui.mac.touchbar.BuildUtils;
import com.intellij.ui.mac.touchbar.NST;
import com.intellij.ui.mac.touchbar.ProjectData;
import com.intellij.ui.mac.touchbar.StackTouchBars;
import com.intellij.ui.mac.touchbar.TouchBar;
import com.intellij.ui.mac.touchbar.Utils;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.Predicate;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.InputEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TouchBarsManager {
    private static final Logger LOG = Logger.getInstance(TouchBarsManager.class);
    private static final StackTouchBars ourStack = new StackTouchBars();
    private static final Map<Project, ProjectData> ourProjectData = new HashMap<Project, ProjectData>();
    private static final Map<Container, BarContainer> ourTemporaryBars = new HashMap<Container, BarContainer>();
    private static volatile boolean isInitialized;
    private static final String RUNNERS_GROUP_TOUCHBAR = "RunnerActionsTouchbar";

    public static void onApplicationInitialized() {
        if (!TouchBarsManager.isTouchBarAvailable()) {
            return;
        }
        LOG.assertTrue(!isInitialized);
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            TouchBarsManager.registerProject(project);
        }
        for (Project project : EditorFactory.getInstance().getAllEditors()) {
            TouchBarsManager.registerEditor((Editor)project);
        }
        isInitialized = true;
        EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){

            public void editorCreated(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                TouchBarsManager.registerEditor(event.getEditor());
            }

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                TouchBarsManager.releaseEditor(event.getEditor());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/ui/mac/touchbar/TouchBarsManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "editorCreated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "editorReleased";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)ApplicationManager.getApplication());
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                TouchBarsManager.registerProject(project);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void projectClosed(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(1);
                }
                ApplicationManager.getApplication().assertIsDispatchThread();
                Map map2 = ourProjectData;
                synchronized (map2) {
                    ProjectData pd = (ProjectData)ourProjectData.remove(project);
                    if (pd == null) {
                        LOG.error("project data already was removed: " + project);
                        return;
                    }
                    ourStack.removeAll(pd.getAllContainers());
                    pd.releaseAll();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/ui/mac/touchbar/TouchBarsManager$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectOpened";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        TouchBarsManager._initExecutorsGroup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerProject(final @NotNull Project project) {
        if (project == null) {
            TouchBarsManager.$$$reportNull$$$0(0);
        }
        if (project.isDisposed()) {
            return;
        }
        final ProjectData projectData = new ProjectData(project);
        Map<Project, ProjectData> map2 = ourProjectData;
        synchronized (map2) {
            ProjectData prev = ourProjectData.put(project, projectData);
            if (prev != null) {
                LOG.error("previous project data wasn't removed: " + project);
                prev.releaseAll();
            }
        }
        StartupManager.getInstance((Project)project).registerPostStartupActivity(() -> projectData.get(BarType.DEFAULT).show());
        project.getMessageBus().connect().subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2) {
                if (executorId == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (env == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (handler2 == null) {
                    3.$$$reportNull$$$0(2);
                }
                ApplicationManager.getApplication().invokeLater(() -> TouchBarsManager._updateCurrentTouchbar());
            }

            public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2, int exitCode) {
                if (executorId == null) {
                    3.$$$reportNull$$$0(3);
                }
                if (env == null) {
                    3.$$$reportNull$$$0(4);
                }
                if (handler2 == null) {
                    3.$$$reportNull$$$0(5);
                }
                String twid = env.getExecutor().getToolWindowId();
                ourStack.pop((Condition<? super BarContainer>)((Condition)topContainer -> {
                    if (topContainer.getType() != BarType.DEBUGGER) {
                        return false;
                    }
                    if (!(ToolWindowId.DEBUG.equals(twid) || ToolWindowId.RUN_DASHBOARD.equals(twid) || ToolWindowId.SERVICES.equals(twid))) {
                        return false;
                    }
                    return !TouchBarsManager._hasAnyActiveSession(project, handler2) || projectData.getDbgSessions() <= 0;
                }));
                ApplicationManager.getApplication().invokeLater(() -> TouchBarsManager._updateCurrentTouchbar());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executorId";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "env";
                        break;
                    }
                    case 2: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "handler";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ui/mac/touchbar/TouchBarsManager$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processStarted";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static boolean isTouchBarAvailable() {
        return SystemInfo.isMac && NST.isAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadAll() {
        if (!isInitialized || !TouchBarsManager.isTouchBarAvailable()) {
            return;
        }
        Map<Project, ProjectData> map2 = ourProjectData;
        synchronized (map2) {
            ourProjectData.forEach((p, pd) -> pd.reloadAll());
        }
        ourStack.setTouchBarFromTopContainer();
    }

    public static void onInputEvent(InputEvent e) {
        if (!isInitialized || !TouchBarsManager.isTouchBarAvailable()) {
            return;
        }
        if (e instanceof MouseWheelEvent) {
            return;
        }
        ourStack.updateKeyMask((long)e.getModifiersEx() & ProjectData.getUsedKeyMask());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onFocusEvent(AWTEvent e) {
        if (!TouchBarsManager.isTouchBarAvailable()) {
            return;
        }
        if (!(e.getSource() instanceof Container)) {
            return;
        }
        Container src = (Container)e.getSource();
        if (e.getID() == 1004) {
            Object barForParent;
            if (TouchBarsManager._hasPopup()) {
                return;
            }
            if (TouchBarsManager._hasNonModalDialog() && (barForParent = TouchBarsManager._findByParentComponent(src, ourTemporaryBars.values(), null)) != null) {
                ((BarContainer)barForParent).show();
                return;
            }
            barForParent = ourProjectData;
            synchronized (barForParent) {
                for (ProjectData pd : ourProjectData.values()) {
                    if (pd.isDisposed()) continue;
                    if (pd.checkToolWindowContents(src)) {
                        return;
                    }
                    ProjectData.EditorData ed = pd.findEditorDataByComponent(src);
                    if (ed != null && ed.containerSearch != null) {
                        ourStack.showContainer(ed.containerSearch);
                        return;
                    }
                    BarContainer twbc = pd.findDebugToolWindowByComponent(src);
                    if (twbc == null) continue;
                    ourStack.showContainer(twbc);
                    return;
                }
            }
        }
        if (e.getID() == 1005) {
            BarContainer nonModalDialogParent = TouchBarsManager._findByParentComponent(src, ourTemporaryBars.values(), (Predicate<? super BarContainer>)((Predicate)bc -> bc.isNonModalDialog()));
            if (nonModalDialogParent != null) {
                nonModalDialogParent.hide();
                return;
            }
            Map<Project, ProjectData> map2 = ourProjectData;
            synchronized (map2) {
                for (ProjectData pd : ourProjectData.values()) {
                    ProjectData.EditorData ed;
                    if (pd.isDisposed() || (ed = pd.findEditorDataByComponent(src)) == null || ed.containerSearch == null) continue;
                    ourStack.removeContainer(ed.containerSearch);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerEditor(@NotNull Editor editor) {
        ProjectData projectData;
        Project project;
        if (editor == null) {
            TouchBarsManager.$$$reportNull$$$0(1);
        }
        if ((project = editor.getProject()) == null || project.isDisposed()) {
            return;
        }
        Map<Project, ProjectData> map2 = ourProjectData;
        synchronized (map2) {
            projectData = ourProjectData.get(project);
            if (projectData == null) {
                return;
            }
            projectData.registerEditor(editor);
        }
        if (editor instanceof EditorEx) {
            ((EditorEx)editor).addFocusListener(new FocusChangeListener(){

                @Override
                public void focusGained(@NotNull Editor editor) {
                    boolean hasDebugSession;
                    if (editor == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    projectData.get(BarType.DEFAULT).setOptionalContextVisible(null);
                    boolean bl = hasDebugSession = projectData.getDbgSessions() > 0;
                    if (!hasDebugSession) {
                        ourStack.elevateContainer(projectData.get(BarType.DEFAULT));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/ui/mac/touchbar/TouchBarsManager$4", "focusGained"));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseEditor(@NotNull Editor editor) {
        Project project;
        if (editor == null) {
            TouchBarsManager.$$$reportNull$$$0(2);
        }
        if ((project = editor.getProject()) == null) {
            return;
        }
        Map<Project, ProjectData> map2 = ourProjectData;
        synchronized (map2) {
            ProjectData pd = ourProjectData.get(project);
            if (pd == null) {
                return;
            }
            pd.removeEditor(editor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onUpdateEditorHeader(@NotNull Editor editor, JComponent header) {
        if (editor == null) {
            TouchBarsManager.$$$reportNull$$$0(3);
        }
        if (!isInitialized || !TouchBarsManager.isTouchBarAvailable()) {
            return;
        }
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        Map<Project, ProjectData> map2 = ourProjectData;
        synchronized (map2) {
            ActionGroup actions;
            ProjectData projectData = ourProjectData.get(project);
            if (projectData == null) {
                LOG.error("can't find project data to update header of editor: " + editor + ", project: " + project);
                return;
            }
            ProjectData.EditorData editorData = projectData.getEditorData(editor);
            if (editorData == null) {
                LOG.error("can't find editor-data to update header of editor: " + editor + ", project: " + project);
                return;
            }
            ActionGroup actionGroup = actions = header instanceof DataProvider ? (ActionGroup)TouchbarDataKeys.ACTIONS_KEY.getData((DataProvider)header) : null;
            if (header == null) {
                editorData.editorHeader = null;
                if (editorData.containerSearch != null) {
                    ourStack.removeContainer(editorData.containerSearch);
                }
            } else {
                editorData.editorHeader = header;
                if (editorData.containerSearch == null || editorData.actionsSearch != actions) {
                    if (editorData.containerSearch != null) {
                        ourStack.removeContainer(editorData.containerSearch);
                        editorData.containerSearch.release();
                    }
                    if (actions != null) {
                        editorData.containerSearch = new BarContainer(BarType.EDITOR_SEARCH, TouchBar.buildFromGroup("editor_search_" + header, actions, true, true), null, header);
                        ourStack.showContainer(editorData.containerSearch);
                    }
                }
            }
        }
    }

    @Nullable
    public static Disposable showPopupBar(@NotNull JBPopup popup2, @NotNull JComponent popupComponent) {
        if (popup2 == null) {
            TouchBarsManager.$$$reportNull$$$0(4);
        }
        if (popupComponent == null) {
            TouchBarsManager.$$$reportNull$$$0(5);
        }
        if (!TouchBarsManager.isTouchBarAvailable()) {
            return null;
        }
        if (!(popup2 instanceof ListPopupImpl)) {
            return null;
        }
        ListPopupImpl listPopup = (ListPopupImpl)popup2;
        TouchBar tb = BuildUtils.createScrubberBarFromPopup(listPopup);
        BarContainer container = new BarContainer(BarType.POPUP, tb, null, popupComponent);
        ourTemporaryBars.put(popupComponent, container);
        ourStack.showContainer(container);
        return () -> {
            ourStack.removeContainer(container);
            ourTemporaryBars.remove(popupComponent);
            container.release();
        };
    }

    @Nullable
    public static Disposable showDialogWrapperButtons(@NotNull Container contentPane) {
        if (contentPane == null) {
            TouchBarsManager.$$$reportNull$$$0(6);
        }
        if (!TouchBarsManager.isTouchBarAvailable()) {
            return null;
        }
        ModalityState ms = Utils.getCurrentModalityState();
        BarType btype = ModalityState.NON_MODAL.equals(ms) ? BarType.DIALOG : BarType.MODAL_DIALOG;
        HashMap<TouchbarDataKeys.DlgButtonDesc, JButton> jbuttons = new HashMap<TouchbarDataKeys.DlgButtonDesc, JButton>();
        HashMap<Component, ActionGroup> actions = new HashMap<Component, ActionGroup>();
        TouchBarsManager._findAllTouchbarProviders(actions, jbuttons, contentPane);
        if (jbuttons.isEmpty() && actions.isEmpty()) {
            return null;
        }
        boolean replaceEsc = false;
        boolean emulateEsc = false;
        if (!actions.isEmpty()) {
            ActionGroup ag = (ActionGroup)actions.values().iterator().next();
            TouchbarDataKeys.ActionDesc groupDesc = (TouchbarDataKeys.ActionDesc)ag.getTemplatePresentation().getClientProperty(TouchbarDataKeys.ACTIONS_DESCRIPTOR_KEY);
            replaceEsc = groupDesc == null || groupDesc.isReplaceEsc();
            emulateEsc = true;
        }
        TouchBar tb = new TouchBar("dialog_buttons", replaceEsc, false, emulateEsc);
        BuildUtils.addDialogButtons(tb, jbuttons, actions);
        BarContainer bc = new BarContainer(btype, tb, null, contentPane);
        ourTemporaryBars.put(contentPane, bc);
        ourStack.showContainer(bc);
        BarContainer fbc = bc;
        return () -> {
            ourTemporaryBars.remove(contentPane);
            ourStack.removeContainer(fbc);
            fbc.release();
        };
    }

    public static void showStopRunningBar(List<? extends Pair<RunContentDescriptor, Runnable>> stoppableDescriptors) {
        TouchBar tb = BuildUtils.createStopRunningBar(stoppableDescriptors);
        BarContainer container = new BarContainer(BarType.DIALOG, tb, null, null);
        container.setOnHideCallback(() -> container.release());
        ourStack.showContainer(container);
    }

    static void showContainer(@NotNull BarContainer container) {
        if (container == null) {
            TouchBarsManager.$$$reportNull$$$0(7);
        }
        ourStack.showContainer(container);
    }

    static void hideContainer(@NotNull BarContainer container) {
        if (container == null) {
            TouchBarsManager.$$$reportNull$$$0(8);
        }
        ourStack.removeContainer(container);
    }

    private static boolean _hasAnyActiveSession(Project proj, ProcessHandler handler2) {
        ProcessHandler[] processes = ExecutionManager.getInstance((Project)proj).getRunningProcesses();
        return Arrays.stream(processes).anyMatch(h -> h != null && h != handler2 && !h.isProcessTerminated() && !h.isProcessTerminating());
    }

    private static boolean _hasPopup() {
        return ourTemporaryBars.values().stream().anyMatch(bc -> bc.isPopup());
    }

    private static boolean _hasNonModalDialog() {
        return ourTemporaryBars.values().stream().anyMatch(bc -> bc.isNonModalDialog());
    }

    private static BarContainer _findByParentComponent(Container child2, Collection<? extends BarContainer> candidates, Predicate<? super BarContainer> filter) {
        for (BarContainer barContainer : candidates) {
            if (filter != null && !filter.apply((Object)barContainer) || barContainer.getParentComponent() == null || !SwingUtilities.isDescendingFrom(child2, barContainer.getParentComponent())) continue;
            return barContainer;
        }
        return null;
    }

    private static void _findAllTouchbarProviders(@NotNull Map<Component, ActionGroup> out, @NotNull Map<TouchbarDataKeys.DlgButtonDesc, JButton> out2, @NotNull Container root) {
        if (out == null) {
            TouchBarsManager.$$$reportNull$$$0(9);
        }
        if (out2 == null) {
            TouchBarsManager.$$$reportNull$$$0(10);
        }
        if (root == null) {
            TouchBarsManager.$$$reportNull$$$0(11);
        }
        JBIterable iter = ((JBTreeTraverser)UIUtil.uiTraverser((Component)root).expandAndFilter(c2 -> c2.isVisible())).traverse();
        for (Component component : iter) {
            ActionGroup actions;
            TouchbarDataKeys.DlgButtonDesc desc;
            if (component instanceof JButton && (desc = (TouchbarDataKeys.DlgButtonDesc)UIUtil.getClientProperty((Object)component, (Key)TouchbarDataKeys.DIALOG_BUTTON_DESCRIPTOR_KEY)) != null) {
                out2.put(desc, (JButton)component);
            }
            DataProvider dp = null;
            if (component instanceof DataProvider) {
                dp = (DataProvider)component;
            } else if (component instanceof JComponent) {
                dp = DataManager.getDataProvider((JComponent)((JComponent)component));
            }
            if (dp == null || (actions = (ActionGroup)TouchbarDataKeys.ACTIONS_KEY.getData(dp)) == null) continue;
            out.put(component, actions);
        }
    }

    private static void _updateCurrentTouchbar() {
        TouchBar top = ourStack.getTopTouchBar();
        if (top != null) {
            top.updateActionItems();
        }
    }

    private static void _initExecutorsGroup() {
        ActionManager am = ActionManager.getInstance();
        AnAction runButtons = am.getAction(RUNNERS_GROUP_TOUCHBAR);
        if (runButtons == null) {
            return;
        }
        if (!(runButtons instanceof ActionGroup)) {
            return;
        }
        ActionGroup g = (ActionGroup)runButtons;
        for (Executor exec : ExecutorRegistry.getInstance().getRegisteredExecutors()) {
            if (exec == null || !exec.getId().equals(ToolWindowId.RUN) && !exec.getId().equals(ToolWindowId.DEBUG)) continue;
            AnAction action2 = am.getAction(exec.getId());
            ((DefaultActionGroup)g).add(action2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentPane";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out2";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/mac/touchbar/TouchBarsManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerProject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "releaseEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "onUpdateEditorHeader";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showPopupBar";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "showDialogWrapperButtons";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "showContainer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "hideContainer";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "_findAllTouchbarProviders";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

